/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.ForeignKeyDeleteAction;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.Sequence;
import com.sleepycat.je.SequenceConfig;
import com.sleepycat.je.SequenceExistsException;
import com.sleepycat.je.SequenceNotFoundException;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.rep.NoConsistencyRequiredPolicy;
import com.sleepycat.persist.DatabaseNamer;
import com.sleepycat.persist.IndexNotAvailableException;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.SecondaryIndex;
import com.sleepycat.persist.StoreConfig;
import com.sleepycat.persist.StoreExistsException;
import com.sleepycat.persist.StoreNotFoundException;
import com.sleepycat.persist.evolve.EvolveConfig;
import com.sleepycat.persist.evolve.EvolveEvent;
import com.sleepycat.persist.evolve.EvolveInternal;
import com.sleepycat.persist.evolve.EvolveListener;
import com.sleepycat.persist.evolve.EvolveStats;
import com.sleepycat.persist.evolve.IncompatibleClassException;
import com.sleepycat.persist.evolve.Mutations;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.ComplexFormat;
import com.sleepycat.persist.impl.CompositeKeyFormat;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.PersistCatalog;
import com.sleepycat.persist.impl.PersistComparator;
import com.sleepycat.persist.impl.PersistEntityBinding;
import com.sleepycat.persist.impl.PersistKeyAssigner;
import com.sleepycat.persist.impl.PersistKeyBinding;
import com.sleepycat.persist.impl.PersistKeyCreator;
import com.sleepycat.persist.impl.RefreshException;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.model.DeleteAction;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.model.PrimaryKeyMetadata;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKeyMetadata;
import com.sleepycat.persist.raw.RawObject;
import com.sleepycat.util.RuntimeExceptionWrapper;
import com.sleepycat.util.keyrange.KeyRange;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class Store {
    public static final String NAME_SEPARATOR = "#";
    private static final String NAME_PREFIX = "persist#";
    private static final String DB_NAME_PREFIX = "com.sleepycat.persist.";
    private static final String CATALOG_DB = "com.sleepycat.persist.formats";
    private static final String SEQUENCE_DB = "com.sleepycat.persist.sequences";
    private static Map<Environment, Map<String, PersistCatalog>> catalogPool = new WeakHashMap<Environment, Map<String, PersistCatalog>>();
    private static SyncHook syncHook;
    public static boolean expectFlush;
    private final Environment env;
    private final boolean rawAccess;
    private volatile PersistCatalog catalog;
    private EntityModel model;
    private final StoreConfig storeConfig;
    private final String storeName;
    private final String storePrefix;
    private final Map<String, InternalPrimaryIndex> priIndexMap;
    private final Map<String, InternalSecondaryIndex> secIndexMap;
    private final Map<String, DatabaseConfig> priConfigMap;
    private final Map<String, SecondaryConfig> secConfigMap;
    private final Map<String, PersistKeyBinding> keyBindingMap;
    private Database sequenceDb;
    private final Map<String, Sequence> sequenceMap;
    private final Map<String, SequenceConfig> sequenceConfigMap;
    private final IdentityHashMap<Database, Object> deferredWriteDatabases;
    private final Map<String, Set<String>> inverseRelatedEntityMap;
    private final TransactionConfig autoCommitTxnConfig;
    private final TransactionConfig autoCommitNoWaitTxnConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store(Environment env, String storeName, StoreConfig config, boolean rawAccess) throws StoreExistsException, StoreNotFoundException, IncompatibleClassException, DatabaseException {
        Object dbConfig;
        this.env = env;
        this.storeName = storeName;
        this.rawAccess = rawAccess;
        if (env == null || storeName == null) {
            throw new NullPointerException("env and storeName parameters must not be null");
        }
        this.storeConfig = config != null ? config.clone() : StoreConfig.DEFAULT;
        this.autoCommitTxnConfig = new TransactionConfig();
        this.autoCommitNoWaitTxnConfig = new TransactionConfig();
        this.autoCommitNoWaitTxnConfig.setNoWait(true);
        if (!this.storeConfig.getReplicated()) {
            Durability envDurability = env.getConfig().getDurability();
            Store.configForNonRepDb(this.autoCommitTxnConfig, envDurability);
            Store.configForNonRepDb(this.autoCommitNoWaitTxnConfig, envDurability);
        }
        this.model = config.getModel();
        this.storePrefix = NAME_PREFIX + storeName + NAME_SEPARATOR;
        this.priIndexMap = new HashMap<String, InternalPrimaryIndex>();
        this.secIndexMap = new HashMap<String, InternalSecondaryIndex>();
        this.priConfigMap = new HashMap<String, DatabaseConfig>();
        this.secConfigMap = new HashMap<String, SecondaryConfig>();
        this.keyBindingMap = new HashMap<String, PersistKeyBinding>();
        this.sequenceMap = new HashMap<String, Sequence>();
        this.sequenceConfigMap = new HashMap<String, SequenceConfig>();
        this.deferredWriteDatabases = new IdentityHashMap();
        if (rawAccess) {
            if (this.model != null) {
                throw new IllegalArgumentException("A model may not be specified when opening a RawStore");
            }
            dbConfig = new DatabaseConfig();
            ((DatabaseConfig)dbConfig).setReplicated(this.storeConfig.getReplicated());
            ((DatabaseConfig)dbConfig).setReadOnly(true);
            ((DatabaseConfig)dbConfig).setTransactional(this.storeConfig.getTransactional());
            this.catalog = new PersistCatalog(env, this.storePrefix, this.storePrefix + CATALOG_DB, (DatabaseConfig)dbConfig, null, config.getMutations(), rawAccess, this);
        } else {
            dbConfig = catalogPool;
            synchronized (dbConfig) {
                Map<String, PersistCatalog> catalogMap = catalogPool.get(env);
                if (catalogMap == null) {
                    catalogMap = new HashMap<String, PersistCatalog>();
                    catalogPool.put(env, catalogMap);
                }
                this.catalog = catalogMap.get(storeName);
                if (this.catalog != null) {
                    this.catalog.openExisting();
                } else {
                    DatabaseConfig dbConfig2 = new DatabaseConfig();
                    dbConfig2.setAllowCreate(this.storeConfig.getAllowCreate());
                    dbConfig2.setExclusiveCreate(this.storeConfig.getExclusiveCreate());
                    dbConfig2.setTemporary(this.storeConfig.getTemporary());
                    dbConfig2.setReplicated(this.storeConfig.getReplicated());
                    dbConfig2.setReadOnly(this.storeConfig.getReadOnly());
                    dbConfig2.setTransactional(this.storeConfig.getTransactional());
                    DbCompat.setTypeBtree(dbConfig2);
                    this.catalog = new PersistCatalog(env, this.storePrefix, this.storePrefix + CATALOG_DB, dbConfig2, this.model, config.getMutations(), rawAccess, this);
                    catalogMap.put(storeName, this.catalog);
                }
            }
        }
        this.model = this.catalog.getResolvedModel();
        this.inverseRelatedEntityMap = new HashMap<String, Set<String>>();
        ArrayList<Format> entityFormats = new ArrayList<Format>();
        this.catalog.getEntityFormats(entityFormats);
        for (Format entityFormat : entityFormats) {
            EntityMetadata entityMeta = entityFormat.getEntityMetadata();
            for (SecondaryKeyMetadata secKeyMeta : entityMeta.getSecondaryKeys().values()) {
                String relatedClsName = secKeyMeta.getRelatedEntity();
                if (relatedClsName == null) continue;
                Set<String> inverseClassNames = this.inverseRelatedEntityMap.get(relatedClsName);
                if (inverseClassNames == null) {
                    inverseClassNames = new HashSet<String>();
                    this.inverseRelatedEntityMap.put(relatedClsName, inverseClassNames);
                }
                inverseClassNames.add(entityMeta.getClassName());
            }
        }
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public StoreConfig getConfig() {
        return this.storeConfig.clone();
    }

    public String getStoreName() {
        return this.storeName;
    }

    public static Set<String> getStoreNames(Environment env) throws DatabaseException {
        HashSet<String> set = new HashSet<String>();
        for (String o : env.getDatabaseNames()) {
            String s = o;
            if (!s.startsWith(NAME_PREFIX)) continue;
            int start = NAME_PREFIX.length();
            int end = s.indexOf(NAME_SEPARATOR, start);
            set.add(s.substring(start, end));
        }
        return set;
    }

    public boolean isReplicaUpgradeMode() {
        return this.catalog.isReplicaUpgradeMode();
    }

    public EntityModel getModel() {
        return this.model;
    }

    public Mutations getMutations() {
        return this.catalog.getMutations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <PK, E> PrimaryIndex<PK, E> getPrimaryIndex(Class<PK> primaryKeyClass, String primaryKeyClassName, Class<E> entityClass, String entityClassName) throws DatabaseException, IndexNotAvailableException {
        assert (this.rawAccess && entityClass == RawObject.class || !this.rawAccess && entityClass != RawObject.class);
        assert (this.rawAccess && primaryKeyClassName == null || !this.rawAccess && primaryKeyClassName != null);
        this.checkOpen();
        InternalPrimaryIndex<PK, E> priIndex = this.priIndexMap.get(entityClassName);
        if (priIndex == null) {
            EntityMetadata entityMeta = this.checkEntityClass(entityClassName);
            PrimaryKeyMetadata priKeyMeta = entityMeta.getPrimaryKey();
            if (primaryKeyClassName == null) {
                primaryKeyClassName = priKeyMeta.getClassName();
            } else {
                String expectClsName = SimpleCatalog.keyClassName(priKeyMeta.getClassName());
                if (!primaryKeyClassName.equals(expectClsName)) {
                    throw new IllegalArgumentException("Wrong primary key class: " + primaryKeyClassName + " Correct class is: " + expectClsName);
                }
            }
            PersistEntityBinding entityBinding = new PersistEntityBinding(this.catalog, entityClassName, this.rawAccess);
            PersistKeyBinding keyBinding = this.getKeyBinding(primaryKeyClassName);
            String seqName = priKeyMeta.getSequenceName();
            if (!this.storeConfig.getReadOnly() && seqName != null) {
                entityBinding.keyAssigner = new PersistKeyAssigner(keyBinding, entityBinding, this.getSequence(seqName));
            }
            Transaction txn = null;
            DatabaseConfig dbConfig = this.getPrimaryConfig(entityMeta);
            if (dbConfig.getTransactional() && DbCompat.getThreadTransaction(this.env) == null) {
                txn = this.env.beginTransaction(null, this.autoCommitNoWaitTxnConfig);
            }
            PrimaryOpenState priOpenState = new PrimaryOpenState(entityClassName);
            boolean saveAllowCreate = dbConfig.getAllowCreate();
            boolean success = false;
            try {
                if (this.catalog.isReadOnly()) {
                    dbConfig.setAllowCreate(false);
                }
                Database db = null;
                String dbClassName = this.catalog.getDatabaseClassName(entityClassName);
                if (dbClassName != null) {
                    String[] fileAndDbNames = this.parseDbName(this.storePrefix + dbClassName);
                    try {
                        db = DbCompat.openDatabase(this.env, txn, fileAndDbNames[0], fileAndDbNames[1], dbConfig);
                    }
                    catch (LockConflictException lockConflictException) {
                        // empty catch block
                    }
                }
                if (db == null) {
                    throw new IndexNotAvailableException("PrimaryIndex not yet available on this Replica, entity class: " + entityClassName);
                }
                priOpenState.addDatabase(db);
                priIndex = new InternalPrimaryIndex<PK, E>(db, primaryKeyClass, keyBinding, entityClass, entityBinding);
                this.priIndexMap.put(entityClassName, priIndex);
                if (DbCompat.getDeferredWrite(dbConfig)) {
                    this.deferredWriteDatabases.put(db, null);
                }
                if (!dbConfig.getReadOnly()) {
                    this.openSecondaryIndexes(txn, entityMeta, priOpenState);
                    Set<String> inverseClassNames = this.inverseRelatedEntityMap.get(entityClassName);
                    if (inverseClassNames != null) {
                        for (String relatedClsName : inverseClassNames) {
                            this.getRelatedIndex(relatedClsName);
                        }
                    }
                }
                success = true;
            }
            finally {
                dbConfig.setAllowCreate(saveAllowCreate);
                if (success) {
                    if (txn != null) {
                        txn.commit();
                    }
                } else {
                    if (txn != null) {
                        txn.abort();
                    }
                    priOpenState.undoState();
                }
            }
        }
        return priIndex;
    }

    private PrimaryIndex getRelatedIndex(String relatedClsName) throws DatabaseException {
        PrimaryIndex relatedIndex = this.priIndexMap.get(relatedClsName);
        if (relatedIndex == null) {
            String relatedKeyClsName;
            Class relatedKeyCls;
            Class relatedCls;
            EntityMetadata relatedEntityMeta = this.checkEntityClass(relatedClsName);
            if (this.rawAccess) {
                relatedCls = RawObject.class;
                relatedKeyCls = Object.class;
                relatedKeyClsName = null;
            } else {
                try {
                    relatedCls = this.catalog.resolveClass(relatedClsName);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Related entity class not found: " + relatedClsName);
                }
                relatedKeyClsName = SimpleCatalog.keyClassName(relatedEntityMeta.getPrimaryKey().getClassName());
                relatedKeyCls = this.catalog.resolveKeyClass(relatedKeyClsName);
            }
            relatedIndex = this.getPrimaryIndex(relatedKeyCls, relatedKeyClsName, relatedCls, relatedClsName);
        }
        return relatedIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <SK, PK, E1, E2 extends E1> SecondaryIndex<SK, PK, E2> getSecondaryIndex(PrimaryIndex<PK, E1> primaryIndex, Class<E2> entityClass, String entityClassName, Class<SK> keyClass, String keyClassName, String keyName) throws DatabaseException, IndexNotAvailableException {
        String secName;
        InternalSecondaryIndex<SK, PK, E2> secIndex;
        assert (this.rawAccess && keyClassName == null || !this.rawAccess && keyClassName != null);
        this.checkOpen();
        EntityMetadata entityMeta = null;
        SecondaryKeyMetadata secKeyMeta = null;
        if (entityClass != primaryIndex.getEntityClass()) {
            String declaringClassName;
            entityMeta = this.model.getEntityMetadata(entityClassName);
            assert (entityMeta != null);
            secKeyMeta = this.checkSecKey(entityMeta, keyName);
            String subclassName = entityClass.getName();
            if (!subclassName.equals(declaringClassName = secKeyMeta.getDeclaringClassName())) {
                throw new IllegalArgumentException("Key for subclass " + subclassName + " is declared in a different class: " + Store.makeSecName(declaringClassName, keyName));
            }
            try {
                this.catalog.getFormat(entityClass, false);
            }
            catch (RefreshException e) {
                e.refresh();
                try {
                    this.catalog.getFormat(entityClass, false);
                }
                catch (RefreshException e2) {
                    throw DbCompat.unexpectedException(e2);
                }
            }
        }
        if ((secIndex = this.secIndexMap.get(secName = Store.makeSecName(entityClassName, keyName))) == null) {
            if (entityMeta == null) {
                entityMeta = this.model.getEntityMetadata(entityClassName);
                assert (entityMeta != null);
            }
            if (secKeyMeta == null) {
                secKeyMeta = this.checkSecKey(entityMeta, keyName);
            }
            if (keyClassName == null) {
                keyClassName = this.getSecKeyClass(secKeyMeta);
            } else {
                String expectClsName = this.getSecKeyClass(secKeyMeta);
                if (!keyClassName.equals(expectClsName)) {
                    throw new IllegalArgumentException("Wrong secondary key class: " + keyClassName + " Correct class is: " + expectClsName);
                }
            }
            String dbClassName = this.catalog.getDatabaseClassName(entityClassName);
            String dbKeyName = this.catalog.getDatabaseKeyName(entityClassName, keyName);
            if (dbClassName != null && dbKeyName != null) {
                Transaction txn = null;
                if (this.getPrimaryConfig(entityMeta).getTransactional() && DbCompat.getThreadTransaction(this.env) == null) {
                    txn = this.env.beginTransaction(null, this.autoCommitNoWaitTxnConfig);
                }
                boolean success = false;
                try {
                    secIndex = this.openSecondaryIndex(txn, primaryIndex, entityClass, entityMeta, keyClass, keyClassName, secKeyMeta, secName, Store.makeSecName(dbClassName, dbKeyName), this.catalog.isReadOnly(), null);
                    success = true;
                }
                catch (LockConflictException lockConflictException) {
                }
                finally {
                    if (success) {
                        if (txn != null) {
                            txn.commit();
                        }
                    } else if (txn != null) {
                        txn.abort();
                    }
                }
            }
            if (secIndex == null) {
                throw new IndexNotAvailableException("SecondaryIndex not yet available on this Replica, entity class: " + entityClassName + ", key name: " + keyName);
            }
        }
        return secIndex;
    }

    private void openSecondaryIndexes(Transaction txn, EntityMetadata entityMeta, PrimaryOpenState priOpenState) throws DatabaseException {
        String entityClassName = entityMeta.getClassName();
        PrimaryIndex priIndex = this.priIndexMap.get(entityClassName);
        assert (priIndex != null);
        Class entityClass = priIndex.getEntityClass();
        for (SecondaryKeyMetadata secKeyMeta : entityMeta.getSecondaryKeys().values()) {
            String keyName = secKeyMeta.getKeyName();
            String secName = Store.makeSecName(entityClassName, keyName);
            SecondaryIndex secIndex = this.secIndexMap.get(secName);
            if (secIndex != null) continue;
            String keyClassName = this.getSecKeyClass(secKeyMeta);
            Class keyClass = this.catalog.resolveKeyClass(keyClassName);
            String dbClassName = this.catalog.getDatabaseClassName(entityClassName);
            String dbKeyName = this.catalog.getDatabaseKeyName(entityClassName, keyName);
            if (dbClassName == null || dbKeyName == null) continue;
            this.openSecondaryIndex(txn, priIndex, entityClass, entityMeta, keyClass, keyClassName, secKeyMeta, secName, Store.makeSecName(dbClassName, dbKeyName), this.storeConfig.getSecondaryBulkLoad() || this.catalog.isReadOnly(), priOpenState);
        }
    }

    private <SK, PK, E1, E2 extends E1> InternalSecondaryIndex<SK, PK, E2> openSecondaryIndex(Transaction txn, PrimaryIndex<PK, E1> primaryIndex, Class<E2> entityClass, EntityMetadata entityMeta, Class<SK> keyClass, String keyClassName, SecondaryKeyMetadata secKeyMeta, String secName, String dbSecName, boolean doNotCreate, PrimaryOpenState priOpenState) throws DatabaseException {
        assert (!this.secIndexMap.containsKey(secName));
        String[] fileAndDbNames = this.parseDbName(this.storePrefix + dbSecName);
        SecondaryConfig config = this.getSecondaryConfig(secName, entityMeta, keyClassName, secKeyMeta);
        Database priDb = primaryIndex.getDatabase();
        DatabaseConfig priConfig = priDb.getConfig();
        String relatedClsName = secKeyMeta.getRelatedEntity();
        if (relatedClsName != null) {
            PrimaryIndex relatedIndex = this.getRelatedIndex(relatedClsName);
            config.setForeignKeyDatabase(relatedIndex.getDatabase());
        }
        if (config.getTransactional() != priConfig.getTransactional() || DbCompat.getDeferredWrite(config) != DbCompat.getDeferredWrite(priConfig) || config.getReadOnly() != priConfig.getReadOnly()) {
            throw new IllegalArgumentException("One of these properties was changed to be inconsistent with the associated primary database:  Transactional, DeferredWrite, ReadOnly");
        }
        PersistKeyBinding keyBinding = this.getKeyBinding(keyClassName);
        SecondaryDatabase db = this.openSecondaryDatabase(txn, fileAndDbNames, primaryIndex, secKeyMeta.getKeyName(), config, doNotCreate);
        if (db == null) {
            assert (doNotCreate);
            return null;
        }
        InternalSecondaryIndex<SK, PK, E1> secIndex = new InternalSecondaryIndex<SK, PK, E1>(db, primaryIndex, keyClass, keyBinding, this.getKeyCreator(config));
        this.secIndexMap.put(secName, secIndex);
        if (DbCompat.getDeferredWrite(config)) {
            this.deferredWriteDatabases.put(db, null);
        }
        if (priOpenState != null) {
            priOpenState.addDatabase(db);
            priOpenState.addSecondaryName(secName);
        }
        return secIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecondaryDatabase openSecondaryDatabase(Transaction txn, String[] fileAndDbNames, PrimaryIndex priIndex, String keyName, SecondaryConfig config, boolean doNotCreate) throws DatabaseException {
        assert (config.getAllowPopulate());
        assert (!config.getExclusiveCreate());
        Database priDb = priIndex.getDatabase();
        ComplexFormat entityFormat = (ComplexFormat)((PersistEntityBinding)priIndex.getEntityBinding()).entityFormat;
        boolean saveAllowCreate = config.getAllowCreate();
        boolean saveOverrideDuplicateComparator = config.getOverrideDuplicateComparator();
        Comparator<byte[]> saveDupComparator = config.getDuplicateComparator();
        try {
            SecondaryDatabase db;
            if (doNotCreate) {
                config.setAllowCreate(false);
            }
            if (config.getAllowCreate()) {
                config.setExclusiveCreate(true);
                db = DbCompat.openSecondaryDatabase(this.env, txn, fileAndDbNames[0], fileAndDbNames[1], priDb, config);
                if (db != null) {
                    boolean doFlush = false;
                    if (config.getDuplicateComparator() != null && entityFormat.setSecKeyCorrectlyOrdered(keyName)) {
                        this.catalog.flush(txn);
                        doFlush = true;
                    }
                    assert (!expectFlush || doFlush);
                    SecondaryDatabase secondaryDatabase = db;
                    return secondaryDatabase;
                }
            }
            config.setAllowCreate(false);
            config.setAllowPopulate(false);
            config.setExclusiveCreate(false);
            if (config.getDuplicateComparator() != null && entityFormat.isSecKeyIncorrectlyOrdered(keyName)) {
                config.setOverrideDuplicateComparator(false);
                config.setDuplicateComparator((Comparator<byte[]>)null);
            }
            SecondaryDatabase secondaryDatabase = db = DbCompat.openSecondaryDatabase(this.env, txn, fileAndDbNames[0], fileAndDbNames[1], priDb, config);
            return secondaryDatabase;
        }
        finally {
            config.setAllowPopulate(true);
            config.setExclusiveCreate(false);
            config.setAllowCreate(saveAllowCreate);
            config.setOverrideBtreeComparator(saveOverrideDuplicateComparator);
            config.setDuplicateComparator(saveDupComparator);
        }
    }

    synchronized void checkEntitySubclassSecondaries(EntityMetadata entityMeta, String subclassName) throws DatabaseException {
        if (this.storeConfig.getSecondaryBulkLoad()) {
            return;
        }
        String entityClassName = entityMeta.getClassName();
        for (SecondaryKeyMetadata secKeyMeta : entityMeta.getSecondaryKeys().values()) {
            String keyName = secKeyMeta.getKeyName();
            String secName = Store.makeSecName(entityClassName, keyName);
            if (this.secIndexMap.containsKey(secName)) continue;
            throw new IllegalArgumentException("Entity subclasses defining a secondary key must be registered by calling EntityModel.registerClass or EntityStore.getSubclassIndex before storing an instance of the subclass: " + subclassName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() throws DatabaseException {
        ArrayList<Database> dbs = new ArrayList<Database>();
        Store store = this;
        synchronized (store) {
            dbs.addAll(this.deferredWriteDatabases.keySet());
        }
        for (Database db : dbs) {
            db.sync();
            if (syncHook == null) continue;
            syncHook.onSync(db);
        }
    }

    public void truncateClass(Class entityClass) throws DatabaseException {
        this.truncateClass(null, entityClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void truncateClass(Transaction txn, Class entityClass) throws DatabaseException {
        this.checkOpen();
        this.checkWriteAllowed();
        this.closeClass(entityClass);
        String clsName = entityClass.getName();
        EntityMetadata entityMeta = this.checkEntityClass(clsName);
        boolean autoCommit = false;
        if (this.storeConfig.getTransactional() && txn == null && DbCompat.getThreadTransaction(this.env) == null) {
            txn = this.env.beginTransaction(null, this.autoCommitTxnConfig);
            autoCommit = true;
        }
        boolean success = false;
        try {
            boolean primaryExists = this.truncateIfExists(txn, this.storePrefix + clsName);
            if (primaryExists) {
                Object firstException = null;
                for (SecondaryKeyMetadata keyMeta : entityMeta.getSecondaryKeys().values()) {
                    this.removeIfExists(txn, this.storePrefix + Store.makeSecName(clsName, keyMeta.getKeyName()));
                }
                if (firstException != null) {
                    throw firstException;
                }
            }
            success = true;
        }
        finally {
            if (autoCommit) {
                if (success) {
                    txn.commit();
                } else {
                    txn.abort();
                }
            }
        }
    }

    private boolean truncateIfExists(Transaction txn, String dbName) throws DatabaseException {
        String[] fileAndDbNames = this.parseDbName(dbName);
        return DbCompat.truncateDatabase(this.env, txn, fileAndDbNames[0], fileAndDbNames[1]);
    }

    private boolean removeIfExists(Transaction txn, String dbName) throws DatabaseException {
        String[] fileAndDbNames = this.parseDbName(dbName);
        return DbCompat.removeDatabase(this.env, txn, fileAndDbNames[0], fileAndDbNames[1]);
    }

    public synchronized void closeClass(Class entityClass) throws DatabaseException {
        this.checkOpen();
        String clsName = entityClass.getName();
        EntityMetadata entityMeta = this.checkEntityClass(clsName);
        PrimaryIndex priIndex = this.priIndexMap.get(clsName);
        if (priIndex != null) {
            DatabaseException firstException = null;
            for (SecondaryKeyMetadata keyMeta : entityMeta.getSecondaryKeys().values()) {
                String secName = Store.makeSecName(clsName, keyMeta.getKeyName());
                SecondaryIndex secIndex = this.secIndexMap.get(secName);
                if (secIndex == null) continue;
                SecondaryDatabase db = secIndex.getDatabase();
                firstException = this.closeDb(db, firstException);
                firstException = this.closeDb(secIndex.getKeysDatabase(), firstException);
                this.secIndexMap.remove(secName);
                this.deferredWriteDatabases.remove(db);
            }
            Database db = priIndex.getDatabase();
            firstException = this.closeDb(db, firstException);
            this.priIndexMap.remove(clsName);
            this.deferredWriteDatabases.remove(db);
            if (firstException != null) {
                throw firstException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws DatabaseException {
        DatabaseException firstException;
        block21: {
            if (this.catalog == null) {
                return;
            }
            firstException = null;
            try {
                if (this.rawAccess) {
                    boolean allClosed = this.catalog.close();
                    assert (allClosed);
                } else {
                    Map<Environment, Map<String, PersistCatalog>> allClosed = catalogPool;
                    synchronized (allClosed) {
                        Map<String, PersistCatalog> map = catalogPool.get(this.env);
                        assert (map != null);
                        boolean removeFromCatalog = true;
                        try {
                            removeFromCatalog = this.catalog.close();
                        }
                        finally {
                            if (removeFromCatalog) {
                                map.remove(this.storeName);
                            }
                        }
                    }
                }
                this.catalog = null;
            }
            catch (DatabaseException e) {
                if (firstException != null) break block21;
                firstException = e;
            }
        }
        for (Sequence sequence : this.sequenceMap.values()) {
            try {
                sequence.close();
            }
            catch (DatabaseException e) {
                if (firstException != null) continue;
                firstException = e;
            }
        }
        firstException = this.closeDb(this.sequenceDb, firstException);
        for (SecondaryIndex secondaryIndex : this.secIndexMap.values()) {
            firstException = this.closeDb(secondaryIndex.getDatabase(), firstException);
            firstException = this.closeDb(secondaryIndex.getKeysDatabase(), firstException);
        }
        for (PrimaryIndex primaryIndex : this.priIndexMap.values()) {
            firstException = this.closeDb(primaryIndex.getDatabase(), firstException);
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public synchronized Sequence getSequence(String name) throws DatabaseException {
        this.checkOpen();
        if (this.storeConfig.getReadOnly()) {
            throw new IllegalStateException("Store is read-only");
        }
        Sequence seq = this.sequenceMap.get(name);
        if (seq == null) {
            if (this.sequenceDb == null) {
                String[] fileAndDbNames = this.parseDbName(this.storePrefix + SEQUENCE_DB);
                DatabaseConfig dbConfig = new DatabaseConfig();
                dbConfig.setTransactional(this.storeConfig.getTransactional());
                dbConfig.setAllowCreate(true);
                dbConfig.setReplicated(this.storeConfig.getReplicated());
                dbConfig.setTemporary(this.storeConfig.getTemporary());
                DbCompat.setTypeBtree(dbConfig);
                this.sequenceDb = DbCompat.openDatabase(this.env, null, fileAndDbNames[0], fileAndDbNames[1], dbConfig);
                assert (this.sequenceDb != null);
            }
            DatabaseEntry entry = new DatabaseEntry();
            StringBinding.stringToEntry(name, entry);
            try {
                seq = this.sequenceDb.openSequence(null, entry, this.getSequenceConfig(name));
            }
            catch (SequenceExistsException e) {
                throw DbCompat.unexpectedException(e);
            }
            catch (SequenceNotFoundException e) {
                throw DbCompat.unexpectedException(e);
            }
            this.sequenceMap.put(name, seq);
        }
        return seq;
    }

    public synchronized SequenceConfig getSequenceConfig(String name) {
        this.checkOpen();
        SequenceConfig config = this.sequenceConfigMap.get(name);
        if (config == null) {
            config = new SequenceConfig();
            config.setInitialValue(1L);
            config.setRange(1L, Long.MAX_VALUE);
            config.setCacheSize(100);
            config.setAutoCommitNoSync(true);
            config.setAllowCreate(!this.storeConfig.getReadOnly());
            this.sequenceConfigMap.put(name, config);
        }
        return config;
    }

    public synchronized void setSequenceConfig(String name, SequenceConfig config) {
        this.checkOpen();
        if (config.getExclusiveCreate() || config.getAllowCreate() == this.storeConfig.getReadOnly()) {
            throw new IllegalArgumentException("One of these properties was illegally changed: AllowCreate, ExclusiveCreate");
        }
        if (this.sequenceMap.containsKey(name)) {
            throw new IllegalStateException("Cannot set config after Sequence is open");
        }
        this.sequenceConfigMap.put(name, config);
    }

    public synchronized DatabaseConfig getPrimaryConfig(Class entityClass) {
        this.checkOpen();
        String clsName = entityClass.getName();
        EntityMetadata meta = this.checkEntityClass(clsName);
        return this.getPrimaryConfig(meta).cloneConfig();
    }

    private synchronized DatabaseConfig getPrimaryConfig(EntityMetadata meta) {
        String clsName = meta.getClassName();
        DatabaseConfig config = this.priConfigMap.get(clsName);
        if (config == null) {
            config = new DatabaseConfig();
            config.setTransactional(this.storeConfig.getTransactional());
            config.setAllowCreate(!this.storeConfig.getReadOnly());
            config.setReadOnly(this.storeConfig.getReadOnly());
            DbCompat.setTypeBtree(config);
            config.setReplicated(this.storeConfig.getReplicated());
            config.setTemporary(this.storeConfig.getTemporary());
            config.setDeferredWrite(this.storeConfig.getDeferredWrite());
            config.setOverrideBtreeComparator(true);
            this.setBtreeComparator(config, meta.getPrimaryKey().getClassName());
            this.priConfigMap.put(clsName, config);
        }
        return config;
    }

    public synchronized void setPrimaryConfig(Class entityClass, DatabaseConfig config) {
        this.checkOpen();
        String clsName = entityClass.getName();
        if (this.priIndexMap.containsKey(clsName)) {
            throw new IllegalStateException("Cannot set config after DB is open");
        }
        EntityMetadata meta = this.checkEntityClass(clsName);
        DatabaseConfig dbConfig = this.getPrimaryConfig(meta);
        if (config.getExclusiveCreate() || config.getAllowCreate() == config.getReadOnly() || config.getSortedDuplicates() || config.getTemporary() != dbConfig.getTemporary() || config.getBtreeComparator() != dbConfig.getBtreeComparator()) {
            throw new IllegalArgumentException("One of these properties was illegally changed: AllowCreate, ExclusiveCreate, SortedDuplicates, Temporary or BtreeComparator, ");
        }
        if (!DbCompat.isTypeBtree(config)) {
            throw new IllegalArgumentException("Only type BTREE allowed");
        }
        this.priConfigMap.put(clsName, config);
    }

    public synchronized SecondaryConfig getSecondaryConfig(Class entityClass, String keyName) {
        this.checkOpen();
        String entityClsName = entityClass.getName();
        EntityMetadata entityMeta = this.checkEntityClass(entityClsName);
        SecondaryKeyMetadata secKeyMeta = this.checkSecKey(entityMeta, keyName);
        String keyClassName = this.getSecKeyClass(secKeyMeta);
        String secName = Store.makeSecName(entityClass.getName(), keyName);
        return (SecondaryConfig)this.getSecondaryConfig(secName, entityMeta, keyClassName, secKeyMeta).cloneConfig();
    }

    private SecondaryConfig getSecondaryConfig(String secName, EntityMetadata entityMeta, String keyClassName, SecondaryKeyMetadata secKeyMeta) {
        SecondaryConfig config = this.secConfigMap.get(secName);
        if (config == null) {
            DatabaseConfig priConfig = this.getPrimaryConfig(entityMeta);
            config = new SecondaryConfig();
            config.setTransactional(priConfig.getTransactional());
            config.setAllowCreate(!priConfig.getReadOnly());
            config.setReadOnly(priConfig.getReadOnly());
            DbCompat.setTypeBtree(config);
            config.setReplicated(priConfig.getReplicated());
            config.setTemporary(priConfig.getTemporary());
            config.setDeferredWrite(priConfig.getDeferredWrite());
            config.setOverrideBtreeComparator(true);
            config.setOverrideDuplicateComparator(true);
            config.setAllowPopulate(true);
            Relationship rel = secKeyMeta.getRelationship();
            config.setSortedDuplicates(rel == Relationship.MANY_TO_ONE || rel == Relationship.MANY_TO_MANY);
            this.setBtreeComparator(config, keyClassName);
            config.setDuplicateComparator(priConfig.getBtreeComparator());
            PersistKeyCreator keyCreator = new PersistKeyCreator(this.catalog, entityMeta, keyClassName, secKeyMeta, this.rawAccess);
            if (rel == Relationship.ONE_TO_MANY || rel == Relationship.MANY_TO_MANY) {
                config.setMultiKeyCreator(keyCreator);
            } else {
                config.setKeyCreator(keyCreator);
            }
            DeleteAction deleteAction = secKeyMeta.getDeleteAction();
            if (deleteAction != null) {
                ForeignKeyDeleteAction baseDeleteAction;
                switch (deleteAction) {
                    case ABORT: {
                        baseDeleteAction = ForeignKeyDeleteAction.ABORT;
                        break;
                    }
                    case CASCADE: {
                        baseDeleteAction = ForeignKeyDeleteAction.CASCADE;
                        break;
                    }
                    case NULLIFY: {
                        baseDeleteAction = ForeignKeyDeleteAction.NULLIFY;
                        break;
                    }
                    default: {
                        throw DbCompat.unexpectedState(deleteAction.toString());
                    }
                }
                config.setForeignKeyDeleteAction(baseDeleteAction);
                if (deleteAction == DeleteAction.NULLIFY) {
                    config.setForeignMultiKeyNullifier(keyCreator);
                }
            }
            this.secConfigMap.put(secName, config);
        }
        return config;
    }

    public synchronized void setSecondaryConfig(Class entityClass, String keyName, SecondaryConfig config) {
        this.checkOpen();
        String entityClsName = entityClass.getName();
        EntityMetadata entityMeta = this.checkEntityClass(entityClsName);
        SecondaryKeyMetadata secKeyMeta = this.checkSecKey(entityMeta, keyName);
        String keyClassName = this.getSecKeyClass(secKeyMeta);
        String secName = Store.makeSecName(entityClass.getName(), keyName);
        if (this.secIndexMap.containsKey(secName)) {
            throw new IllegalStateException("Cannot set config after DB is open");
        }
        SecondaryConfig dbConfig = this.getSecondaryConfig(secName, entityMeta, keyClassName, secKeyMeta);
        if (config.getExclusiveCreate() || config.getAllowCreate() == config.getReadOnly() || config.getSortedDuplicates() != dbConfig.getSortedDuplicates() || config.getBtreeComparator() != dbConfig.getBtreeComparator() || config.getDuplicateComparator() != null || config.getTemporary() != dbConfig.getTemporary() || config.getAllowPopulate() != dbConfig.getAllowPopulate() || config.getKeyCreator() != dbConfig.getKeyCreator() || config.getMultiKeyCreator() != dbConfig.getMultiKeyCreator() || config.getForeignKeyNullifier() != dbConfig.getForeignKeyNullifier() || config.getForeignMultiKeyNullifier() != dbConfig.getForeignMultiKeyNullifier() || config.getForeignKeyDeleteAction() != dbConfig.getForeignKeyDeleteAction() || config.getForeignKeyDatabase() != null) {
            throw new IllegalArgumentException("One of these properties was illegally changed:  AllowCreate, ExclusiveCreate, SortedDuplicates, BtreeComparator, DuplicateComparator, Temporary, AllowPopulate, KeyCreator, MultiKeyCreator, ForeignKeyNullifer, ForeignMultiKeyNullifier, ForeignKeyDeleteAction, ForeignKeyDatabase");
        }
        if (!DbCompat.isTypeBtree(config)) {
            throw new IllegalArgumentException("Only type BTREE allowed");
        }
        this.secConfigMap.put(secName, config);
    }

    private static String makeSecName(String entityClsName, String keyName) {
        return entityClsName + NAME_SEPARATOR + keyName;
    }

    static String makePriDbName(String storePrefix, String entityClsName) {
        return storePrefix + entityClsName;
    }

    static String makeSecDbName(String storePrefix, String entityClsName, String keyName) {
        return storePrefix + Store.makeSecName(entityClsName, keyName);
    }

    public String[] parseDbName(String wholeName) {
        return Store.parseDbName(wholeName, this.storeConfig.getDatabaseNamer());
    }

    public static String[] parseDbName(String wholeName, DatabaseNamer namer) {
        String[] result = new String[]{null, wholeName};
        return result;
    }

    String getDbNameMessage(String[] names) {
        return "database: " + names[1];
    }

    private void checkOpen() {
        if (this.catalog == null) {
            throw new IllegalStateException("Store has been closed");
        }
    }

    private void checkWriteAllowed() {
        if (this.catalog.isReadOnly()) {
            throw new IllegalStateException("Store is read-only or is operating as a Replica");
        }
    }

    private EntityMetadata checkEntityClass(String clsName) {
        EntityMetadata meta = this.model.getEntityMetadata(clsName);
        if (meta == null) {
            throw new IllegalArgumentException("Class could not be loaded or is not an entity class: " + clsName);
        }
        return meta;
    }

    private SecondaryKeyMetadata checkSecKey(EntityMetadata entityMeta, String keyName) {
        SecondaryKeyMetadata secKeyMeta = entityMeta.getSecondaryKeys().get(keyName);
        if (secKeyMeta == null) {
            throw new IllegalArgumentException("Not a secondary key: " + Store.makeSecName(entityMeta.getClassName(), keyName));
        }
        return secKeyMeta;
    }

    private String getSecKeyClass(SecondaryKeyMetadata secKeyMeta) {
        String clsName = secKeyMeta.getElementClassName();
        if (clsName == null) {
            clsName = secKeyMeta.getClassName();
        }
        return SimpleCatalog.keyClassName(clsName);
    }

    private PersistKeyBinding getKeyBinding(String keyClassName) {
        PersistKeyBinding binding = this.keyBindingMap.get(keyClassName);
        if (binding == null) {
            binding = new PersistKeyBinding((Catalog)this.catalog, keyClassName, this.rawAccess);
            this.keyBindingMap.put(keyClassName, binding);
        }
        return binding;
    }

    private PersistKeyCreator getKeyCreator(SecondaryConfig config) {
        PersistKeyCreator keyCreator = (PersistKeyCreator)config.getKeyCreator();
        if (keyCreator != null) {
            return keyCreator;
        }
        keyCreator = (PersistKeyCreator)config.getMultiKeyCreator();
        assert (keyCreator != null);
        return keyCreator;
    }

    private void setBtreeComparator(DatabaseConfig config, String clsName) {
        if (!this.rawAccess) {
            Class keyClass;
            PersistKeyBinding binding = this.getKeyBinding(clsName);
            Format format = binding.keyFormat;
            if (format instanceof CompositeKeyFormat && Comparable.class.isAssignableFrom(keyClass = format.getType())) {
                config.setBtreeComparator(new PersistComparator(binding));
            }
        }
    }

    private DatabaseException closeDb(Database db, DatabaseException firstException) {
        block3: {
            if (db != null) {
                try {
                    db.close();
                }
                catch (DatabaseException e) {
                    if (firstException != null) break block3;
                    firstException = e;
                }
            }
        }
        return firstException;
    }

    public EvolveStats evolve(EvolveConfig config) throws DatabaseException {
        this.checkOpen();
        this.checkWriteAllowed();
        if (this.catalog.isReplicaUpgradeMode() || this.catalog.isMetadataStale(null)) {
            this.attemptRefresh();
        }
        PersistCatalog useCatalog = this.catalog;
        ArrayList<Format> toEvolve = new ArrayList<Format>();
        Set<String> configToEvolve = config.getClassesToEvolve();
        if (configToEvolve.isEmpty()) {
            useCatalog.getEntityFormats(toEvolve);
        } else {
            for (String name : configToEvolve) {
                Format format = useCatalog.getFormat(name);
                if (format == null) {
                    throw new IllegalArgumentException("Class to evolve is not persistent: " + name);
                }
                if (!format.isEntity()) {
                    throw new IllegalArgumentException("Class to evolve is not an entity class: " + name);
                }
                toEvolve.add(format);
            }
        }
        EvolveEvent event = EvolveInternal.newEvent();
        for (Format format : toEvolve) {
            if (!format.getEvolveNeeded()) continue;
            this.evolveIndex(format, event, config.getEvolveListener());
            format.setEvolveNeeded(false);
            useCatalog.flush(null);
        }
        return event.getStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evolveIndex(Format format, EvolveEvent event, EvolveListener listener) throws DatabaseException {
        boolean WRITES_PER_TXN = true;
        Class entityClass = format.getType();
        String entityClassName = format.getClassName();
        EntityMetadata meta = this.model.getEntityMetadata(entityClassName);
        String keyClassName = meta.getPrimaryKey().getClassName();
        keyClassName = SimpleCatalog.keyClassName(keyClassName);
        DatabaseConfig dbConfig = this.getPrimaryConfig(meta);
        PrimaryIndex index = this.getPrimaryIndex(Object.class, keyClassName, entityClass, entityClassName);
        Database db = index.getDatabase();
        EntityBinding binding = index.getEntityBinding();
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        CursorConfig cursorConfig = null;
        Transaction txn = null;
        if (dbConfig.getTransactional()) {
            txn = this.env.beginTransaction(null, this.autoCommitTxnConfig);
            cursorConfig = CursorConfig.READ_COMMITTED;
        }
        Cursor cursor = null;
        int nWritten = 0;
        try {
            cursor = db.openCursor(txn, cursorConfig);
            OperationStatus status = cursor.getFirst(key, data, null);
            while (status == OperationStatus.SUCCESS) {
                boolean oneWritten = false;
                if (this.evolveNeeded(key, data, binding)) {
                    cursor.putCurrent(data);
                    oneWritten = true;
                    ++nWritten;
                }
                EvolveInternal.updateEvent(event, entityClassName, 1, oneWritten ? 1 : 0);
                if (listener != null && !listener.evolveProgress(event)) {
                    break;
                }
                if (txn != null && nWritten >= 1) {
                    cursor.close();
                    cursor = null;
                    txn.commit();
                    txn = null;
                    txn = this.env.beginTransaction(null, this.autoCommitTxnConfig);
                    cursor = db.openCursor(txn, cursorConfig);
                    DatabaseEntry saveKey = KeyRange.copy(key);
                    status = cursor.getSearchKeyRange(key, data, null);
                    if (status != OperationStatus.SUCCESS || !KeyRange.equalBytes(key, saveKey)) continue;
                    status = cursor.getNext(key, data, null);
                    continue;
                }
                status = cursor.getNext(key, data, null);
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (txn != null) {
                if (nWritten > 0) {
                    txn.commit();
                } else {
                    txn.abort();
                }
            }
        }
    }

    private boolean evolveNeeded(DatabaseEntry key, DatabaseEntry data, EntityBinding binding) {
        Object entity = binding.entryToObject(key, data);
        DatabaseEntry newData = new DatabaseEntry();
        binding.objectToData(entity, newData);
        if (data.equals(newData)) {
            return false;
        }
        byte[] bytes = newData.getData();
        int off = newData.getOffset();
        int size = newData.getSize();
        data.setData(bytes, off, size);
        return true;
    }

    public static void setSyncHook(SyncHook hook) {
        syncHook = hook;
    }

    public boolean attemptRefresh() {
        PersistCatalog oldCatalog = this.catalog;
        PersistCatalog newCatalog = this.refresh(oldCatalog, -1, null);
        return oldCatalog != newCatalog;
    }

    synchronized PersistCatalog refresh(PersistCatalog oldCatalog, int errorFormatId, RefreshException cause) {
        if (oldCatalog != this.catalog) {
            return this.catalog;
        }
        try {
            this.catalog = new PersistCatalog(oldCatalog, this.storePrefix);
        }
        catch (DatabaseException e) {
            throw RuntimeExceptionWrapper.wrapIfNeeded(e);
        }
        if (errorFormatId >= this.catalog.getNFormats()) {
            throw DbCompat.unexpectedException("Catalog could not be refreshed, may indicate corruption, errorFormatId=" + errorFormatId + " nFormats=" + this.catalog.getNFormats() + ", .", cause);
        }
        for (InternalPrimaryIndex internalPrimaryIndex : this.priIndexMap.values()) {
            internalPrimaryIndex.refresh(this.catalog);
        }
        for (InternalSecondaryIndex internalSecondaryIndex : this.secIndexMap.values()) {
            internalSecondaryIndex.refresh(this.catalog);
        }
        for (PersistKeyBinding persistKeyBinding : this.keyBindingMap.values()) {
            persistKeyBinding.refresh(this.catalog);
        }
        for (SecondaryConfig secondaryConfig : this.secConfigMap.values()) {
            PersistKeyCreator keyCreator = this.getKeyCreator(secondaryConfig);
            keyCreator.refresh(this.catalog);
        }
        return this.catalog;
    }

    TransactionConfig getAutoCommitTxnConfig() {
        return this.autoCommitTxnConfig;
    }

    private static void configForNonRepDb(TransactionConfig config, Durability envDurability) {
        config.setDurability(new Durability(envDurability.getLocalSync(), envDurability.getReplicaSync(), Durability.ReplicaAckPolicy.NONE));
        config.setConsistencyPolicy(NoConsistencyRequiredPolicy.NO_CONSISTENCY);
        config.setLocalWrite(true);
    }

    private class InternalSecondaryIndex<SK, PK, E>
    extends SecondaryIndex<SK, PK, E> {
        private final PersistKeyCreator keyCreator;

        InternalSecondaryIndex(SecondaryDatabase database, PrimaryIndex<PK, E> primaryIndex, Class<SK> secondaryKeyClass, PersistKeyBinding secondaryKeyBinding, PersistKeyCreator keyCreator) throws DatabaseException {
            super(database, null, primaryIndex, secondaryKeyClass, secondaryKeyBinding);
            this.keyCreator = keyCreator;
        }

        void refresh(PersistCatalog newCatalog) {
            this.keyCreator.refresh(newCatalog);
        }

        @Override
        protected TransactionConfig getAutoCommitTransactionConfig() {
            return Store.this.autoCommitTxnConfig;
        }
    }

    private class InternalPrimaryIndex<PK, E>
    extends PrimaryIndex<PK, E> {
        private final PersistEntityBinding entityBinding;

        InternalPrimaryIndex(Database database, Class<PK> keyClass, PersistKeyBinding keyBinding, Class<E> entityClass, PersistEntityBinding entityBinding) throws DatabaseException {
            super(database, keyClass, keyBinding, entityClass, entityBinding);
            this.entityBinding = entityBinding;
        }

        void refresh(PersistCatalog newCatalog) {
            this.entityBinding.refresh(newCatalog);
        }

        @Override
        protected TransactionConfig getAutoCommitTransactionConfig() {
            return Store.this.autoCommitTxnConfig;
        }
    }

    public static interface SyncHook {
        public void onSync(Database var1);
    }

    private class PrimaryOpenState {
        private String entityClassName;
        private IdentityHashMap<Database, Object> databases;
        private Set<String> secNames;

        PrimaryOpenState(String entityClassName) {
            this.entityClassName = entityClassName;
            this.databases = new IdentityHashMap();
            this.secNames = new HashSet<String>();
        }

        void addDatabase(Database db) {
            this.databases.put(db, null);
        }

        void addSecondaryName(String secName) {
            this.secNames.add(secName);
        }

        void undoState() {
            for (Database db : this.databases.keySet()) {
                try {
                    db.close();
                }
                catch (Exception exception) {}
            }
            Store.this.priIndexMap.remove(this.entityClassName);
            for (String secName : this.secNames) {
                Store.this.secIndexMap.remove(secName);
            }
            for (Database db : this.databases.keySet()) {
                Store.this.deferredWriteDatabases.remove(db);
            }
        }
    }
}

