/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext.javatime.deser.key;

import java.time.DateTimeException;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.ext.javatime.deser.key.Jsr310KeyDeserializer;

public class YearMonthKeyDeserializer
extends Jsr310KeyDeserializer {
    public static final YearMonthKeyDeserializer INSTANCE = new YearMonthKeyDeserializer();
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).toFormatter();

    private YearMonthKeyDeserializer() {
    }

    @Override
    protected YearMonth deserialize(String key, DeserializationContext ctxt) throws JacksonException {
        try {
            return YearMonth.parse(key, FORMATTER);
        }
        catch (DateTimeException e) {
            return (YearMonth)this._handleDateTimeException(ctxt, YearMonth.class, e, key);
        }
    }
}

