/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.impl.producer;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.QueryResult;
import org.apache.rocketmq.client.Validators;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.exception.RequestTimeoutException;
import org.apache.rocketmq.client.hook.CheckForbiddenContext;
import org.apache.rocketmq.client.hook.CheckForbiddenHook;
import org.apache.rocketmq.client.hook.EndTransactionContext;
import org.apache.rocketmq.client.hook.EndTransactionHook;
import org.apache.rocketmq.client.hook.SendMessageContext;
import org.apache.rocketmq.client.hook.SendMessageHook;
import org.apache.rocketmq.client.impl.CommunicationMode;
import org.apache.rocketmq.client.impl.MQClientManager;
import org.apache.rocketmq.client.impl.factory.MQClientInstance;
import org.apache.rocketmq.client.impl.producer.MQProducerInner;
import org.apache.rocketmq.client.impl.producer.TopicPublishInfo;
import org.apache.rocketmq.client.latency.MQFaultStrategy;
import org.apache.rocketmq.client.latency.Resolver;
import org.apache.rocketmq.client.latency.ServiceDetector;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.LocalTransactionState;
import org.apache.rocketmq.client.producer.MessageQueueSelector;
import org.apache.rocketmq.client.producer.RequestCallback;
import org.apache.rocketmq.client.producer.RequestFutureHolder;
import org.apache.rocketmq.client.producer.RequestResponseFuture;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.client.producer.TransactionCheckListener;
import org.apache.rocketmq.client.producer.TransactionListener;
import org.apache.rocketmq.client.producer.TransactionMQProducer;
import org.apache.rocketmq.client.producer.TransactionSendResult;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.ServiceState;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.help.FAQUrl;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageBatch;
import org.apache.rocketmq.common.message.MessageClientIDSetter;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageId;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.message.MessageType;
import org.apache.rocketmq.common.producer.RecallMessageHandle;
import org.apache.rocketmq.common.utils.CorrelationIdUtil;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.exception.RemotingConnectException;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.remoting.exception.RemotingTooMuchRequestException;
import org.apache.rocketmq.remoting.protocol.NamespaceUtil;
import org.apache.rocketmq.remoting.protocol.header.CheckTransactionStateRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.EndTransactionRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.RecallMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.SendMessageRequestHeader;

public class DefaultMQProducerImpl
implements MQProducerInner {
    private final Logger log = LoggerFactory.getLogger(DefaultMQProducerImpl.class);
    private final Random random = new Random();
    private final DefaultMQProducer defaultMQProducer;
    private final ConcurrentMap<String, TopicPublishInfo> topicPublishInfoTable = new ConcurrentHashMap<String, TopicPublishInfo>();
    private final ArrayList<SendMessageHook> sendMessageHookList = new ArrayList();
    private final ArrayList<EndTransactionHook> endTransactionHookList = new ArrayList();
    private final RPCHook rpcHook;
    private final BlockingQueue<Runnable> asyncSenderThreadPoolQueue;
    private final ExecutorService defaultAsyncSenderExecutor;
    protected BlockingQueue<Runnable> checkRequestQueue;
    protected ExecutorService checkExecutor;
    private ServiceState serviceState = ServiceState.CREATE_JUST;
    private MQClientInstance mQClientFactory;
    private ArrayList<CheckForbiddenHook> checkForbiddenHookList = new ArrayList();
    private MQFaultStrategy mqFaultStrategy;
    private ExecutorService asyncSenderExecutor;
    private Semaphore semaphoreAsyncSendNum;
    private Semaphore semaphoreAsyncSendSize;

    public DefaultMQProducerImpl(DefaultMQProducer defaultMQProducer) {
        this(defaultMQProducer, null);
    }

    public DefaultMQProducerImpl(DefaultMQProducer defaultMQProducer, RPCHook rpcHook) {
        this.defaultMQProducer = defaultMQProducer;
        this.rpcHook = rpcHook;
        this.asyncSenderThreadPoolQueue = new LinkedBlockingQueue<Runnable>(50000);
        this.defaultAsyncSenderExecutor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 60000L, TimeUnit.MILLISECONDS, this.asyncSenderThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("AsyncSenderExecutor_"));
        if (defaultMQProducer.getBackPressureForAsyncSendNum() > 10) {
            this.semaphoreAsyncSendNum = new Semaphore(Math.max(defaultMQProducer.getBackPressureForAsyncSendNum(), 10), true);
        } else {
            this.semaphoreAsyncSendNum = new Semaphore(10, true);
            this.log.info("semaphoreAsyncSendNum can not be smaller than 10.");
        }
        if (defaultMQProducer.getBackPressureForAsyncSendSize() > 0x100000) {
            this.semaphoreAsyncSendSize = new Semaphore(Math.max(defaultMQProducer.getBackPressureForAsyncSendSize(), 0x100000), true);
        } else {
            this.semaphoreAsyncSendSize = new Semaphore(0x100000, true);
            this.log.info("semaphoreAsyncSendSize can not be smaller than 1M.");
        }
        ServiceDetector serviceDetector = new ServiceDetector(){

            @Override
            public boolean detect(String endpoint, long timeoutMillis) {
                Optional candidateTopic = DefaultMQProducerImpl.this.pickTopic();
                if (!candidateTopic.isPresent()) {
                    return false;
                }
                try {
                    MessageQueue mq = new MessageQueue((String)candidateTopic.get(), null, 0);
                    DefaultMQProducerImpl.this.mQClientFactory.getMQClientAPIImpl().getMaxOffset(endpoint, mq, timeoutMillis);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        };
        this.mqFaultStrategy = new MQFaultStrategy(defaultMQProducer.cloneClientConfig(), new Resolver(){

            @Override
            public String resolve(String name) {
                return DefaultMQProducerImpl.this.mQClientFactory.findBrokerAddressInPublish(name);
            }
        }, serviceDetector);
    }

    private Optional<String> pickTopic() {
        if (this.topicPublishInfoTable.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.topicPublishInfoTable.keySet().iterator().next());
    }

    public void registerCheckForbiddenHook(CheckForbiddenHook checkForbiddenHook) {
        this.checkForbiddenHookList.add(checkForbiddenHook);
        this.log.info("register a new checkForbiddenHook. hookName={}, allHookSize={}", (Object)checkForbiddenHook.hookName(), (Object)this.checkForbiddenHookList.size());
    }

    public void setSemaphoreAsyncSendNum(int num) {
        this.semaphoreAsyncSendNum = new Semaphore(num, true);
    }

    public void setSemaphoreAsyncSendSize(int size) {
        this.semaphoreAsyncSendSize = new Semaphore(size, true);
    }

    public int getSemaphoreAsyncSendNumAvailablePermits() {
        return this.semaphoreAsyncSendNum == null ? 0 : this.semaphoreAsyncSendNum.availablePermits();
    }

    public int getSemaphoreAsyncSendSizeAvailablePermits() {
        return this.semaphoreAsyncSendSize == null ? 0 : this.semaphoreAsyncSendSize.availablePermits();
    }

    public void initTransactionEnv() {
        TransactionMQProducer producer = (TransactionMQProducer)this.defaultMQProducer;
        if (producer.getExecutorService() != null) {
            this.checkExecutor = producer.getExecutorService();
        } else {
            this.checkRequestQueue = new LinkedBlockingQueue<Runnable>(producer.getCheckRequestHoldMax());
            this.checkExecutor = new ThreadPoolExecutor(producer.getCheckThreadPoolMinSize(), producer.getCheckThreadPoolMaxSize(), 60000L, TimeUnit.MILLISECONDS, this.checkRequestQueue);
        }
    }

    public void destroyTransactionEnv() {
        if (this.checkExecutor != null) {
            this.checkExecutor.shutdown();
        }
    }

    public void registerSendMessageHook(SendMessageHook hook) {
        this.sendMessageHookList.add(hook);
        this.log.info("register sendMessage Hook, {}", (Object)hook.hookName());
    }

    public void registerEndTransactionHook(EndTransactionHook hook) {
        this.endTransactionHookList.add(hook);
        this.log.info("register endTransaction Hook, {}", (Object)hook.hookName());
    }

    public void start() throws MQClientException {
        this.start(true);
    }

    public void start(boolean startFactory) throws MQClientException {
        switch (this.serviceState) {
            case CREATE_JUST: {
                this.serviceState = ServiceState.START_FAILED;
                this.checkConfig();
                if (!this.defaultMQProducer.getProducerGroup().equals("CLIENT_INNER_PRODUCER")) {
                    this.defaultMQProducer.changeInstanceNameToPID();
                }
                this.mQClientFactory = MQClientManager.getInstance().getOrCreateMQClientInstance(this.defaultMQProducer, this.rpcHook);
                this.defaultMQProducer.initProduceAccumulator();
                boolean registerOK = this.mQClientFactory.registerProducer(this.defaultMQProducer.getProducerGroup(), this);
                if (!registerOK) {
                    this.serviceState = ServiceState.CREATE_JUST;
                    throw new MQClientException("The producer group[" + this.defaultMQProducer.getProducerGroup() + "] has been created before, specify another name please." + FAQUrl.suggestTodo((String)"https://rocketmq.apache.org/docs/bestPractice/06FAQ"), null);
                }
                if (startFactory) {
                    this.mQClientFactory.start();
                }
                this.initTopicRoute();
                this.mqFaultStrategy.startDetector();
                this.log.info("the producer [{}] start OK. sendMessageWithVIPChannel={}", (Object)this.defaultMQProducer.getProducerGroup(), (Object)this.defaultMQProducer.isSendMessageWithVIPChannel());
                this.serviceState = ServiceState.RUNNING;
                break;
            }
            case RUNNING: 
            case START_FAILED: 
            case SHUTDOWN_ALREADY: {
                throw new MQClientException("The producer service state not OK, maybe started once, " + this.serviceState + FAQUrl.suggestTodo((String)"https://rocketmq.apache.org/docs/bestPractice/06FAQ"), null);
            }
        }
        this.mQClientFactory.sendHeartbeatToAllBrokerWithLock();
        RequestFutureHolder.getInstance().startScheduledTask(this);
    }

    private void checkConfig() throws MQClientException {
        Validators.checkGroup(this.defaultMQProducer.getProducerGroup());
        if (this.defaultMQProducer.getProducerGroup().equals("DEFAULT_PRODUCER")) {
            throw new MQClientException("producerGroup can not equal DEFAULT_PRODUCER, please specify another one.", null);
        }
    }

    public void shutdown() {
        this.shutdown(true);
    }

    public void shutdown(boolean shutdownFactory) {
        switch (this.serviceState) {
            case CREATE_JUST: {
                break;
            }
            case RUNNING: {
                this.mQClientFactory.unregisterProducer(this.defaultMQProducer.getProducerGroup());
                this.defaultAsyncSenderExecutor.shutdown();
                if (shutdownFactory) {
                    this.mQClientFactory.shutdown();
                }
                this.mqFaultStrategy.shutdown();
                RequestFutureHolder.getInstance().shutdown(this);
                this.log.info("the producer [{}] shutdown OK", (Object)this.defaultMQProducer.getProducerGroup());
                this.serviceState = ServiceState.SHUTDOWN_ALREADY;
                break;
            }
            case SHUTDOWN_ALREADY: {
                break;
            }
        }
    }

    @Override
    public Set<String> getPublishTopicList() {
        return new HashSet<String>(this.topicPublishInfoTable.keySet());
    }

    @Override
    public boolean isPublishTopicNeedUpdate(String topic) {
        TopicPublishInfo prev = (TopicPublishInfo)this.topicPublishInfoTable.get(topic);
        return null == prev || !prev.ok();
    }

    @Override
    @Deprecated
    public TransactionCheckListener checkListener() {
        if (this.defaultMQProducer instanceof TransactionMQProducer) {
            TransactionMQProducer producer = (TransactionMQProducer)this.defaultMQProducer;
            return producer.getTransactionCheckListener();
        }
        return null;
    }

    @Override
    public TransactionListener getCheckListener() {
        if (this.defaultMQProducer instanceof TransactionMQProducer) {
            TransactionMQProducer producer = (TransactionMQProducer)this.defaultMQProducer;
            return producer.getTransactionListener();
        }
        return null;
    }

    @Override
    public void checkTransactionState(final String addr, final MessageExt msg, final CheckTransactionStateRequestHeader header) {
        Runnable request = new Runnable(){
            private final String brokerAddr;
            private final MessageExt message;
            private final CheckTransactionStateRequestHeader checkRequestHeader;
            private final String group;
            {
                this.brokerAddr = addr;
                this.message = msg;
                this.checkRequestHeader = header;
                this.group = DefaultMQProducerImpl.this.defaultMQProducer.getProducerGroup();
            }

            @Override
            public void run() {
                TransactionCheckListener transactionCheckListener = DefaultMQProducerImpl.this.checkListener();
                TransactionListener transactionListener = DefaultMQProducerImpl.this.getCheckListener();
                if (transactionCheckListener != null || transactionListener != null) {
                    LocalTransactionState localTransactionState = LocalTransactionState.UNKNOW;
                    Throwable exception = null;
                    try {
                        if (transactionCheckListener != null) {
                            localTransactionState = transactionCheckListener.checkLocalTransactionState(this.message);
                        } else {
                            DefaultMQProducerImpl.this.log.debug("TransactionCheckListener is null, used new check API, producerGroup={}", (Object)this.group);
                            localTransactionState = transactionListener.checkLocalTransaction(this.message);
                        }
                    }
                    catch (Throwable e) {
                        DefaultMQProducerImpl.this.log.error("Broker call checkTransactionState, but checkLocalTransactionState exception", e);
                        exception = e;
                    }
                    this.processTransactionState(this.checkRequestHeader.getTopic(), localTransactionState, this.group, exception);
                } else {
                    DefaultMQProducerImpl.this.log.warn("CheckTransactionState, pick transactionCheckListener by group[{}] failed", (Object)this.group);
                }
            }

            private void processTransactionState(String topic, LocalTransactionState localTransactionState, String producerGroup, Throwable exception) {
                EndTransactionRequestHeader thisHeader = new EndTransactionRequestHeader();
                thisHeader.setTopic(topic);
                thisHeader.setCommitLogOffset(this.checkRequestHeader.getCommitLogOffset());
                thisHeader.setProducerGroup(producerGroup);
                thisHeader.setTranStateTableOffset(this.checkRequestHeader.getTranStateTableOffset());
                thisHeader.setFromTransactionCheck(Boolean.valueOf(true));
                thisHeader.setBrokerName(this.checkRequestHeader.getBrokerName());
                String uniqueKey = (String)this.message.getProperties().get("UNIQ_KEY");
                if (uniqueKey == null) {
                    uniqueKey = this.message.getMsgId();
                }
                thisHeader.setMsgId(uniqueKey);
                thisHeader.setTransactionId(this.checkRequestHeader.getTransactionId());
                switch (localTransactionState) {
                    case COMMIT_MESSAGE: {
                        thisHeader.setCommitOrRollback(Integer.valueOf(8));
                        break;
                    }
                    case ROLLBACK_MESSAGE: {
                        thisHeader.setCommitOrRollback(Integer.valueOf(12));
                        DefaultMQProducerImpl.this.log.warn("when broker check, client rollback this transaction, {}", (Object)thisHeader);
                        break;
                    }
                    case UNKNOW: {
                        thisHeader.setCommitOrRollback(Integer.valueOf(0));
                        DefaultMQProducerImpl.this.log.warn("when broker check, client does not know this transaction state, {}", (Object)thisHeader);
                        break;
                    }
                }
                String remark = null;
                if (exception != null) {
                    remark = "checkLocalTransactionState Exception: " + UtilAll.exceptionSimpleDesc((Throwable)exception);
                }
                DefaultMQProducerImpl.this.doExecuteEndTransactionHook((Message)msg, uniqueKey, this.brokerAddr, localTransactionState, true);
                try {
                    DefaultMQProducerImpl.this.mQClientFactory.getMQClientAPIImpl().endTransactionOneway(this.brokerAddr, thisHeader, remark, 3000L);
                }
                catch (Exception e) {
                    DefaultMQProducerImpl.this.log.error("endTransactionOneway exception", (Throwable)e);
                }
            }
        };
        this.checkExecutor.submit(request);
    }

    @Override
    public void updateTopicPublishInfo(String topic, TopicPublishInfo info) {
        TopicPublishInfo prev;
        if (info != null && topic != null && (prev = this.topicPublishInfoTable.put(topic, info)) != null) {
            this.log.info("updateTopicPublishInfo prev is not null, " + prev);
        }
    }

    @Override
    public boolean isUnitMode() {
        return this.defaultMQProducer.isUnitMode();
    }

    public void createTopic(String key, String newTopic, int queueNum) throws MQClientException {
        this.createTopic(key, newTopic, queueNum, 0);
    }

    public void createTopic(String key, String newTopic, int queueNum, int topicSysFlag) throws MQClientException {
        this.makeSureStateOK();
        Validators.checkTopic(newTopic);
        Validators.isSystemTopic(newTopic);
        this.mQClientFactory.getMQAdminImpl().createTopic(key, newTopic, queueNum, topicSysFlag, null);
    }

    private void makeSureStateOK() throws MQClientException {
        if (this.serviceState != ServiceState.RUNNING) {
            throw new MQClientException("The producer service state not OK, " + this.serviceState + FAQUrl.suggestTodo((String)"https://rocketmq.apache.org/docs/bestPractice/06FAQ"), null);
        }
    }

    public List<MessageQueue> fetchPublishMessageQueues(String topic) throws MQClientException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().fetchPublishMessageQueues(topic);
    }

    public long searchOffset(MessageQueue mq, long timestamp) throws MQClientException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().searchOffset(mq, timestamp);
    }

    public long maxOffset(MessageQueue mq) throws MQClientException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().maxOffset(mq);
    }

    public long minOffset(MessageQueue mq) throws MQClientException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().minOffset(mq);
    }

    public long earliestMsgStoreTime(MessageQueue mq) throws MQClientException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().earliestMsgStoreTime(mq);
    }

    public MessageExt viewMessage(String topic, String msgId) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().viewMessage(topic, msgId);
    }

    public QueryResult queryMessage(String topic, String key, int maxNum, long begin, long end) throws MQClientException, InterruptedException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().queryMessage(topic, key, maxNum, begin, end);
    }

    public MessageExt queryMessageByUniqKey(String topic, String uniqKey) throws MQClientException, InterruptedException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().queryMessageByUniqKey(topic, uniqKey);
    }

    public void send(Message msg, SendCallback sendCallback) throws MQClientException, RemotingException, InterruptedException {
        this.send(msg, sendCallback, (long)this.defaultMQProducer.getSendMsgTimeout());
    }

    @Deprecated
    public void send(final Message msg, SendCallback sendCallback, final long timeout) throws MQClientException, RemotingException, InterruptedException {
        final BackpressureSendCallBack newCallBack = new BackpressureSendCallBack(sendCallback);
        final long beginStartTime = System.currentTimeMillis();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                long costTime = System.currentTimeMillis() - beginStartTime;
                if (timeout > costTime) {
                    try {
                        DefaultMQProducerImpl.this.sendDefaultImpl(msg, CommunicationMode.ASYNC, newCallBack, timeout - costTime);
                    }
                    catch (Exception e) {
                        newCallBack.onException(e);
                    }
                } else {
                    newCallBack.onException((Throwable)new RemotingTooMuchRequestException("DEFAULT ASYNC send call timeout"));
                }
            }
        };
        this.executeAsyncMessageSend(runnable, msg, newCallBack, timeout, beginStartTime);
    }

    public void executeAsyncMessageSend(Runnable runnable, Message msg, BackpressureSendCallBack sendCallback, long timeout, long beginStartTime) throws MQClientException, InterruptedException {
        int msgLen;
        ExecutorService executor = this.getAsyncSenderExecutor();
        boolean isEnableBackpressureForAsyncMode = this.getDefaultMQProducer().isEnableBackpressureForAsyncMode();
        boolean isSemaphoreAsyncNumAcquired = false;
        boolean isSemaphoreAsyncSizeAcquired = false;
        sendCallback.msgLen = msgLen = msg.getBody() == null ? 1 : msg.getBody().length;
        try {
            if (isEnableBackpressureForAsyncMode) {
                this.defaultMQProducer.acquireBackPressureForAsyncSendNumLock();
                long costTime = System.currentTimeMillis() - beginStartTime;
                sendCallback.isSemaphoreAsyncNumAcquired = isSemaphoreAsyncNumAcquired = timeout - costTime > 0L && this.semaphoreAsyncSendNum.tryAcquire(timeout - costTime, TimeUnit.MILLISECONDS);
                this.defaultMQProducer.releaseBackPressureForAsyncSendNumLock();
                if (!isSemaphoreAsyncNumAcquired) {
                    sendCallback.onException((Throwable)new RemotingTooMuchRequestException("send message tryAcquire semaphoreAsyncNum timeout"));
                    return;
                }
                this.defaultMQProducer.acquireBackPressureForAsyncSendSizeLock();
                costTime = System.currentTimeMillis() - beginStartTime;
                sendCallback.isSemaphoreAsyncSizeAcquired = isSemaphoreAsyncSizeAcquired = timeout - costTime > 0L && this.semaphoreAsyncSendSize.tryAcquire(msgLen, timeout - costTime, TimeUnit.MILLISECONDS);
                this.defaultMQProducer.releaseBackPressureForAsyncSendSizeLock();
                if (!isSemaphoreAsyncSizeAcquired) {
                    sendCallback.onException((Throwable)new RemotingTooMuchRequestException("send message tryAcquire semaphoreAsyncSize timeout"));
                    return;
                }
            }
            executor.submit(runnable);
        }
        catch (RejectedExecutionException e) {
            if (isEnableBackpressureForAsyncMode) {
                runnable.run();
            }
            throw new MQClientException("executor rejected ", e);
        }
    }

    public MessageQueue invokeMessageQueueSelector(Message msg, MessageQueueSelector selector, Object arg, long timeout) throws MQClientException, RemotingTooMuchRequestException {
        long beginStartTime = System.currentTimeMillis();
        this.makeSureStateOK();
        Validators.checkMessage(msg, this.defaultMQProducer);
        TopicPublishInfo topicPublishInfo = this.tryToFindTopicPublishInfo(msg.getTopic());
        if (topicPublishInfo != null && topicPublishInfo.ok()) {
            MessageQueue mq = null;
            try {
                List<MessageQueue> messageQueueList = this.mQClientFactory.getMQAdminImpl().parsePublishMessageQueues(topicPublishInfo.getMessageQueueList());
                Message userMessage = MessageAccessor.cloneMessage((Message)msg);
                String userTopic = NamespaceUtil.withoutNamespace((String)userMessage.getTopic(), (String)this.mQClientFactory.getClientConfig().getNamespace());
                userMessage.setTopic(userTopic);
                mq = this.mQClientFactory.getClientConfig().queueWithNamespace(selector.select(messageQueueList, userMessage, arg));
            }
            catch (Throwable e) {
                throw new MQClientException("select message queue threw exception.", e);
            }
            long costTime = System.currentTimeMillis() - beginStartTime;
            if (timeout < costTime) {
                throw new RemotingTooMuchRequestException("sendSelectImpl call timeout");
            }
            if (mq != null) {
                return mq;
            }
            throw new MQClientException("select message queue return null.", null);
        }
        this.validateNameServerSetting();
        throw new MQClientException("No route info for this topic, " + msg.getTopic(), null);
    }

    public MessageQueue selectOneMessageQueue(TopicPublishInfo tpInfo, String lastBrokerName, boolean resetIndex) {
        return this.mqFaultStrategy.selectOneMessageQueue(tpInfo, lastBrokerName, resetIndex);
    }

    public void updateFaultItem(String brokerName, long currentLatency, boolean isolation, boolean reachable) {
        this.mqFaultStrategy.updateFaultItem(brokerName, currentLatency, isolation, reachable);
    }

    private void validateNameServerSetting() throws MQClientException {
        List<String> nsList = this.getMqClientFactory().getMQClientAPIImpl().getNameServerAddressList();
        if (null == nsList || nsList.isEmpty()) {
            throw new MQClientException("No name server address, please set it." + FAQUrl.suggestTodo((String)"https://rocketmq.apache.org/docs/bestPractice/06FAQ"), null).setResponseCode(10004);
        }
    }

    private SendResult sendDefaultImpl(Message msg, CommunicationMode communicationMode, SendCallback sendCallback, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        long beginTimestampFirst;
        this.makeSureStateOK();
        Validators.checkMessage(msg, this.defaultMQProducer);
        long invokeID = this.random.nextLong();
        long beginTimestampPrev = beginTimestampFirst = System.currentTimeMillis();
        long endTimestamp = beginTimestampFirst;
        TopicPublishInfo topicPublishInfo = this.tryToFindTopicPublishInfo(msg.getTopic());
        if (topicPublishInfo != null && topicPublishInfo.ok()) {
            int times;
            boolean callTimeout = false;
            MessageQueue mq = null;
            Throwable exception = null;
            SendResult sendResult = null;
            int timesTotal = communicationMode == CommunicationMode.SYNC ? 1 + this.defaultMQProducer.getRetryTimesWhenSendFailed() : 1;
            Object[] brokersSent = new String[timesTotal];
            boolean resetIndex = false;
            for (times = 0; times < timesTotal; ++times) {
                MessageQueue mqSelected;
                String lastBrokerName;
                String string = lastBrokerName = null == mq ? null : mq.getBrokerName();
                if (times > 0) {
                    resetIndex = true;
                }
                if ((mqSelected = this.selectOneMessageQueue(topicPublishInfo, lastBrokerName, resetIndex)) == null) break;
                mq = mqSelected;
                brokersSent[times] = mq.getBrokerName();
                try {
                    long costTime;
                    beginTimestampPrev = System.currentTimeMillis();
                    if (times > 0) {
                        msg.setTopic(this.defaultMQProducer.withNamespace(msg.getTopic()));
                    }
                    if (timeout < (costTime = beginTimestampPrev - beginTimestampFirst)) {
                        callTimeout = true;
                        break;
                    }
                    sendResult = this.sendKernelImpl(msg, mq, communicationMode, sendCallback, topicPublishInfo, timeout - costTime);
                    endTimestamp = System.currentTimeMillis();
                    this.updateFaultItem(mq.getBrokerName(), endTimestamp - beginTimestampPrev, false, true);
                    switch (communicationMode) {
                        case ASYNC: {
                            return null;
                        }
                        case ONEWAY: {
                            return null;
                        }
                        case SYNC: {
                            if (sendResult.getSendStatus() != SendStatus.SEND_OK && this.defaultMQProducer.isRetryAnotherBrokerWhenNotStoreOK()) break;
                            return sendResult;
                        }
                    }
                    continue;
                }
                catch (MQClientException e) {
                    endTimestamp = System.currentTimeMillis();
                    this.updateFaultItem(mq.getBrokerName(), endTimestamp - beginTimestampPrev, false, true);
                    this.log.warn("sendKernelImpl exception, resend at once, InvokeID: {}, RT: {}ms, Broker: {}", new Object[]{invokeID, endTimestamp - beginTimestampPrev, mq, e});
                    this.log.warn(msg.toString());
                    exception = e;
                    continue;
                }
                catch (RemotingException e) {
                    endTimestamp = System.currentTimeMillis();
                    if (this.mqFaultStrategy.isStartDetectorEnable()) {
                        this.updateFaultItem(mq.getBrokerName(), endTimestamp - beginTimestampPrev, true, false);
                    } else {
                        this.updateFaultItem(mq.getBrokerName(), endTimestamp - beginTimestampPrev, true, true);
                    }
                    this.log.warn("sendKernelImpl exception, resend at once, InvokeID: {}, RT: {}ms, Broker: {}", new Object[]{invokeID, endTimestamp - beginTimestampPrev, mq, e});
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(msg.toString());
                    }
                    exception = e;
                    continue;
                }
                catch (MQBrokerException e) {
                    endTimestamp = System.currentTimeMillis();
                    this.updateFaultItem(mq.getBrokerName(), endTimestamp - beginTimestampPrev, true, false);
                    this.log.warn("sendKernelImpl exception, resend at once, InvokeID: {}, RT: {}ms, Broker: {}", new Object[]{invokeID, endTimestamp - beginTimestampPrev, mq, e});
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(msg.toString());
                    }
                    exception = e;
                    if (this.defaultMQProducer.getRetryResponseCodes().contains(e.getResponseCode())) continue;
                    if (sendResult != null) {
                        return sendResult;
                    }
                    throw e;
                }
                catch (InterruptedException e) {
                    endTimestamp = System.currentTimeMillis();
                    this.updateFaultItem(mq.getBrokerName(), endTimestamp - beginTimestampPrev, false, true);
                    this.log.warn("sendKernelImpl exception, throw exception, InvokeID: {}, RT: {}ms, Broker: {}", new Object[]{invokeID, endTimestamp - beginTimestampPrev, mq, e});
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(msg.toString());
                    }
                    throw e;
                }
            }
            if (sendResult != null) {
                return sendResult;
            }
            String info = String.format("Send [%d] times, still failed, cost [%d]ms, Topic: %s, BrokersSent: %s", times, System.currentTimeMillis() - beginTimestampFirst, msg.getTopic(), Arrays.toString(brokersSent));
            info = info + FAQUrl.suggestTodo((String)"https://rocketmq.apache.org/docs/bestPractice/06FAQ");
            MQClientException mqClientException = new MQClientException(info, exception);
            if (callTimeout) {
                throw new RemotingTooMuchRequestException("sendDefaultImpl call timeout");
            }
            if (exception instanceof MQBrokerException) {
                mqClientException.setResponseCode(((MQBrokerException)exception).getResponseCode());
            } else if (exception instanceof RemotingConnectException) {
                mqClientException.setResponseCode(10001);
            } else if (exception instanceof RemotingTimeoutException) {
                mqClientException.setResponseCode(10002);
            } else if (exception instanceof MQClientException) {
                mqClientException.setResponseCode(10003);
            }
            throw mqClientException;
        }
        this.validateNameServerSetting();
        throw new MQClientException("No route info of this topic: " + msg.getTopic() + FAQUrl.suggestTodo((String)"https://rocketmq.apache.org/docs/bestPractice/06FAQ"), null).setResponseCode(10005);
    }

    private TopicPublishInfo tryToFindTopicPublishInfo(String topic) {
        TopicPublishInfo topicPublishInfo = (TopicPublishInfo)this.topicPublishInfoTable.get(topic);
        if (null == topicPublishInfo || !topicPublishInfo.ok()) {
            this.topicPublishInfoTable.putIfAbsent(topic, new TopicPublishInfo());
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(topic);
            topicPublishInfo = (TopicPublishInfo)this.topicPublishInfoTable.get(topic);
        }
        if (topicPublishInfo.isHaveTopicRouterInfo() || topicPublishInfo.ok()) {
            return topicPublishInfo;
        }
        this.mQClientFactory.updateTopicRouteInfoFromNameServer(topic, true, this.defaultMQProducer);
        topicPublishInfo = (TopicPublishInfo)this.topicPublishInfoTable.get(topic);
        return topicPublishInfo;
    }

    private SendResult sendKernelImpl(Message msg, MessageQueue mq, CommunicationMode communicationMode, SendCallback sendCallback, TopicPublishInfo topicPublishInfo, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        long beginStartTime = System.currentTimeMillis();
        String brokerName = this.mQClientFactory.getBrokerNameFromMessageQueue(mq);
        String brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(brokerName);
        if (null == brokerAddr) {
            this.tryToFindTopicPublishInfo(mq.getTopic());
            brokerName = this.mQClientFactory.getBrokerNameFromMessageQueue(mq);
            brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(brokerName);
        }
        SendMessageContext context = null;
        if (brokerAddr != null) {
            brokerAddr = MixAll.brokerVIPChannel((boolean)this.defaultMQProducer.isSendMessageWithVIPChannel(), (String)brokerAddr);
            byte[] prevBody = msg.getBody();
            try {
                String tranMsg;
                if (!(msg instanceof MessageBatch)) {
                    MessageClientIDSetter.setUniqID((Message)msg);
                }
                boolean topicWithNamespace = false;
                if (null != this.mQClientFactory.getClientConfig().getNamespace()) {
                    msg.setInstanceId(this.mQClientFactory.getClientConfig().getNamespace());
                    topicWithNamespace = true;
                }
                int sysFlag = 0;
                boolean msgBodyCompressed = false;
                if (this.tryToCompressMessage(msg)) {
                    sysFlag |= 1;
                    sysFlag |= this.defaultMQProducer.getCompressType().getCompressionFlag();
                    msgBodyCompressed = true;
                }
                if (Boolean.parseBoolean(tranMsg = msg.getProperty("TRAN_MSG"))) {
                    sysFlag |= 4;
                }
                if (this.hasCheckForbiddenHook()) {
                    CheckForbiddenContext checkForbiddenContext = new CheckForbiddenContext();
                    checkForbiddenContext.setNameSrvAddr(this.defaultMQProducer.getNamesrvAddr());
                    checkForbiddenContext.setGroup(this.defaultMQProducer.getProducerGroup());
                    checkForbiddenContext.setCommunicationMode(communicationMode);
                    checkForbiddenContext.setBrokerAddr(brokerAddr);
                    checkForbiddenContext.setMessage(msg);
                    checkForbiddenContext.setMq(mq);
                    checkForbiddenContext.setUnitMode(this.isUnitMode());
                    this.executeCheckForbiddenHook(checkForbiddenContext);
                }
                if (this.hasSendMessageHook()) {
                    context = new SendMessageContext();
                    context.setProducer(this);
                    context.setProducerGroup(this.defaultMQProducer.getProducerGroup());
                    context.setCommunicationMode(communicationMode);
                    context.setBornHost(this.defaultMQProducer.getClientIP());
                    context.setBrokerAddr(brokerAddr);
                    context.setMessage(msg);
                    context.setMq(mq);
                    context.setNamespace(this.defaultMQProducer.getNamespace());
                    String isTrans = msg.getProperty("TRAN_MSG");
                    if (isTrans != null && isTrans.equals("true")) {
                        context.setMsgType(MessageType.Trans_Msg_Half);
                    }
                    if (msg.getProperty("__STARTDELIVERTIME") != null || msg.getProperty("DELAY") != null) {
                        context.setMsgType(MessageType.Delay_Msg);
                    }
                    this.executeSendMessageHookBefore(context);
                }
                SendMessageRequestHeader requestHeader = new SendMessageRequestHeader();
                requestHeader.setProducerGroup(this.defaultMQProducer.getProducerGroup());
                requestHeader.setTopic(msg.getTopic());
                requestHeader.setDefaultTopic(this.defaultMQProducer.getCreateTopicKey());
                requestHeader.setDefaultTopicQueueNums(Integer.valueOf(this.defaultMQProducer.getDefaultTopicQueueNums()));
                requestHeader.setQueueId(Integer.valueOf(mq.getQueueId()));
                requestHeader.setSysFlag(Integer.valueOf(sysFlag));
                requestHeader.setBornTimestamp(Long.valueOf(System.currentTimeMillis()));
                requestHeader.setFlag(Integer.valueOf(msg.getFlag()));
                requestHeader.setProperties(MessageDecoder.messageProperties2String((Map)msg.getProperties()));
                requestHeader.setReconsumeTimes(Integer.valueOf(0));
                requestHeader.setUnitMode(Boolean.valueOf(this.isUnitMode()));
                requestHeader.setBatch(Boolean.valueOf(msg instanceof MessageBatch));
                requestHeader.setBrokerName(brokerName);
                if (requestHeader.getTopic().startsWith("%RETRY%")) {
                    String maxReconsumeTimes;
                    String reconsumeTimes = MessageAccessor.getReconsumeTime((Message)msg);
                    if (reconsumeTimes != null) {
                        requestHeader.setReconsumeTimes(Integer.valueOf(reconsumeTimes));
                        MessageAccessor.clearProperty((Message)msg, (String)"RECONSUME_TIME");
                    }
                    if ((maxReconsumeTimes = MessageAccessor.getMaxReconsumeTimes((Message)msg)) != null) {
                        requestHeader.setMaxReconsumeTimes(Integer.valueOf(maxReconsumeTimes));
                        MessageAccessor.clearProperty((Message)msg, (String)"MAX_RECONSUME_TIMES");
                    }
                }
                SendResult sendResult = null;
                switch (communicationMode) {
                    case ASYNC: {
                        long costTimeAsync;
                        Message tmpMessage = msg;
                        boolean messageCloned = false;
                        if (msgBodyCompressed) {
                            tmpMessage = MessageAccessor.cloneMessage((Message)msg);
                            messageCloned = true;
                            msg.setBody(prevBody);
                        }
                        if (topicWithNamespace) {
                            if (!messageCloned) {
                                tmpMessage = MessageAccessor.cloneMessage((Message)msg);
                                messageCloned = true;
                            }
                            msg.setTopic(NamespaceUtil.withoutNamespace((String)msg.getTopic(), (String)this.defaultMQProducer.getNamespace()));
                        }
                        if (timeout < (costTimeAsync = System.currentTimeMillis() - beginStartTime)) {
                            throw new RemotingTooMuchRequestException("sendKernelImpl call timeout");
                        }
                        sendResult = this.mQClientFactory.getMQClientAPIImpl().sendMessage(brokerAddr, brokerName, tmpMessage, requestHeader, timeout - costTimeAsync, communicationMode, sendCallback, topicPublishInfo, this.mQClientFactory, this.defaultMQProducer.getRetryTimesWhenSendAsyncFailed(), context, this);
                        break;
                    }
                    case ONEWAY: 
                    case SYNC: {
                        long costTimeSync = System.currentTimeMillis() - beginStartTime;
                        if (timeout < costTimeSync) {
                            throw new RemotingTooMuchRequestException("sendKernelImpl call timeout");
                        }
                        sendResult = this.mQClientFactory.getMQClientAPIImpl().sendMessage(brokerAddr, brokerName, msg, requestHeader, timeout - costTimeSync, communicationMode, context, this);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                if (this.hasSendMessageHook()) {
                    context.setSendResult(sendResult);
                    this.executeSendMessageHookAfter(context);
                }
                SendResult sendResult2 = sendResult;
                return sendResult2;
            }
            catch (InterruptedException | MQBrokerException | RemotingException e) {
                if (this.hasSendMessageHook()) {
                    context.setException((Exception)e);
                    this.executeSendMessageHookAfter(context);
                }
                throw e;
            }
            finally {
                msg.setBody(prevBody);
                msg.setTopic(NamespaceUtil.withoutNamespace((String)msg.getTopic(), (String)this.defaultMQProducer.getNamespace()));
            }
        }
        throw new MQClientException("The broker[" + brokerName + "] not exist", null);
    }

    public MQClientInstance getMqClientFactory() {
        return this.mQClientFactory;
    }

    @Deprecated
    public MQClientInstance getmQClientFactory() {
        return this.mQClientFactory;
    }

    private boolean tryToCompressMessage(Message msg) {
        block5: {
            if (msg instanceof MessageBatch) {
                return false;
            }
            byte[] body = msg.getBody();
            if (body != null && body.length >= this.defaultMQProducer.getCompressMsgBodyOverHowmuch()) {
                try {
                    byte[] data = this.defaultMQProducer.getCompressor().compress(body, this.defaultMQProducer.getCompressLevel());
                    if (data != null) {
                        msg.setBody(data);
                        return true;
                    }
                }
                catch (IOException e) {
                    this.log.error("tryToCompressMessage exception", (Throwable)e);
                    if (!this.log.isDebugEnabled()) break block5;
                    this.log.debug(msg.toString());
                }
            }
        }
        return false;
    }

    public boolean hasCheckForbiddenHook() {
        return !this.checkForbiddenHookList.isEmpty();
    }

    public void executeCheckForbiddenHook(CheckForbiddenContext context) throws MQClientException {
        if (this.hasCheckForbiddenHook()) {
            for (CheckForbiddenHook hook : this.checkForbiddenHookList) {
                hook.checkForbidden(context);
            }
        }
    }

    public boolean hasSendMessageHook() {
        return !this.sendMessageHookList.isEmpty();
    }

    public void executeSendMessageHookBefore(SendMessageContext context) {
        if (!this.sendMessageHookList.isEmpty()) {
            for (SendMessageHook hook : this.sendMessageHookList) {
                try {
                    hook.sendMessageBefore(context);
                }
                catch (Throwable e) {
                    this.log.warn("failed to executeSendMessageHookBefore", e);
                }
            }
        }
    }

    public void executeSendMessageHookAfter(SendMessageContext context) {
        if (!this.sendMessageHookList.isEmpty()) {
            for (SendMessageHook hook : this.sendMessageHookList) {
                try {
                    hook.sendMessageAfter(context);
                }
                catch (Throwable e) {
                    this.log.warn("failed to executeSendMessageHookAfter", e);
                }
            }
        }
    }

    public boolean hasEndTransactionHook() {
        return !this.endTransactionHookList.isEmpty();
    }

    public void executeEndTransactionHook(EndTransactionContext context) {
        if (!this.endTransactionHookList.isEmpty()) {
            for (EndTransactionHook hook : this.endTransactionHookList) {
                try {
                    hook.endTransaction(context);
                }
                catch (Throwable e) {
                    this.log.warn("failed to executeEndTransactionHook", e);
                }
            }
        }
    }

    public void doExecuteEndTransactionHook(Message msg, String msgId, String brokerAddr, LocalTransactionState state, boolean fromTransactionCheck) {
        if (this.hasEndTransactionHook()) {
            EndTransactionContext context = new EndTransactionContext();
            context.setProducerGroup(this.defaultMQProducer.getProducerGroup());
            context.setBrokerAddr(brokerAddr);
            context.setMessage(msg);
            context.setMsgId(msgId);
            context.setTransactionId(msg.getTransactionId());
            context.setTransactionState(state);
            context.setFromTransactionCheck(fromTransactionCheck);
            this.executeEndTransactionHook(context);
        }
    }

    public void sendOneway(Message msg) throws MQClientException, RemotingException, InterruptedException {
        try {
            this.sendDefaultImpl(msg, CommunicationMode.ONEWAY, null, this.defaultMQProducer.getSendMsgTimeout());
        }
        catch (MQBrokerException e) {
            throw new MQClientException("unknown exception", e);
        }
    }

    public SendResult send(Message msg, MessageQueue mq) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.send(msg, mq, (long)this.defaultMQProducer.getSendMsgTimeout());
    }

    public SendResult send(Message msg, MessageQueue mq, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        long beginStartTime = System.currentTimeMillis();
        this.makeSureStateOK();
        Validators.checkMessage(msg, this.defaultMQProducer);
        if (!msg.getTopic().equals(mq.getTopic())) {
            throw new MQClientException("message's topic not equal mq's topic", null);
        }
        long costTime = System.currentTimeMillis() - beginStartTime;
        if (timeout < costTime) {
            throw new RemotingTooMuchRequestException("call timeout");
        }
        return this.sendKernelImpl(msg, mq, CommunicationMode.SYNC, null, null, timeout);
    }

    public void send(Message msg, MessageQueue mq, SendCallback sendCallback) throws MQClientException, RemotingException, InterruptedException {
        this.send(msg, mq, sendCallback, (long)this.defaultMQProducer.getSendMsgTimeout());
    }

    @Deprecated
    public void send(final Message msg, final MessageQueue mq, SendCallback sendCallback, final long timeout) throws MQClientException, RemotingException, InterruptedException {
        final BackpressureSendCallBack newCallBack = new BackpressureSendCallBack(sendCallback);
        final long beginStartTime = System.currentTimeMillis();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                block6: {
                    try {
                        DefaultMQProducerImpl.this.makeSureStateOK();
                        Validators.checkMessage(msg, DefaultMQProducerImpl.this.defaultMQProducer);
                        if (!msg.getTopic().equals(mq.getTopic())) {
                            throw new MQClientException("Topic of the message does not match its target message queue", null);
                        }
                        long costTime = System.currentTimeMillis() - beginStartTime;
                        if (timeout > costTime) {
                            try {
                                DefaultMQProducerImpl.this.sendKernelImpl(msg, mq, CommunicationMode.ASYNC, newCallBack, null, timeout - costTime);
                                break block6;
                            }
                            catch (MQBrokerException e) {
                                throw new MQClientException("unknown exception", e);
                            }
                        }
                        newCallBack.onException((Throwable)new RemotingTooMuchRequestException("call timeout"));
                    }
                    catch (Exception e) {
                        newCallBack.onException(e);
                    }
                }
            }
        };
        this.executeAsyncMessageSend(runnable, msg, newCallBack, timeout, beginStartTime);
    }

    public void sendOneway(Message msg, MessageQueue mq) throws MQClientException, RemotingException, InterruptedException {
        this.makeSureStateOK();
        Validators.checkMessage(msg, this.defaultMQProducer);
        try {
            this.sendKernelImpl(msg, mq, CommunicationMode.ONEWAY, null, null, this.defaultMQProducer.getSendMsgTimeout());
        }
        catch (MQBrokerException e) {
            throw new MQClientException("unknown exception", e);
        }
    }

    public SendResult send(Message msg, MessageQueueSelector selector, Object arg) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.send(msg, selector, arg, (long)this.defaultMQProducer.getSendMsgTimeout());
    }

    public SendResult send(Message msg, MessageQueueSelector selector, Object arg, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.sendSelectImpl(msg, selector, arg, CommunicationMode.SYNC, null, timeout);
    }

    private SendResult sendSelectImpl(Message msg, MessageQueueSelector selector, Object arg, CommunicationMode communicationMode, SendCallback sendCallback, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        long beginStartTime = System.currentTimeMillis();
        this.makeSureStateOK();
        Validators.checkMessage(msg, this.defaultMQProducer);
        TopicPublishInfo topicPublishInfo = this.tryToFindTopicPublishInfo(msg.getTopic());
        if (topicPublishInfo != null && topicPublishInfo.ok()) {
            MessageQueue mq = null;
            try {
                List<MessageQueue> messageQueueList = this.mQClientFactory.getMQAdminImpl().parsePublishMessageQueues(topicPublishInfo.getMessageQueueList());
                Message userMessage = MessageAccessor.cloneMessage((Message)msg);
                String userTopic = NamespaceUtil.withoutNamespace((String)userMessage.getTopic(), (String)this.mQClientFactory.getClientConfig().getNamespace());
                userMessage.setTopic(userTopic);
                mq = this.mQClientFactory.getClientConfig().queueWithNamespace(selector.select(messageQueueList, userMessage, arg));
            }
            catch (Throwable e) {
                throw new MQClientException("select message queue threw exception.", e);
            }
            long costTime = System.currentTimeMillis() - beginStartTime;
            if (timeout < costTime) {
                throw new RemotingTooMuchRequestException("sendSelectImpl call timeout");
            }
            if (mq != null) {
                return this.sendKernelImpl(msg, mq, communicationMode, sendCallback, null, timeout - costTime);
            }
            throw new MQClientException("select message queue return null.", null);
        }
        this.validateNameServerSetting();
        throw new MQClientException("No route info for this topic, " + msg.getTopic(), null);
    }

    public void send(Message msg, MessageQueueSelector selector, Object arg, SendCallback sendCallback) throws MQClientException, RemotingException, InterruptedException {
        this.send(msg, selector, arg, sendCallback, this.defaultMQProducer.getSendMsgTimeout());
    }

    @Deprecated
    public void send(final Message msg, final MessageQueueSelector selector, final Object arg, SendCallback sendCallback, final long timeout) throws MQClientException, RemotingException, InterruptedException {
        final BackpressureSendCallBack newCallBack = new BackpressureSendCallBack(sendCallback);
        final long beginStartTime = System.currentTimeMillis();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                long costTime = System.currentTimeMillis() - beginStartTime;
                if (timeout > costTime) {
                    try {
                        try {
                            DefaultMQProducerImpl.this.sendSelectImpl(msg, selector, arg, CommunicationMode.ASYNC, newCallBack, timeout - costTime);
                        }
                        catch (MQBrokerException e) {
                            throw new MQClientException("unknown exception", e);
                        }
                    }
                    catch (Exception e) {
                        newCallBack.onException(e);
                    }
                } else {
                    newCallBack.onException((Throwable)new RemotingTooMuchRequestException("call timeout"));
                }
            }
        };
        this.executeAsyncMessageSend(runnable, msg, newCallBack, timeout, beginStartTime);
    }

    public void sendOneway(Message msg, MessageQueueSelector selector, Object arg) throws MQClientException, RemotingException, InterruptedException {
        try {
            this.sendSelectImpl(msg, selector, arg, CommunicationMode.ONEWAY, null, this.defaultMQProducer.getSendMsgTimeout());
        }
        catch (MQBrokerException e) {
            throw new MQClientException("unknown exception", e);
        }
    }

    public TransactionSendResult sendMessageInTransaction(Message msg, TransactionListener localTransactionListener, Object arg) throws MQClientException {
        TransactionListener transactionListener = this.getCheckListener();
        if (null == localTransactionListener && null == transactionListener) {
            throw new MQClientException("tranExecutor is null", null);
        }
        if (msg.getDelayTimeLevel() != 0) {
            MessageAccessor.clearProperty((Message)msg, (String)"DELAY");
        }
        Validators.checkMessage(msg, this.defaultMQProducer);
        SendResult sendResult = null;
        MessageAccessor.putProperty((Message)msg, (String)"TRAN_MSG", (String)"true");
        MessageAccessor.putProperty((Message)msg, (String)"PGROUP", (String)this.defaultMQProducer.getProducerGroup());
        try {
            sendResult = this.send(msg);
        }
        catch (Exception e) {
            throw new MQClientException("send message Exception", e);
        }
        LocalTransactionState localTransactionState = LocalTransactionState.UNKNOW;
        Throwable localException = null;
        switch (sendResult.getSendStatus()) {
            case SEND_OK: {
                try {
                    String transactionId;
                    if (sendResult.getTransactionId() != null) {
                        msg.putUserProperty("__transactionId__", sendResult.getTransactionId());
                    }
                    if (null != (transactionId = msg.getProperty("UNIQ_KEY")) && !"".equals(transactionId)) {
                        msg.setTransactionId(transactionId);
                    }
                    if (null != localTransactionListener) {
                        localTransactionState = localTransactionListener.executeLocalTransaction(msg, arg);
                    } else {
                        this.log.debug("Used new transaction API");
                        localTransactionState = transactionListener.executeLocalTransaction(msg, arg);
                    }
                    if (null == localTransactionState) {
                        localTransactionState = LocalTransactionState.UNKNOW;
                    }
                    if (localTransactionState == LocalTransactionState.COMMIT_MESSAGE) break;
                    this.log.info("executeLocalTransactionBranch return: {} messageTopic: {} transactionId: {} tag: {} key: {}", new Object[]{localTransactionState, msg.getTopic(), msg.getTransactionId(), msg.getTags(), msg.getKeys()});
                }
                catch (Throwable e) {
                    this.log.error("executeLocalTransactionBranch exception, messageTopic: {} transactionId: {} tag: {} key: {}", new Object[]{msg.getTopic(), msg.getTransactionId(), msg.getTags(), msg.getKeys(), e});
                    localException = e;
                }
                break;
            }
            case FLUSH_DISK_TIMEOUT: 
            case FLUSH_SLAVE_TIMEOUT: 
            case SLAVE_NOT_AVAILABLE: {
                localTransactionState = LocalTransactionState.ROLLBACK_MESSAGE;
                break;
            }
        }
        try {
            this.endTransaction(msg, sendResult, localTransactionState, localException);
        }
        catch (Exception e) {
            this.log.warn("local transaction execute " + (Object)((Object)localTransactionState) + ", but end broker transaction failed", (Throwable)e);
        }
        TransactionSendResult transactionSendResult = new TransactionSendResult();
        transactionSendResult.setSendStatus(sendResult.getSendStatus());
        transactionSendResult.setMessageQueue(sendResult.getMessageQueue());
        transactionSendResult.setMsgId(sendResult.getMsgId());
        transactionSendResult.setQueueOffset(sendResult.getQueueOffset());
        transactionSendResult.setTransactionId(sendResult.getTransactionId());
        transactionSendResult.setLocalTransactionState(localTransactionState);
        return transactionSendResult;
    }

    public SendResult send(Message msg) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.send(msg, this.defaultMQProducer.getSendMsgTimeout());
    }

    public void endTransaction(Message msg, SendResult sendResult, LocalTransactionState localTransactionState, Throwable localException) throws RemotingException, MQBrokerException, InterruptedException, UnknownHostException {
        MessageId id = sendResult.getOffsetMsgId() != null ? MessageDecoder.decodeMessageId((String)sendResult.getOffsetMsgId()) : MessageDecoder.decodeMessageId((String)sendResult.getMsgId());
        String transactionId = sendResult.getTransactionId();
        String destBrokerName = this.mQClientFactory.getBrokerNameFromMessageQueue(this.defaultMQProducer.queueWithNamespace(sendResult.getMessageQueue()));
        String brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(destBrokerName);
        EndTransactionRequestHeader requestHeader = new EndTransactionRequestHeader();
        requestHeader.setTopic(msg.getTopic());
        requestHeader.setTransactionId(transactionId);
        requestHeader.setCommitLogOffset(Long.valueOf(id.getOffset()));
        requestHeader.setBrokerName(destBrokerName);
        switch (localTransactionState) {
            case COMMIT_MESSAGE: {
                requestHeader.setCommitOrRollback(Integer.valueOf(8));
                break;
            }
            case ROLLBACK_MESSAGE: {
                requestHeader.setCommitOrRollback(Integer.valueOf(12));
                break;
            }
            case UNKNOW: {
                requestHeader.setCommitOrRollback(Integer.valueOf(0));
                break;
            }
        }
        this.doExecuteEndTransactionHook(msg, sendResult.getMsgId(), brokerAddr, localTransactionState, false);
        requestHeader.setProducerGroup(this.defaultMQProducer.getProducerGroup());
        requestHeader.setTranStateTableOffset(Long.valueOf(sendResult.getQueueOffset()));
        requestHeader.setMsgId(sendResult.getMsgId());
        String remark = localException != null ? "executeLocalTransactionBranch exception: " + localException.toString() : null;
        this.mQClientFactory.getMQClientAPIImpl().endTransactionOneway(brokerAddr, requestHeader, remark, this.defaultMQProducer.getSendMsgTimeout());
    }

    public String recallMessage(String topic, String recallHandle) throws RemotingException, MQClientException, MQBrokerException, InterruptedException {
        RecallMessageHandle.HandleV1 handleEntity;
        this.makeSureStateOK();
        Validators.checkTopic(topic);
        if (NamespaceUtil.isRetryTopic((String)topic) || NamespaceUtil.isDLQTopic((String)topic)) {
            throw new MQClientException("topic is not supported", null);
        }
        try {
            handleEntity = (RecallMessageHandle.HandleV1)RecallMessageHandle.decodeHandle((String)recallHandle);
        }
        catch (Exception e) {
            throw new MQClientException(e.getMessage(), null);
        }
        this.tryToFindTopicPublishInfo(topic);
        String brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(handleEntity.getBrokerName());
        String string = brokerAddr = StringUtils.isNotEmpty((CharSequence)brokerAddr) ? brokerAddr : this.mQClientFactory.findBrokerAddrByTopic(topic);
        if (StringUtils.isEmpty((CharSequence)brokerAddr)) {
            this.log.warn("can't find broker service address. {}", (Object)handleEntity.getBrokerName());
            throw new MQClientException("The broker service address not found", null);
        }
        RecallMessageRequestHeader requestHeader = new RecallMessageRequestHeader();
        requestHeader.setProducerGroup(this.defaultMQProducer.getProducerGroup());
        requestHeader.setTopic(topic);
        requestHeader.setRecallHandle(recallHandle);
        requestHeader.setBrokerName(handleEntity.getBrokerName());
        return this.mQClientFactory.getMQClientAPIImpl().recallMessage(brokerAddr, requestHeader, this.defaultMQProducer.getSendMsgTimeout());
    }

    public void setCallbackExecutor(ExecutorService callbackExecutor) {
        this.mQClientFactory.getMQClientAPIImpl().getRemotingClient().setCallbackExecutor(callbackExecutor);
    }

    public ExecutorService getAsyncSenderExecutor() {
        return null == this.asyncSenderExecutor ? this.defaultAsyncSenderExecutor : this.asyncSenderExecutor;
    }

    public void setAsyncSenderExecutor(ExecutorService asyncSenderExecutor) {
        this.asyncSenderExecutor = asyncSenderExecutor;
    }

    public SendResult send(Message msg, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.sendDefaultImpl(msg, CommunicationMode.SYNC, null, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message request(Message msg, long timeout) throws RequestTimeoutException, MQClientException, RemotingException, MQBrokerException, InterruptedException {
        long beginTimestamp = System.currentTimeMillis();
        this.prepareSendRequest(msg, timeout);
        String correlationId = msg.getProperty("CORRELATION_ID");
        try {
            final RequestResponseFuture requestResponseFuture = new RequestResponseFuture(correlationId, timeout, null);
            RequestFutureHolder.getInstance().getRequestFutureTable().put(correlationId, requestResponseFuture);
            long cost = System.currentTimeMillis() - beginTimestamp;
            this.sendDefaultImpl(msg, CommunicationMode.ASYNC, new SendCallback(){

                @Override
                public void onSuccess(SendResult sendResult) {
                    requestResponseFuture.setSendRequestOk(true);
                    requestResponseFuture.acquireCountDownLatch();
                }

                @Override
                public void onException(Throwable e) {
                    requestResponseFuture.setSendRequestOk(false);
                    requestResponseFuture.putResponseMessage(null);
                    requestResponseFuture.setCause(e);
                }
            }, timeout - cost);
            Message message = this.waitResponse(msg, timeout, requestResponseFuture, cost);
            return message;
        }
        finally {
            RequestFutureHolder.getInstance().getRequestFutureTable().remove(correlationId);
        }
    }

    public void request(Message msg, RequestCallback requestCallback, long timeout) throws RemotingException, InterruptedException, MQClientException, MQBrokerException {
        long beginTimestamp = System.currentTimeMillis();
        this.prepareSendRequest(msg, timeout);
        final String correlationId = msg.getProperty("CORRELATION_ID");
        final RequestResponseFuture requestResponseFuture = new RequestResponseFuture(correlationId, timeout, requestCallback);
        RequestFutureHolder.getInstance().getRequestFutureTable().put(correlationId, requestResponseFuture);
        long cost = System.currentTimeMillis() - beginTimestamp;
        this.sendDefaultImpl(msg, CommunicationMode.ASYNC, new SendCallback(){

            @Override
            public void onSuccess(SendResult sendResult) {
                requestResponseFuture.setSendRequestOk(true);
                requestResponseFuture.executeRequestCallback();
            }

            @Override
            public void onException(Throwable e) {
                requestResponseFuture.setCause(e);
                DefaultMQProducerImpl.this.requestFail(correlationId);
            }
        }, timeout - cost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message request(Message msg, MessageQueueSelector selector, Object arg, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException, RequestTimeoutException {
        long beginTimestamp = System.currentTimeMillis();
        this.prepareSendRequest(msg, timeout);
        String correlationId = msg.getProperty("CORRELATION_ID");
        try {
            final RequestResponseFuture requestResponseFuture = new RequestResponseFuture(correlationId, timeout, null);
            RequestFutureHolder.getInstance().getRequestFutureTable().put(correlationId, requestResponseFuture);
            long cost = System.currentTimeMillis() - beginTimestamp;
            this.sendSelectImpl(msg, selector, arg, CommunicationMode.ASYNC, new SendCallback(){

                @Override
                public void onSuccess(SendResult sendResult) {
                    requestResponseFuture.setSendRequestOk(true);
                    requestResponseFuture.acquireCountDownLatch();
                }

                @Override
                public void onException(Throwable e) {
                    requestResponseFuture.setSendRequestOk(false);
                    requestResponseFuture.putResponseMessage(null);
                    requestResponseFuture.setCause(e);
                }
            }, timeout - cost);
            Message message = this.waitResponse(msg, timeout, requestResponseFuture, cost);
            return message;
        }
        finally {
            RequestFutureHolder.getInstance().getRequestFutureTable().remove(correlationId);
        }
    }

    public void request(Message msg, MessageQueueSelector selector, Object arg, RequestCallback requestCallback, long timeout) throws RemotingException, InterruptedException, MQClientException, MQBrokerException {
        long beginTimestamp = System.currentTimeMillis();
        this.prepareSendRequest(msg, timeout);
        final String correlationId = msg.getProperty("CORRELATION_ID");
        final RequestResponseFuture requestResponseFuture = new RequestResponseFuture(correlationId, timeout, requestCallback);
        RequestFutureHolder.getInstance().getRequestFutureTable().put(correlationId, requestResponseFuture);
        long cost = System.currentTimeMillis() - beginTimestamp;
        this.sendSelectImpl(msg, selector, arg, CommunicationMode.ASYNC, new SendCallback(){

            @Override
            public void onSuccess(SendResult sendResult) {
                requestResponseFuture.setSendRequestOk(true);
            }

            @Override
            public void onException(Throwable e) {
                requestResponseFuture.setCause(e);
                DefaultMQProducerImpl.this.requestFail(correlationId);
            }
        }, timeout - cost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message request(Message msg, MessageQueue mq, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException, RequestTimeoutException {
        long beginTimestamp = System.currentTimeMillis();
        this.prepareSendRequest(msg, timeout);
        String correlationId = msg.getProperty("CORRELATION_ID");
        try {
            final RequestResponseFuture requestResponseFuture = new RequestResponseFuture(correlationId, timeout, null);
            RequestFutureHolder.getInstance().getRequestFutureTable().put(correlationId, requestResponseFuture);
            long cost = System.currentTimeMillis() - beginTimestamp;
            this.sendKernelImpl(msg, mq, CommunicationMode.ASYNC, new SendCallback(){

                @Override
                public void onSuccess(SendResult sendResult) {
                    requestResponseFuture.setSendRequestOk(true);
                    requestResponseFuture.acquireCountDownLatch();
                }

                @Override
                public void onException(Throwable e) {
                    requestResponseFuture.setSendRequestOk(false);
                    requestResponseFuture.putResponseMessage(null);
                    requestResponseFuture.setCause(e);
                }
            }, null, timeout - cost);
            Message message = this.waitResponse(msg, timeout, requestResponseFuture, cost);
            return message;
        }
        finally {
            RequestFutureHolder.getInstance().getRequestFutureTable().remove(correlationId);
        }
    }

    private Message waitResponse(Message msg, long timeout, RequestResponseFuture requestResponseFuture, long cost) throws InterruptedException, RequestTimeoutException, MQClientException {
        Message responseMessage = requestResponseFuture.waitResponseMessage(timeout - cost);
        if (responseMessage == null) {
            if (requestResponseFuture.isSendRequestOk()) {
                throw new RequestTimeoutException(10006, "send request message to <" + msg.getTopic() + "> OK, but wait reply message timeout, " + timeout + " ms.");
            }
            throw new MQClientException("send request message to <" + msg.getTopic() + "> fail", requestResponseFuture.getCause());
        }
        return responseMessage;
    }

    public void request(Message msg, MessageQueue mq, RequestCallback requestCallback, long timeout) throws RemotingException, InterruptedException, MQClientException, MQBrokerException {
        long beginTimestamp = System.currentTimeMillis();
        this.prepareSendRequest(msg, timeout);
        final String correlationId = msg.getProperty("CORRELATION_ID");
        final RequestResponseFuture requestResponseFuture = new RequestResponseFuture(correlationId, timeout, requestCallback);
        RequestFutureHolder.getInstance().getRequestFutureTable().put(correlationId, requestResponseFuture);
        long cost = System.currentTimeMillis() - beginTimestamp;
        this.sendKernelImpl(msg, mq, CommunicationMode.ASYNC, new SendCallback(){

            @Override
            public void onSuccess(SendResult sendResult) {
                requestResponseFuture.setSendRequestOk(true);
            }

            @Override
            public void onException(Throwable e) {
                requestResponseFuture.setCause(e);
                DefaultMQProducerImpl.this.requestFail(correlationId);
            }
        }, null, timeout - cost);
    }

    private void requestFail(String correlationId) {
        RequestResponseFuture responseFuture = RequestFutureHolder.getInstance().getRequestFutureTable().remove(correlationId);
        if (responseFuture != null) {
            responseFuture.setSendRequestOk(false);
            responseFuture.putResponseMessage(null);
            try {
                responseFuture.executeRequestCallback();
            }
            catch (Exception e) {
                this.log.warn("execute requestCallback in requestFail, and callback throw", (Throwable)e);
            }
        }
    }

    private void prepareSendRequest(Message msg, long timeout) {
        String correlationId = CorrelationIdUtil.createCorrelationId();
        String requestClientId = this.getMqClientFactory().getClientId();
        MessageAccessor.putProperty((Message)msg, (String)"CORRELATION_ID", (String)correlationId);
        MessageAccessor.putProperty((Message)msg, (String)"REPLY_TO_CLIENT", (String)requestClientId);
        MessageAccessor.putProperty((Message)msg, (String)"TTL", (String)String.valueOf(timeout));
        boolean hasRouteData = this.getMqClientFactory().getTopicRouteTable().containsKey(msg.getTopic());
        if (!hasRouteData) {
            long beginTimestamp = System.currentTimeMillis();
            this.tryToFindTopicPublishInfo(msg.getTopic());
            this.getMqClientFactory().sendHeartbeatToAllBrokerWithLock();
            long cost = System.currentTimeMillis() - beginTimestamp;
            if (cost > 500L) {
                this.log.warn("prepare send request for <{}> cost {} ms", (Object)msg.getTopic(), (Object)cost);
            }
        }
    }

    private void initTopicRoute() {
        List<String> topics = this.defaultMQProducer.getTopics();
        if (topics != null && topics.size() > 0) {
            topics.forEach(topic -> {
                String newTopic = NamespaceUtil.wrapNamespace((String)this.defaultMQProducer.getNamespace(), (String)topic);
                TopicPublishInfo topicPublishInfo = this.tryToFindTopicPublishInfo(newTopic);
                if (topicPublishInfo == null || !topicPublishInfo.ok()) {
                    this.log.warn("No route info of this topic: " + newTopic + FAQUrl.suggestTodo((String)"https://rocketmq.apache.org/docs/bestPractice/06FAQ"));
                }
            });
        }
    }

    public ConcurrentMap<String, TopicPublishInfo> getTopicPublishInfoTable() {
        return this.topicPublishInfoTable;
    }

    public ServiceState getServiceState() {
        return this.serviceState;
    }

    public void setServiceState(ServiceState serviceState) {
        this.serviceState = serviceState;
    }

    public long[] getNotAvailableDuration() {
        return this.mqFaultStrategy.getNotAvailableDuration();
    }

    public void setNotAvailableDuration(long[] notAvailableDuration) {
        this.mqFaultStrategy.setNotAvailableDuration(notAvailableDuration);
    }

    public long[] getLatencyMax() {
        return this.mqFaultStrategy.getLatencyMax();
    }

    public void setLatencyMax(long[] latencyMax) {
        this.mqFaultStrategy.setLatencyMax(latencyMax);
    }

    public boolean isSendLatencyFaultEnable() {
        return this.mqFaultStrategy.isSendLatencyFaultEnable();
    }

    public void setSendLatencyFaultEnable(boolean sendLatencyFaultEnable) {
        this.mqFaultStrategy.setSendLatencyFaultEnable(sendLatencyFaultEnable);
    }

    public DefaultMQProducer getDefaultMQProducer() {
        return this.defaultMQProducer;
    }

    public MQFaultStrategy getMqFaultStrategy() {
        return this.mqFaultStrategy;
    }

    class BackpressureSendCallBack
    implements SendCallback {
        public boolean isSemaphoreAsyncSizeAcquired = false;
        public boolean isSemaphoreAsyncNumAcquired = false;
        public int msgLen;
        private final SendCallback sendCallback;

        public BackpressureSendCallBack(SendCallback sendCallback) {
            this.sendCallback = sendCallback;
        }

        @Override
        public void onSuccess(SendResult sendResult) {
            this.semaphoreProcessor();
            this.sendCallback.onSuccess(sendResult);
        }

        @Override
        public void onException(Throwable e) {
            this.semaphoreProcessor();
            this.sendCallback.onException(e);
        }

        public void semaphoreProcessor() {
            if (this.isSemaphoreAsyncSizeAcquired) {
                DefaultMQProducerImpl.this.defaultMQProducer.acquireBackPressureForAsyncSendSizeLock();
                DefaultMQProducerImpl.this.semaphoreAsyncSendSize.release(this.msgLen);
                DefaultMQProducerImpl.this.defaultMQProducer.releaseBackPressureForAsyncSendSizeLock();
            }
            if (this.isSemaphoreAsyncNumAcquired) {
                DefaultMQProducerImpl.this.defaultMQProducer.acquireBackPressureForAsyncSendNumLock();
                DefaultMQProducerImpl.this.semaphoreAsyncSendNum.release();
                DefaultMQProducerImpl.this.defaultMQProducer.releaseBackPressureForAsyncSendNumLock();
            }
        }

        public void semaphoreAsyncAdjust(int semaphoreAsyncNum, int semaphoreAsyncSize) throws InterruptedException {
            DefaultMQProducerImpl.this.defaultMQProducer.acquireBackPressureForAsyncSendNumLock();
            if (semaphoreAsyncNum > 0) {
                DefaultMQProducerImpl.this.semaphoreAsyncSendNum.release(semaphoreAsyncNum);
            } else {
                DefaultMQProducerImpl.this.semaphoreAsyncSendNum.acquire(-semaphoreAsyncNum);
            }
            DefaultMQProducerImpl.this.defaultMQProducer.setBackPressureForAsyncSendNumInsideAdjust(DefaultMQProducerImpl.this.defaultMQProducer.getBackPressureForAsyncSendNum() + semaphoreAsyncNum);
            DefaultMQProducerImpl.this.defaultMQProducer.releaseBackPressureForAsyncSendNumLock();
            DefaultMQProducerImpl.this.defaultMQProducer.acquireBackPressureForAsyncSendSizeLock();
            if (semaphoreAsyncSize > 0) {
                DefaultMQProducerImpl.this.semaphoreAsyncSendSize.release(semaphoreAsyncSize);
            } else {
                DefaultMQProducerImpl.this.semaphoreAsyncSendSize.acquire(-semaphoreAsyncSize);
            }
            DefaultMQProducerImpl.this.defaultMQProducer.setBackPressureForAsyncSendSizeInsideAdjust(DefaultMQProducerImpl.this.defaultMQProducer.getBackPressureForAsyncSendSize() + semaphoreAsyncSize);
            DefaultMQProducerImpl.this.defaultMQProducer.releaseBackPressureForAsyncSendSizeLock();
        }
    }
}

