/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.remoting;

import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.cert.CertificateException;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.netty.TlsHelper;
import org.apache.rocketmq.remoting.netty.TlsSystemConfig;

public class MultiProtocolTlsHelper
extends TlsHelper {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    private static final TlsHelper.DecryptionStrategy DECRYPTION_STRATEGY = (privateKeyEncryptPath, forClient) -> new FileInputStream(privateKeyEncryptPath);

    public static SslContext buildSslContext() throws IOException, CertificateException {
        SslProvider provider;
        TlsHelper.buildSslContext((boolean)false);
        if (OpenSsl.isAvailable()) {
            provider = SslProvider.OPENSSL;
            log.info("Using OpenSSL provider");
        } else {
            provider = SslProvider.JDK;
            log.info("Using JDK SSL provider");
        }
        SslContextBuilder sslContextBuilder = null;
        if (TlsSystemConfig.tlsTestModeEnable) {
            SelfSignedCertificate selfSignedCertificate = new SelfSignedCertificate();
            sslContextBuilder = SslContextBuilder.forServer((File)selfSignedCertificate.certificate(), (File)selfSignedCertificate.privateKey()).sslProvider(SslProvider.OPENSSL).clientAuth(ClientAuth.OPTIONAL);
        } else {
            sslContextBuilder = SslContextBuilder.forServer((InputStream)(!StringUtils.isBlank((CharSequence)TlsSystemConfig.tlsServerCertPath) ? Files.newInputStream(Paths.get(TlsSystemConfig.tlsServerCertPath, new String[0]), new OpenOption[0]) : null), (InputStream)(!StringUtils.isBlank((CharSequence)TlsSystemConfig.tlsServerKeyPath) ? DECRYPTION_STRATEGY.decryptPrivateKey(TlsSystemConfig.tlsServerKeyPath, false) : null), (String)(!StringUtils.isBlank((CharSequence)TlsSystemConfig.tlsServerKeyPassword) ? TlsSystemConfig.tlsServerKeyPassword : null)).sslProvider(provider);
            if (!TlsSystemConfig.tlsServerAuthClient) {
                sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            } else if (!StringUtils.isBlank((CharSequence)TlsSystemConfig.tlsServerTrustCertPath)) {
                sslContextBuilder.trustManager(new File(TlsSystemConfig.tlsServerTrustCertPath));
            }
            sslContextBuilder.clientAuth(MultiProtocolTlsHelper.parseClientAuthMode(TlsSystemConfig.tlsServerNeedClientAuth));
        }
        sslContextBuilder.applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2"}));
        return sslContextBuilder.build();
    }

    private static ClientAuth parseClientAuthMode(String authMode) {
        if (null == authMode || authMode.trim().isEmpty()) {
            return ClientAuth.NONE;
        }
        String authModeUpper = authMode.toUpperCase();
        for (ClientAuth clientAuth : ClientAuth.values()) {
            if (!clientAuth.name().equals(authModeUpper)) continue;
            return clientAuth;
        }
        return ClientAuth.NONE;
    }
}

