/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.ws;

import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.swagger.invocation.ws.WebSocket;
import org.apache.servicecomb.swagger.invocation.ws.WebSocketAdapter;
import org.apache.servicecomb.swagger.invocation.ws.WebSocketFrame;
import org.apache.servicecomb.swagger.invocation.ws.WebSocketMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseWebSocket
implements WebSocket {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBaseWebSocket.class);
    private WebSocketAdapter webSocketAdapter;
    private WebSocket.Status status = WebSocket.Status.CREATED;
    private CompletableFuture<Void> closeFuture;
    private Short closeStatusCode;
    private String closeReason;

    @Override
    public CompletableFuture<Void> sendMessage(WebSocketMessage<?> message) {
        return this.webSocketAdapter.sendMessage(message);
    }

    @Override
    public CompletableFuture<Void> sendFrame(WebSocketFrame frame) {
        return this.webSocketAdapter.sendFrame(frame);
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.close((short)WebSocketCloseStatus.NORMAL_CLOSURE.code(), WebSocketCloseStatus.NORMAL_CLOSURE.reasonText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> close(Short closeStatusCode, String closeReason) {
        if (closeStatusCode == null || closeReason == null) {
            LOGGER.error("a WebSocket is closed by null closeStatusCode or closeReason");
            closeStatusCode = (short)WebSocketCloseStatus.INTERNAL_SERVER_ERROR.code();
            closeReason = WebSocketCloseStatus.INTERNAL_SERVER_ERROR.reasonText();
        }
        AbstractBaseWebSocket abstractBaseWebSocket = this;
        synchronized (abstractBaseWebSocket) {
            if (this.status == WebSocket.Status.WAITING_TO_CLOSE || this.status == WebSocket.Status.CLOSING || this.status == WebSocket.Status.CLOSED) {
                return CompletableFuture.completedFuture(null);
            }
            this.status = WebSocket.Status.WAITING_TO_CLOSE;
            this.closeStatusCode = closeStatusCode;
            this.closeReason = closeReason;
            if (this.webSocketAdapter == null) {
                this.closeFuture = new CompletableFuture();
                return this.closeFuture;
            }
            this.status = WebSocket.Status.CLOSING;
        }
        return this.webSocketAdapter.close(closeStatusCode, closeReason).whenComplete((v, t) -> {
            this.status = WebSocket.Status.CLOSED;
        });
    }

    @Override
    public void pause() {
        this.status = WebSocket.Status.PAUSED;
        this.webSocketAdapter.pause();
    }

    @Override
    public void resume() {
        this.status = WebSocket.Status.RUNNING;
        this.webSocketAdapter.resume();
    }

    @Override
    public boolean writeQueueFull() {
        return this.webSocketAdapter.writeQueueFull();
    }

    @Override
    public void onWriteQueueDrain() {
    }

    public void setWebSocketAdapter(WebSocketAdapter webSocketAdapter) {
        this.webSocketAdapter = webSocketAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWorking() {
        AbstractBaseWebSocket abstractBaseWebSocket = this;
        synchronized (abstractBaseWebSocket) {
            if (this.status == WebSocket.Status.WAITING_TO_CLOSE) {
                this.status = WebSocket.Status.CLOSING;
                this.webSocketAdapter.close(this.closeStatusCode, this.closeReason).whenComplete((v, t) -> {
                    this.status = WebSocket.Status.CLOSED;
                    if (t != null) {
                        this.closeFuture.completeExceptionally((Throwable)t);
                    } else {
                        this.closeFuture.complete(null);
                    }
                });
                return;
            }
            this.status = WebSocket.Status.RUNNING;
        }
        this.onConnectionReady();
    }

    @Override
    public WebSocket.Status getStatus() {
        return this.status;
    }
}

