/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.connectors.ping.wl;

import java.util.UUID;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.sling.discovery.base.connectors.ping.wl.WildcardHelper;
import org.junit.Assert;
import org.junit.Test;

public class WildcardHelperTest {
    @Test
    public void testNullValues() {
        SubnetUtils s = new SubnetUtils("1.2.3.4/10");
        s = new SubnetUtils("1.2.3.4", "255.255.0.0");
        try {
            WildcardHelper.wildcardAsRegex(null);
            Assert.fail((String)"should complain");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            WildcardHelper.matchesWildcard(null, (String)"foo");
            Assert.fail((String)"should complain");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            WildcardHelper.matchesWildcard((String)"foo", null);
            Assert.fail((String)"should complain");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testEmptyValue() {
        String expected = "\\Q\\E";
        Assert.assertEquals((Object)"\\Q\\E", (Object)WildcardHelper.wildcardAsRegex((String)""));
    }

    @Test
    public void testWithoutWildcards() {
        for (int i = 0; i < 1000; ++i) {
            String randomString = UUID.randomUUID().toString();
            Assert.assertTrue((boolean)WildcardHelper.matchesWildcard((String)randomString, (String)randomString));
        }
    }

    @Test
    public void testWildcards() {
        Assert.assertTrue((boolean)WildcardHelper.matchesWildcard((String)"", (String)"*"));
        Assert.assertTrue((boolean)WildcardHelper.matchesWildcard((String)"fooo", (String)"*"));
        Assert.assertTrue((boolean)WildcardHelper.matchesWildcard((String)"fooo", (String)"**"));
        Assert.assertTrue((boolean)WildcardHelper.matchesWildcard((String)"fooo", (String)"**?"));
        Assert.assertTrue((boolean)WildcardHelper.matchesWildcard((String)"fooo", (String)"????"));
        Assert.assertFalse((boolean)WildcardHelper.matchesWildcard((String)"fooo", (String)"???"));
        Assert.assertFalse((boolean)WildcardHelper.matchesWildcard((String)"fooo", (String)"?????"));
        for (int i = 0; i < 100; ++i) {
            String randomString = UUID.randomUUID().toString();
            Assert.assertTrue((boolean)WildcardHelper.matchesWildcard((String)randomString, (String)"*"));
            Assert.assertTrue((boolean)WildcardHelper.matchesWildcard((String)randomString, (String)(randomString.substring(0, randomString.length() - 1) + "?")));
            Assert.assertTrue((boolean)WildcardHelper.matchesWildcard((String)randomString, (String)(randomString.substring(0, randomString.length() - 1) + "*")));
            Assert.assertTrue((boolean)WildcardHelper.matchesWildcard((String)randomString, (String)(randomString.substring(0, randomString.length() - 2) + "??")));
            Assert.assertTrue((boolean)WildcardHelper.matchesWildcard((String)randomString, (String)(randomString.substring(0, randomString.length() - 2) + "*")));
            Assert.assertTrue((boolean)WildcardHelper.matchesWildcard((String)randomString, (String)("?" + randomString.substring(1, randomString.length()))));
            Assert.assertTrue((boolean)WildcardHelper.matchesWildcard((String)randomString, (String)("*" + randomString.substring(1, randomString.length()))));
            Assert.assertTrue((boolean)WildcardHelper.matchesWildcard((String)randomString, (String)("??" + randomString.substring(2, randomString.length()))));
            Assert.assertTrue((boolean)WildcardHelper.matchesWildcard((String)randomString, (String)("*" + randomString.substring(2, randomString.length()))));
        }
        Assert.assertTrue((boolean)WildcardHelper.matchesWildcard((String)"fooo", (String)"f*"));
        Assert.assertTrue((boolean)WildcardHelper.matchesWildcard((String)"fooo", (String)"fo*"));
        Assert.assertTrue((boolean)WildcardHelper.matchesWildcard((String)"fooo", (String)"foo*"));
        Assert.assertTrue((boolean)WildcardHelper.matchesWildcard((String)"fooo", (String)"fooo*"));
        Assert.assertFalse((boolean)WildcardHelper.matchesWildcard((String)"fooo", (String)"fooo?"));
        Assert.assertFalse((boolean)WildcardHelper.matchesWildcard((String)"fooo", (String)"foooo*"));
        Assert.assertTrue((boolean)WildcardHelper.matchesWildcard((String)"fooo", (String)"*"));
        Assert.assertFalse((boolean)WildcardHelper.matchesWildcard((String)"fooo", (String)"?"));
        Assert.assertFalse((boolean)WildcardHelper.matchesWildcard((String)"fooo", (String)"f?"));
        Assert.assertTrue((boolean)WildcardHelper.matchesWildcard((String)"fo", (String)"f?"));
        Assert.assertTrue((boolean)WildcardHelper.matchesWildcard((String)"foooba", (String)"f*b?"));
        Assert.assertFalse((boolean)WildcardHelper.matchesWildcard((String)"fooobar", (String)"f*b?"));
        Assert.assertFalse((boolean)WildcardHelper.matchesWildcard((String)"foooba", (String)"f*b?r"));
        Assert.assertTrue((boolean)WildcardHelper.matchesWildcard((String)"fooobar", (String)"f*b?r"));
        Assert.assertTrue((boolean)WildcardHelper.matchesWildcard((String)"foooba", (String)"f???b?"));
        Assert.assertFalse((boolean)WildcardHelper.matchesWildcard((String)"foooba", (String)"f??b?"));
        Assert.assertFalse((boolean)WildcardHelper.matchesWildcard((String)"foooba", (String)"f??b?"));
    }
}

