/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.sling.event.impl.jobs.config.InternalQueueConfiguration;
import org.apache.sling.event.impl.jobs.config.MainQueueConfiguration;
import org.apache.sling.event.impl.support.ResourceHelper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={QueueConfigurationManager.class}, property={"service.vendor=The Apache Software Foundation"})
public class QueueConfigurationManager {
    private static final InternalQueueConfiguration[] EMPTY_CONFIGS = new InternalQueueConfiguration[0];
    private volatile InternalQueueConfiguration[] orderedConfigs = EMPTY_CONFIGS;
    private final List<InternalQueueConfiguration> configurations = new ArrayList<InternalQueueConfiguration>();
    @Reference
    private MainQueueConfiguration mainQueueConfiguration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=InternalQueueConfiguration.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, updated="updateConfig")
    protected void bindConfig(InternalQueueConfiguration config) {
        List<InternalQueueConfiguration> list = this.configurations;
        synchronized (list) {
            this.configurations.add(config);
            this.createConfigurationCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindConfig(InternalQueueConfiguration config) {
        List<InternalQueueConfiguration> list = this.configurations;
        synchronized (list) {
            this.configurations.remove(config);
            this.createConfigurationCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateConfig(InternalQueueConfiguration config) {
        List<InternalQueueConfiguration> list = this.configurations;
        synchronized (list) {
            this.createConfigurationCache();
        }
    }

    private void createConfigurationCache() {
        if (this.configurations.isEmpty()) {
            this.orderedConfigs = EMPTY_CONFIGS;
        } else {
            Collections.sort(this.configurations);
            this.orderedConfigs = this.configurations.toArray(new InternalQueueConfiguration[this.configurations.size()]);
        }
    }

    public InternalQueueConfiguration[] getConfigurations() {
        return this.orderedConfigs;
    }

    public InternalQueueConfiguration getMainQueueConfiguration() {
        return this.mainQueueConfiguration.getMainConfiguration();
    }

    public QueueInfo getQueueInfo(String topic) {
        InternalQueueConfiguration[] configurations;
        for (InternalQueueConfiguration config : configurations = this.getConfigurations()) {
            String qn;
            if (!config.isValid() || (qn = config.match(topic)) == null) continue;
            QueueInfo result = new QueueInfo();
            result.queueConfiguration = config;
            result.queueName = ResourceHelper.filterName(qn);
            return result;
        }
        QueueInfo result = new QueueInfo();
        result.queueConfiguration = this.mainQueueConfiguration.getMainConfiguration();
        result.queueName = result.queueConfiguration.getName();
        return result;
    }

    public static final class QueueInfo {
        public InternalQueueConfiguration queueConfiguration;
        public String queueName;
        public String targetId;

        public String toString() {
            return this.queueName;
        }

        public int hashCode() {
            return this.queueName.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof QueueInfo) {
                return ((QueueInfo)obj).queueName.equals(this.queueName);
            }
            return false;
        }
    }
}

