/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.DumpContext;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.Dumpable;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.Filter;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.ImportMode;

public abstract class FilterSet<E extends Filter>
implements Dumpable {
    @NotNull
    private String root;
    @NotNull
    private String rootPattern;
    @Nullable
    private List<Entry<E>> entries;
    private boolean sealed;
    @NotNull
    private ImportMode mode = ImportMode.REPLACE;

    public FilterSet() {
        this("");
    }

    public FilterSet(String root) {
        this.setRoot(root);
    }

    @NotNull
    public String getRoot() {
        return "".equals(this.root) ? "/" : this.root;
    }

    public void setRoot(@NotNull String path) {
        if (this.sealed) {
            throw new UnsupportedOperationException("FilterSet is sealed.");
        }
        if (path.endsWith("/")) {
            this.rootPattern = path;
            this.root = path.substring(0, path.length() - 1);
        } else {
            this.rootPattern = path + "/";
            this.root = path;
        }
    }

    @NotNull
    public ImportMode getImportMode() {
        return this.mode;
    }

    public void setImportMode(@NotNull ImportMode mode) {
        if (this.sealed) {
            throw new UnsupportedOperationException("FilterSet is sealed.");
        }
        this.mode = mode;
    }

    @NotNull
    public FilterSet seal() {
        if (!this.sealed) {
            this.entries = this.entries == null ? Collections.emptyList() : Collections.unmodifiableList(this.entries);
            this.sealed = true;
        }
        return this;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    @NotNull
    public FilterSet addAll(@NotNull FilterSet<E> set) {
        if (this.sealed) {
            throw new UnsupportedOperationException("FilterSet is sealed.");
        }
        this.entries = null;
        if (set.entries != null) {
            this.entries = new LinkedList<Entry<Entry<E>>>(set.entries);
        }
        return this;
    }

    @NotNull
    public FilterSet addInclude(@NotNull E filter) {
        this.addEntry(new Entry<E>(filter, true));
        return this;
    }

    @NotNull
    public FilterSet addExclude(@NotNull E filter) {
        this.addEntry(new Entry<E>(filter, false));
        return this;
    }

    private void addEntry(@NotNull Entry<E> e) {
        if (this.sealed) {
            throw new UnsupportedOperationException("FilterSet is sealed.");
        }
        if (this.entries == null) {
            this.entries = new LinkedList<Entry<E>>();
        }
        this.entries.add(e);
    }

    @NotNull
    public List<Entry<E>> getEntries() {
        this.seal();
        return this.entries;
    }

    public boolean isEmpty() {
        return this.entries == null || this.entries.isEmpty();
    }

    public boolean covers(@NotNull String path) {
        return path.equals(this.root) || path.startsWith(this.rootPattern);
    }

    public boolean isAncestor(@NotNull String path) {
        return path.equals(this.root) || this.root.startsWith(path + "/") || "/".equals(path);
    }

    @Override
    public void dump(@NotNull DumpContext ctx, boolean isLast) {
        ctx.printf(false, "root: %s, mode %s", new Object[]{this.getRoot(), this.getImportMode()});
        if (this.entries != null) {
            Iterator<Entry<E>> iter = this.entries.iterator();
            while (iter.hasNext()) {
                Entry<E> e = iter.next();
                e.dump(ctx, !iter.hasNext());
            }
        }
    }

    public int hashCode() {
        int result = this.root.hashCode();
        result = 31 * result + (this.entries != null ? this.entries.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilterSet)) {
            return false;
        }
        FilterSet filterSet = (FilterSet)o;
        if (this.entries != null ? !this.entries.equals(filterSet.entries) : filterSet.entries != null) {
            return false;
        }
        return this.root.equals(filterSet.root);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        this.dump(new DumpContext(new PrintWriter(stringWriter)), true);
        return stringWriter.toString();
    }

    public static class Entry<E extends Filter>
    implements Dumpable {
        @NotNull
        protected final E filter;
        protected final boolean include;

        public Entry(@NotNull E filter, boolean include) {
            this.filter = filter;
            this.include = include;
        }

        @NotNull
        public E getFilter() {
            return this.filter;
        }

        public boolean isInclude() {
            return this.include;
        }

        @Override
        public void dump(@NotNull DumpContext ctx, boolean isLast) {
            if (this.include) {
                ctx.println(isLast, "include");
            } else {
                ctx.println(isLast, "exclude");
            }
            ctx.indent(isLast);
            this.filter.dump(ctx, true);
            ctx.outdent();
        }

        public int hashCode() {
            int result = this.filter.hashCode();
            result = 31 * result + (this.include ? 1 : 0);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)o;
            return this.include == entry.include && this.filter.equals(entry.filter);
        }

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            this.dump(new DumpContext(new PrintWriter(stringWriter)), true);
            return stringWriter.toString();
        }
    }
}

