/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.starter.testservices.repository;

import javax.jcr.Session;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.api.SlingRepositoryInitializer;
import org.apache.sling.starter.testservices.repository.FirstRepositoryInitializer;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SlingRepositoryInitializer.class}, property={"service.ranking:Integer=200"})
public class SecondRepositoryInitializer
implements SlingRepositoryInitializer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String SIGNAL_PROPERTY_NAME = SecondRepositoryInitializer.class.getSimpleName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRepository(SlingRepository repo) throws Exception {
        Session s = repo.loginAdministrative(null);
        try {
            String path = FirstRepositoryInitializer.SIGNAL_NODE_PATH;
            if (!s.itemExists(path)) {
                this.log.warn("{} not found, should have been created by another initializer", (Object)path);
            } else {
                s.getNode(path).setProperty(SIGNAL_PROPERTY_NAME, System.currentTimeMillis());
                this.log.info("Property {} added to {}", (Object)SIGNAL_PROPERTY_NAME, (Object)path);
                s.save();
            }
        }
        finally {
            s.logout();
        }
    }
}

