/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tree.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class OrderedChildnameIterator
implements Iterator<String> {
    final Iterator<String> orderedChildren;
    final Iterator<String> allChildren;
    private String nextResult;
    private final List<String> nonOrderedChildren = new ArrayList<String>();
    private Iterator<String> nonOrderedChildrenIterator = null;

    public OrderedChildnameIterator(Iterable<String> orderedChildren, Iterable<String> allChildren) {
        this.orderedChildren = orderedChildren == null ? Collections.emptyIterator() : orderedChildren.iterator();
        this.allChildren = allChildren.iterator();
        this.nextResult = this.getNextElement();
    }

    private String getNextElement() {
        String elem;
        if (this.orderedChildren.hasNext() && (elem = this.getNextOrderedChild()) != null) {
            return elem;
        }
        if (this.nonOrderedChildrenIterator == null) {
            this.nonOrderedChildrenIterator = this.nonOrderedChildren.iterator();
        }
        if (this.nonOrderedChildrenIterator.hasNext()) {
            return this.nonOrderedChildrenIterator.next();
        }
        if (this.allChildren.hasNext()) {
            return this.allChildren.next();
        }
        return null;
    }

    private String getNextOrderedChild() {
        while (this.orderedChildren.hasNext()) {
            String current = this.orderedChildren.next();
            if (!this.isOrderedChildPresent(current)) continue;
            return current;
        }
        return null;
    }

    private boolean isOrderedChildPresent(String orderedChildName) {
        while (!this.nonOrderedChildren.contains(orderedChildName) && this.allChildren.hasNext()) {
            this.nonOrderedChildren.add(this.allChildren.next());
        }
        if (this.nonOrderedChildren.contains(orderedChildName)) {
            this.nonOrderedChildren.remove(orderedChildName);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasNext() {
        return this.nextResult != null;
    }

    @Override
    public String next() {
        String n = this.nextResult;
        this.nextResult = this.getNextElement();
        return n;
    }
}

