/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class MockResourceBundle
extends ResourceBundle {
    private final String baseName;
    private final Locale locale;
    private final Map<String, String> mappings = new HashMap<String, String>();

    public MockResourceBundle(String baseName, Locale locale) {
        this.baseName = baseName;
        this.locale = locale;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    protected Object handleGetObject(String key) {
        return this.mappings.getOrDefault(key, key);
    }

    @Override
    public Set<String> keySet() {
        return this.mappings.keySet();
    }

    @Override
    public Enumeration<String> getKeys() {
        return Collections.enumeration(this.mappings.keySet());
    }

    public String getBaseName() {
        return this.baseName;
    }

    public void put(@NotNull String key, @NotNull String value) {
        this.mappings.put(key, value);
    }

    public void putAll(@NotNull Map<? extends String, ? extends String> map) {
        this.mappings.putAll(map);
    }
}

