/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.component;

import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentManager;
import net.sf.jasperreports.engine.component.ComponentsBundle;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ComponentsEnvironment {
    private static final Log log = LogFactory.getLog(ComponentsEnvironment.class);
    public static final String EXCEPTION_MESSAGE_KEY_COMPONENT_MANAGER_NOT_FOUND = "components.component.manager.not.found";
    private final ReferenceMap<Object, List<ComponentsBundle>> cache = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.HARD);
    private JasperReportsContext jasperReportsContext;

    private ComponentsEnvironment(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public static ComponentsEnvironment getInstance(JasperReportsContext jasperReportsContext) {
        return new ComponentsEnvironment(jasperReportsContext);
    }

    public Collection<ComponentsBundle> getBundles() {
        List<ComponentsBundle> bundles = this.getCachedBundles();
        return bundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ComponentsBundle> getCachedBundles() {
        Object cacheKey = ExtensionsEnvironment.getExtensionsCacheKey();
        ReferenceMap<Object, List<ComponentsBundle>> referenceMap = this.cache;
        synchronized (referenceMap) {
            List<ComponentsBundle> components = (List<ComponentsBundle>)this.cache.get(cacheKey);
            if (components == null) {
                components = this.findBundles();
                this.cache.put(cacheKey, components);
            }
            return components;
        }
    }

    protected List<ComponentsBundle> findBundles() {
        return this.jasperReportsContext.getExtensions(ComponentsBundle.class);
    }

    public ComponentManager getManager(Component component) {
        return this.getManager(component.getClass());
    }

    public ComponentManager getManager(Class<? extends Component> componentType) {
        List<ComponentsBundle> bundles = this.getCachedBundles();
        List managers = bundles.stream().map(bundle -> bundle.getComponentManager(componentType)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (managers.isEmpty()) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_COMPONENT_MANAGER_NOT_FOUND, componentType.getName());
        }
        if (managers.size() > 1) {
            log.warn((Object)("Found " + managers.size() + " components for " + componentType.getName()));
        }
        return (ComponentManager)managers.get(0);
    }

    public String getComponentName(Class<? extends Component> componentType) {
        for (Class<? extends Component> type = componentType; type != null; type = type.getSuperclass()) {
            JsonTypeName componentSpec = type.getAnnotation(JsonTypeName.class);
            if (componentSpec == null) continue;
            return componentSpec.value();
        }
        for (Class<?> itf : componentType.getInterfaces()) {
            JsonTypeName componentSpec = itf.getAnnotation(JsonTypeName.class);
            if (componentSpec == null) continue;
            return componentSpec.value();
        }
        throw new JRRuntimeException("Cannot detect name of component of type " + componentType.getName());
    }

    public List<String> getComponentNames() {
        return this.getCachedBundles().stream().flatMap(bundle -> bundle.getComponentTypes().stream()).map(this::getComponentName).collect(Collectors.toList());
    }
}

