/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.variable;

import java.util.HashMap;
import java.util.Map;
import org.flowable.common.engine.api.variable.VariableContainer;

public class MapDelegateVariableContainer
implements VariableContainer {
    protected final Map<String, Object> transientVariables;
    protected final VariableContainer delegate;

    public MapDelegateVariableContainer(Map<String, Object> transientVariables, VariableContainer delegate) {
        this.transientVariables = transientVariables;
        this.delegate = delegate;
    }

    public MapDelegateVariableContainer(VariableContainer delegate) {
        this(new HashMap<String, Object>(), delegate);
    }

    public MapDelegateVariableContainer() {
        this(new HashMap<String, Object>(), VariableContainer.empty());
    }

    public boolean hasVariable(String key) {
        return this.transientVariables.containsKey(key) || this.delegate.hasVariable(key);
    }

    public Object getVariable(String key) {
        if (this.transientVariables.containsKey(key)) {
            return this.transientVariables.get(key);
        }
        return this.delegate.getVariable(key);
    }

    public void setVariable(String key, Object value) {
        if (this.delegate != VariableContainer.empty()) {
            this.delegate.setVariable(key, value);
        } else {
            this.setTransientVariable(key, value);
        }
    }

    public void setTransientVariable(String key, Object value) {
        this.transientVariables.put(key, value);
    }

    public MapDelegateVariableContainer addTransientVariable(String key, Object variable) {
        this.setTransientVariable(key, variable);
        return this;
    }

    public void clearTransientVariables() {
        this.transientVariables.clear();
    }

    public Map<String, Object> getTransientVariables() {
        return this.transientVariables;
    }

    public MapDelegateVariableContainer removeTransientVariable(String key) {
        this.transientVariables.remove(key);
        return this;
    }

    public String getTenantId() {
        return this.delegate.getTenantId();
    }
}

