/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.rest.OIDCJWKSRestClient;
import org.apache.syncope.client.console.rest.WAConfigRestClient;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAjaxEventBehavior;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxNumberFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.OIDCJWKSTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.model.Model;

public class OIDCJWKSGenerationPanel
extends AbstractModalPanel<OIDCJWKSTO> {
    private static final long serialVersionUID = -3372006007594607067L;
    protected final OIDCJWKSRestClient oidcJWKSRestClient;
    protected final Model<String> jwksKeyIdM;
    protected final Model<String> jwksTypeM;
    protected final Model<Integer> jwksKeySizeM;

    public OIDCJWKSGenerationPanel(OIDCJWKSRestClient oidcJWKSRestClient, WAConfigRestClient waConfigRestClient, BaseModal<OIDCJWKSTO> modal, PageReference pageRef) {
        super(modal, pageRef);
        this.oidcJWKSRestClient = oidcJWKSRestClient;
        this.jwksKeyIdM = Model.of((Serializable)((Object)"syncope"));
        try {
            this.jwksKeyIdM.setObject((Serializable)((Object)((String)waConfigRestClient.get("cas.authn.oidc.jwks.core.jwks-key-id").getValues().get(0))));
        }
        catch (SyncopeClientException e) {
            LOG.error("While reading cas.authn.oidc.jwks.core.jwks-key-id", (Throwable)e);
        }
        this.add(new Component[]{new AjaxTextFieldPanel("jwksKeyId", "jwksKeyId", this.jwksKeyIdM).setRequired(true)});
        this.jwksTypeM = Model.of((Serializable)((Object)"rsa"));
        try {
            this.jwksTypeM.setObject((Serializable)((Object)((String)waConfigRestClient.get("cas.authn.oidc.jwks.core.jwks-type").getValues().get(0))));
        }
        catch (SyncopeClientException e) {
            LOG.error("While reading cas.authn.oidc.jwks.core.jwks-type", (Throwable)e);
        }
        AjaxDropDownChoicePanel jwksType = new AjaxDropDownChoicePanel("jwksType", "jwksType", this.jwksTypeM).setChoices(List.of("rsa", "ec"));
        this.add(new Component[]{jwksType.setRequired(true)});
        this.jwksKeySizeM = Model.of((Serializable)Integer.valueOf(2048));
        try {
            this.jwksKeySizeM.setObject((Serializable)Integer.valueOf((String)waConfigRestClient.get("cas.authn.oidc.jwks.core.jwks-key-size").getValues().get(0)));
        }
        catch (SyncopeClientException e) {
            LOG.error("While reading cas.authn.oidc.jwks.core.jwks-key-size", (Throwable)e);
        }
        final AjaxNumberFieldPanel jwksKeySize = new AjaxNumberFieldPanel.Builder().step((Number)128).build("jwksKeySize", "jwksKeySize", Integer.class, this.jwksKeySizeM);
        this.add(new Component[]{jwksKeySize.setRequired(true)});
        jwksType.add(new Behavior[]{new IndicatorAjaxEventBehavior("change"){
            private static final long serialVersionUID = -4255753643957306394L;

            protected void onEvent(AjaxRequestTarget target) {
                if ("ec".equals(OIDCJWKSGenerationPanel.this.jwksTypeM.getObject())) {
                    OIDCJWKSGenerationPanel.this.jwksKeySizeM.setObject((Serializable)Integer.valueOf(256));
                } else {
                    OIDCJWKSGenerationPanel.this.jwksKeySizeM.setObject((Serializable)Integer.valueOf(2048));
                }
                target.add(new Component[]{jwksKeySize});
            }
        }});
    }

    public void onSubmit(AjaxRequestTarget target) {
        try {
            this.oidcJWKSRestClient.generate((String)((Object)this.jwksKeyIdM.getObject()), (String)((Object)this.jwksTypeM.getObject()), (Integer)this.jwksKeySizeM.getObject());
            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
            this.modal.close((IPartialPageRequestHandler)target);
        }
        catch (Exception e) {
            LOG.error("While generating OIDC JWKS", (Throwable)e);
            SyncopeConsoleSession.get().onException(e);
        }
        ((BaseWebPage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
    }
}

