/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.attrvalue.validation;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.syncope.core.persistence.api.attrvalue.validation.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.attrvalue.validation.PlainAttrValueValidator;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.jpa.attrvalue.validation.BasicValidator;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPlainAttrValidationManager
implements PlainAttrValidationManager {
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultPlainAttrValidationManager.class);
    protected static final PlainAttrValueValidator BASIC_VALIDATOR = new BasicValidator();
    protected final Map<String, PlainAttrValueValidator> perContextValidators = new ConcurrentHashMap<String, PlainAttrValueValidator>();

    public void validate(PlainSchema schema, String value, PlainAttrValue attrValue) {
        PlainAttrValueValidator validator = null;
        if (schema.getValidator() != null) {
            try {
                validator = (PlainAttrValueValidator)ImplementationManager.build((Implementation)schema.getValidator(), () -> this.perContextValidators.get(schema.getValidator().getKey()), instance -> this.perContextValidators.put(schema.getValidator().getKey(), (PlainAttrValueValidator)instance));
            }
            catch (Exception e) {
                LOG.error("While building {}", (Object)schema.getValidator(), (Object)e);
            }
        }
        if (validator == null) {
            validator = BASIC_VALIDATOR;
        }
        validator.validate(schema, value, attrValue);
    }
}

