/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.content;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.sql.DataSource;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.syncope.core.persistence.api.content.ContentLoader;
import org.apache.syncope.core.persistence.jpa.content.ContentLoaderHandler;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLContentLoader
implements ContentLoader {
    protected static final Logger LOG = LoggerFactory.getLogger(XMLContentLoader.class);
    protected final Resource viewsXML;
    protected final Resource indexesXML;
    protected final Environment env;

    public XMLContentLoader(Resource viewsXML, Resource indexesXML, Environment env) {
        this.viewsXML = viewsXML;
        this.indexesXML = indexesXML;
        this.env = env;
    }

    public int getOrder() {
        return 400;
    }

    public void load(String domain, DataSource datasource) {
        boolean existingData;
        LOG.debug("Loading data for domain [{}]", (Object)domain);
        EntityManagerFactoryUtils.findEntityManagerFactory((ListableBeanFactory)ApplicationContextProvider.getBeanFactory(), (String)domain).createEntityManager();
        JdbcTemplate jdbcTemplate = new JdbcTemplate(datasource);
        try {
            existingData = (Integer)jdbcTemplate.queryForObject("SELECT COUNT(0) FROM Realm", Integer.class) > 0;
        }
        catch (DataAccessException e) {
            LOG.error("[{}] Could not access table Realm", (Object)domain, (Object)e);
            existingData = true;
        }
        if (existingData) {
            LOG.info("[{}] Data found in the database, leaving untouched", (Object)domain);
        } else {
            LOG.info("[{}] Empty database found, loading default content", (Object)domain);
            try {
                this.createViews(domain, datasource);
            }
            catch (IOException e) {
                LOG.error("[{}] While creating views", (Object)domain, (Object)e);
            }
            try {
                this.createIndexes(domain, datasource);
            }
            catch (IOException e) {
                LOG.error("[{}] While creating indexes", (Object)domain, (Object)e);
            }
            try {
                InputStream contentXML = (InputStream)ApplicationContextProvider.getBeanFactory().getBean(domain + "ContentXML", InputStream.class);
                this.loadDefaultContent(domain, contentXML, datasource);
            }
            catch (Exception e) {
                LOG.error("[{}] While loading default content", (Object)domain, (Object)e);
            }
        }
    }

    protected void loadDefaultContent(String domain, InputStream contentXML, DataSource dataSource) throws IOException, ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        try (InputStream inputStream = contentXML;){
            SAXParser parser = factory.newSAXParser();
            parser.parse(contentXML, (DefaultHandler)new ContentLoaderHandler(dataSource, "dataset", true, this.env));
            LOG.debug("[{}] Default content successfully loaded", (Object)domain);
        }
    }

    protected void createViews(String domain, DataSource dataSource) throws IOException {
        LOG.debug("[{}] Creating views", (Object)domain);
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        Properties views = PropertiesLoaderUtils.loadProperties((Resource)this.viewsXML);
        views.stringPropertyNames().stream().sorted().forEach(idx -> {
            LOG.debug("[{}] Creating view {}", (Object)domain, (Object)views.get(idx).toString());
            try {
                jdbcTemplate.execute(views.getProperty((String)idx).replaceAll("\\n", " "));
            }
            catch (DataAccessException e) {
                LOG.error("[{}] Could not create view", (Object)domain, (Object)e);
            }
        });
        LOG.debug("Views created");
    }

    protected void createIndexes(String domain, DataSource dataSource) throws IOException {
        LOG.debug("[{}] Creating indexes", (Object)domain);
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        Properties indexes = PropertiesLoaderUtils.loadProperties((Resource)this.indexesXML);
        indexes.stringPropertyNames().stream().sorted().forEach(idx -> {
            LOG.debug("[{}] Creating index {}", (Object)domain, (Object)indexes.get(idx).toString());
            try {
                jdbcTemplate.execute(indexes.getProperty((String)idx));
            }
            catch (DataAccessException e) {
                LOG.error("[{}] Could not create index", (Object)domain, (Object)e);
            }
        });
        LOG.debug("Indexes created");
    }
}

