/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model;

import java.util.LinkedList;
import org.springframework.util.ObjectUtils;
import org.springframework.webflow.engine.model.AbstractActionModel;
import org.springframework.webflow.engine.model.AbstractStateModel;
import org.springframework.webflow.engine.model.IfModel;
import org.springframework.webflow.engine.model.Model;
import org.springframework.webflow.engine.model.SecuredModel;

public class DecisionStateModel
extends AbstractStateModel {
    private LinkedList<IfModel> ifs;
    private LinkedList<AbstractActionModel> onExitActions;

    public DecisionStateModel(String id) {
        super(id);
    }

    @Override
    public boolean isMergeableWith(Model model) {
        if (!(model instanceof DecisionStateModel)) {
            return false;
        }
        DecisionStateModel state = (DecisionStateModel)model;
        return ObjectUtils.nullSafeEquals((Object)this.getId(), (Object)state.getId());
    }

    @Override
    public void merge(Model model) {
        DecisionStateModel state = (DecisionStateModel)model;
        this.setParent(null);
        this.setAttributes(this.merge(this.getAttributes(), state.getAttributes()));
        this.setSecured((SecuredModel)this.merge(this.getSecured(), state.getSecured()));
        this.setOnEntryActions(this.merge(this.getOnEntryActions(), state.getOnEntryActions(), false));
        this.setExceptionHandlers(this.merge(this.getExceptionHandlers(), state.getExceptionHandlers()));
        this.setIfs(this.merge(this.getIfs(), state.getIfs()));
        this.setOnExitActions(this.merge(this.getOnExitActions(), state.getOnExitActions(), false));
    }

    @Override
    public Model createCopy() {
        DecisionStateModel copy = new DecisionStateModel(this.getId());
        super.fillCopy(copy);
        copy.setIfs(this.copyList(this.ifs));
        copy.setOnExitActions(this.copyList(this.onExitActions));
        return copy;
    }

    public LinkedList<IfModel> getIfs() {
        return this.ifs;
    }

    public void setIfs(LinkedList<IfModel> ifs) {
        this.ifs = ifs;
    }

    public LinkedList<AbstractActionModel> getOnExitActions() {
        return this.onExitActions;
    }

    public void setOnExitActions(LinkedList<AbstractActionModel> onExitActions) {
        this.onExitActions = onExitActions;
    }
}

