/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.support;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.webflow.conversation.Conversation;
import org.springframework.webflow.conversation.ConversationException;
import org.springframework.webflow.conversation.ConversationId;
import org.springframework.webflow.conversation.ConversationManager;
import org.springframework.webflow.conversation.ConversationParameters;
import org.springframework.webflow.conversation.NoSuchConversationException;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.FlowExecutionKeyFactory;
import org.springframework.webflow.execution.repository.BadlyFormattedFlowExecutionKeyException;
import org.springframework.webflow.execution.repository.FlowExecutionLock;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.repository.FlowExecutionRepositoryException;
import org.springframework.webflow.execution.repository.NoSuchFlowExecutionException;
import org.springframework.webflow.execution.repository.support.CompositeFlowExecutionKey;
import org.springframework.webflow.execution.repository.support.ConversationBackedFlowExecutionLock;

public abstract class AbstractFlowExecutionRepository
implements FlowExecutionRepository,
FlowExecutionKeyFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ConversationManager conversationManager;
    private boolean alwaysGenerateNewNextKey = true;

    protected AbstractFlowExecutionRepository(ConversationManager conversationManager) {
        Assert.notNull((Object)conversationManager, (String)"The conversation manager is required");
        this.conversationManager = conversationManager;
    }

    public ConversationManager getConversationManager() {
        return this.conversationManager;
    }

    public boolean getAlwaysGenerateNewNextKey() {
        return this.alwaysGenerateNewNextKey;
    }

    public void setAlwaysGenerateNewNextKey(boolean alwaysGenerateNewNextKey) {
        this.alwaysGenerateNewNextKey = alwaysGenerateNewNextKey;
    }

    @Override
    public FlowExecutionKey getKey(FlowExecution execution) {
        CompositeFlowExecutionKey key = (CompositeFlowExecutionKey)execution.getKey();
        if (key == null) {
            Conversation conversation = this.beginConversation(execution);
            ConversationId executionId = conversation.getId();
            return new CompositeFlowExecutionKey(executionId, this.nextSnapshotId(executionId));
        }
        if (this.alwaysGenerateNewNextKey) {
            return new CompositeFlowExecutionKey(key.getExecutionId(), this.nextSnapshotId(key.getExecutionId()));
        }
        return execution.getKey();
    }

    @Override
    public FlowExecutionKey parseFlowExecutionKey(String encodedKey) throws FlowExecutionRepositoryException {
        if (!StringUtils.hasText((String)encodedKey)) {
            throw new BadlyFormattedFlowExecutionKeyException(encodedKey, "The string-encoded flow execution key is required");
        }
        String[] keyParts = CompositeFlowExecutionKey.keyParts(encodedKey);
        ConversationId executionId = this.parseExecutionId(keyParts[0], encodedKey);
        Serializable snapshotId = this.parseSnapshotId(keyParts[1], encodedKey);
        return new CompositeFlowExecutionKey(executionId, snapshotId);
    }

    @Override
    public FlowExecutionLock getLock(FlowExecutionKey key) throws FlowExecutionRepositoryException {
        return new ConversationBackedFlowExecutionLock(this.getConversation(key));
    }

    @Override
    public void removeFlowExecution(FlowExecution flowExecution) throws FlowExecutionRepositoryException {
        this.assertKeySet(flowExecution);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Removing flow execution '" + flowExecution + "' from repository"));
        }
        this.endConversation(flowExecution);
    }

    protected abstract Serializable nextSnapshotId(Serializable var1);

    @Override
    public abstract FlowExecution getFlowExecution(FlowExecutionKey var1) throws FlowExecutionRepositoryException;

    @Override
    public abstract void putFlowExecution(FlowExecution var1) throws FlowExecutionRepositoryException;

    protected ConversationParameters createConversationParameters(FlowExecution flowExecution) {
        FlowDefinition flow = flowExecution.getDefinition();
        return new ConversationParameters(flow.getId(), flow.getCaption(), flow.getDescription());
    }

    protected Conversation getConversation(FlowExecutionKey key) throws NoSuchFlowExecutionException {
        try {
            return this.getConversation(((CompositeFlowExecutionKey)key).getExecutionId());
        }
        catch (NoSuchConversationException e) {
            throw new NoSuchFlowExecutionException(key, e);
        }
    }

    protected Conversation getConversation(Serializable executionId) throws NoSuchConversationException {
        return this.conversationManager.getConversation((ConversationId)executionId);
    }

    protected void assertKeySet(FlowExecution execution) throws IllegalStateException {
        if (execution.getKey() == null) {
            throw new IllegalStateException("The key for the flow execution is null; make sure the key is assigned first.  Execution Details = " + execution);
        }
    }

    private Conversation beginConversation(FlowExecution execution) {
        ConversationParameters parameters = this.createConversationParameters(execution);
        Conversation conversation = this.conversationManager.beginConversation(parameters);
        return conversation;
    }

    private ConversationId parseExecutionId(String encodedId, String encodedKey) throws BadlyFormattedFlowExecutionKeyException {
        try {
            return this.conversationManager.parseConversationId(encodedId);
        }
        catch (ConversationException e) {
            throw new BadlyFormattedFlowExecutionKeyException(encodedKey, CompositeFlowExecutionKey.getFormat(), e);
        }
    }

    private Serializable parseSnapshotId(String encodedId, String encodedKey) throws BadlyFormattedFlowExecutionKeyException {
        try {
            return Integer.valueOf(encodedId);
        }
        catch (NumberFormatException e) {
            throw new BadlyFormattedFlowExecutionKeyException(encodedKey, CompositeFlowExecutionKey.getFormat(), e);
        }
    }

    private Conversation endConversation(FlowExecution flowExecution) {
        Conversation conversation = this.getConversation(flowExecution.getKey());
        conversation.end();
        return conversation;
    }
}

