/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.form.spinner;

import com.googlecode.wicket.jquery.core.IJQueryCultureWidget;
import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.ui.JQueryUIBehavior;
import com.googlecode.wicket.jquery.ui.form.spinner.SpinnerAdapter;
import com.googlecode.wicket.jquery.ui.form.spinner.SpinnerBehavior;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;

public class Spinner<T extends Number>
extends TextField<T>
implements IJQueryCultureWidget {
    private static final long serialVersionUID = 1L;
    protected final Options options;

    public Spinner(String id) {
        this(id, new Options());
    }

    public Spinner(String id, Options options) {
        this(id, options, null);
    }

    public Spinner(String id, Class<T> type) {
        this(id, new Options(), type);
    }

    public Spinner(String id, Options options, Class<T> type) {
        super(id, type);
        this.options = (Options)Args.notNull((Object)options, (String)"options");
    }

    public Spinner(String id, IModel<T> model) {
        this(id, model, new Options(), null);
    }

    public Spinner(String id, IModel<T> model, Options options) {
        this(id, model, options, null);
    }

    public Spinner(String id, IModel<T> model, Class<T> type) {
        this(id, model, new Options(), type);
    }

    public Spinner(String id, IModel<T> model, Options options, Class<T> type) {
        super(id, model, type);
        this.options = (Options)Args.notNull((Object)options, (String)"options");
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior((Component)this)});
    }

    protected void onConfigure() {
        super.onConfigure();
        this.setDisabled(!this.isEnabledInHierarchy());
    }

    public void onConfigure(JQueryBehavior behavior) {
    }

    public void onBeforeRender(JQueryBehavior behavior) {
    }

    public Spinner<T> setCulture(String culture) {
        this.options.set("culture", (Object)Options.asString((String)culture));
        return this;
    }

    public String getCulture() {
        return (String)this.options.get("culture");
    }

    private Spinner<T> setDisabled(boolean disabled) {
        this.options.set("disabled", (Object)disabled);
        return this;
    }

    public Spinner<T> setMin(Number min) {
        this.options.set("min", (Object)min);
        return this;
    }

    public Spinner<T> setMin(String min) {
        this.options.set("min", (Object)Options.asString((String)min));
        return this;
    }

    public Spinner<T> setMax(Number max) {
        this.options.set("max", (Object)max);
        return this;
    }

    public Spinner<T> setMax(String max) {
        this.options.set("max", (Object)Options.asString((String)max));
        return this;
    }

    public Spinner<T> setPage(Number steps) {
        this.options.set("page", (Object)steps);
        return this;
    }

    public Spinner<T> setStep(Number size) {
        this.options.set("step", (Object)size);
        return this;
    }

    public JQueryUIBehavior newWidgetBehavior(String selector) {
        return new SpinnerBehavior(selector, new SpinnerAdapter(), this.options);
    }
}

