/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.navigation.paging;

import org.apache.wicket.Page;
import org.apache.wicket.markup.html.link.DisabledAttributeLinkBehavior;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.navigation.paging.IPageable;

public class PagingNavigationIncrementLink<T>
extends Link<T> {
    private static final long serialVersionUID = 1L;
    private final int increment;
    protected final IPageable pageable;

    public PagingNavigationIncrementLink(String id, IPageable pageable, int increment) {
        super(id);
        this.setAutoEnable(true);
        this.increment = increment;
        this.pageable = pageable;
        this.add(new DisabledAttributeLinkBehavior());
    }

    @Override
    public void onClick() {
        this.pageable.setCurrentPage(this.getPageNumber());
        this.setResponsePage(this.getPage());
    }

    public final long getPageNumber() {
        long idx = this.pageable.getCurrentPage() + (long)this.increment;
        return Math.max(0L, Math.min(this.pageable.getPageCount() - 1L, idx));
    }

    public boolean isFirst() {
        return this.pageable.getCurrentPage() <= 0L;
    }

    public boolean isLast() {
        return this.pageable.getCurrentPage() >= this.pageable.getPageCount() - 1L;
    }

    @Override
    public boolean linksTo(Page page) {
        this.pageable.getCurrentPage();
        return this.increment < 0 && this.isFirst() || this.increment > 0 && this.isLast();
    }
}

