/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.commons;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.common.rest.api.beans.RealmQuery;

public final class RealmsUtils {
    public static String getFullPath(String fullpath) {
        String display = fullpath;
        if (display.indexOf(64) != -1) {
            display = StringUtils.substringBefore((String)display, (String)"@");
        }
        return display;
    }

    public static boolean checkInput(String input) {
        return StringUtils.isNotBlank((CharSequence)input) && !"*".equals(input);
    }

    public static RealmQuery buildKeywordQuery(String input) {
        return (RealmQuery)new RealmQuery.Builder().keyword((String)(input.contains("*") ? input : "*" + input + "*")).build();
    }

    public static RealmQuery buildBaseQuery() {
        List<String> realms = SyncopeConsoleSession.get().getSearchableRealms();
        if (realms.isEmpty() || realms.contains("/")) {
            return (RealmQuery)new RealmQuery.Builder().base(new String[]{"/"}).build();
        }
        return (RealmQuery)new RealmQuery.Builder().bases((Collection)realms.stream().map(RealmsUtils::getFullPath).collect(Collectors.toList())).build();
    }

    private RealmsUtils() {
    }
}

