/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.validation;

import javax.persistence.ValidationMode;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.persistence.validation.ValidatorImpl;
import org.apache.openjpa.validation.ValidationUnavailableException;

public class ValidationUtils {
    private static final Localizer _loc = Localizer.forPackage(ValidationUtils.class);

    public static boolean setupValidation(OpenJPAConfiguration conf) {
        Log log = conf.getConfigurationLog();
        boolean brc = false;
        if (conf.getSpecificationInstance().getVersion() < 2) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Not creating a ValidatorImpl because this app is using the JPA 1.0 Spec");
            }
        } else {
            if (!String.valueOf(ValidationMode.NONE).equalsIgnoreCase(conf.getValidationMode())) {
                boolean bValRequired = String.valueOf(ValidationMode.CALLBACK).equalsIgnoreCase(conf.getValidationMode());
                try {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Trying to load javax.validation APIs based on the ValidationMode=" + conf.getValidationMode()));
                    }
                    Class<?> clazz = Class.forName("javax.validation.ValidationException");
                }
                catch (ClassNotFoundException e) {
                    if (bValRequired) {
                        Localizer.Message msg = _loc.get("vlem-creation-error");
                        log.error((Object)msg, (Throwable)e);
                        throw new ValidationUnavailableException(msg.getMessage(), new RuntimeException(e), true);
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)_loc.get("vlem-creation-warn", (Object)"No available javax.validation APIs"));
                    }
                    return brc;
                }
                try {
                    ValidatorImpl validator = new ValidatorImpl((Configuration)conf);
                    conf.setValidatorInstance((Object)validator);
                    conf.setLifecycleEventManager("validating");
                    brc = true;
                }
                catch (RuntimeException e) {
                    if (bValRequired) {
                        Localizer.Message msg = _loc.get("vlem-creation-error");
                        log.error((Object)msg, (Throwable)e);
                        throw new ValidationUnavailableException(msg.getMessage(), e, true);
                    }
                    String msg = e.getMessage();
                    log.warn((Object)_loc.get("vlem-creation-warn", msg == null ? e : msg));
                    return brc;
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Not creating a ValidatorImpl because ValidationMode=" + conf.getValidationMode()));
            }
        }
        return brc;
    }

    public static boolean isConstraintViolationException(Exception e) {
        if (e == null) {
            return false;
        }
        return e.getClass().getName().equals("javax.validation.ConstraintViolationException");
    }
}

