/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.pages;

import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.pages.BasePage;
import org.apache.syncope.client.enduser.pages.ReauthLogin;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.request.mapper.parameter.PageParameters;

abstract class BaseReauthPage
extends BasePage {
    private static final long serialVersionUID = 417902520012512819L;

    protected BaseReauthPage(PageParameters parameters, String name) {
        super(parameters, name);
        if (this.isReauthExpired()) {
            LOG.debug("Re-authentication needed to proceed");
            PageParameters notification = new PageParameters();
            notification.add("notificationMessage", (Object)this.getString("reauth.message"));
            notification.add("notificationLevel", (Object)"warning");
            throw new RestartResponseAtInterceptPageException(ReauthLogin.class, notification);
        }
        SyncopeEnduserSession.get().clearLastReauth();
        LOG.debug("Re-authentication cleared");
    }

    protected boolean isReauthExpired() {
        return SyncopeEnduserSession.get().isReauthExpired();
    }
}

