/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.spring.jms;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.util.Map;
import javax.jms.MessageListener;
import org.flowable.eventregistry.api.ChannelModelProcessor;
import org.flowable.eventregistry.api.EventRegistry;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.api.OutboundEventChannelAdapter;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.model.InboundChannelModel;
import org.flowable.eventregistry.model.JmsInboundChannelModel;
import org.flowable.eventregistry.model.JmsOutboundChannelModel;
import org.flowable.eventregistry.spring.jms.JmsChannelMessageListenerAdapter;
import org.flowable.eventregistry.spring.jms.JmsOperationsOutboundEventChannelAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.EmbeddedValueResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerEndpoint;
import org.springframework.jms.config.JmsListenerEndpointRegistry;
import org.springframework.jms.config.SimpleJmsListenerEndpoint;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.listener.MessageListenerContainer;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public class JmsChannelModelProcessor
implements BeanFactoryAware,
ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent>,
ChannelModelProcessor {
    public static final String CHANNEL_ID_PREFIX = "org.flowable.eventregistry.jms.ChannelJmsListenerEndpointContainer#";
    static final String DEFAULT_JMS_LISTENER_CONTAINER_FACTORY_BEAN_NAME = "jmsListenerContainerFactory";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected JmsOperations jmsOperations;
    protected JmsListenerEndpointRegistry endpointRegistry;
    protected String containerFactoryBeanName = "jmsListenerContainerFactory";
    protected JmsListenerContainerFactory<?> containerFactory;
    protected BeanFactory beanFactory;
    protected ApplicationContext applicationContext;
    protected boolean contextRefreshed;
    protected ObjectMapper objectMapper;
    protected StringValueResolver embeddedValueResolver;

    public JmsChannelModelProcessor(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean canProcess(ChannelModel channelModel) {
        return channelModel instanceof JmsInboundChannelModel || channelModel instanceof JmsOutboundChannelModel;
    }

    public boolean canProcessIfChannelModelAlreadyRegistered(ChannelModel channelModel) {
        return channelModel instanceof JmsOutboundChannelModel;
    }

    public void registerChannelModel(ChannelModel channelModel, String tenantId, EventRegistry eventRegistry, EventRepositoryService eventRepositoryService, boolean fallbackToDefaultTenant) {
        if (channelModel instanceof JmsInboundChannelModel) {
            JmsInboundChannelModel jmsChannelModel = (JmsInboundChannelModel)channelModel;
            this.logger.info("Starting to register inbound channel {} in tenant {}", (Object)channelModel.getKey(), (Object)tenantId);
            JmsListenerEndpoint endpoint = this.createJmsListenerEndpoint(jmsChannelModel, tenantId, eventRegistry);
            this.registerEndpoint(endpoint, null);
            this.logger.info("Finished registering inbound channel {} in tenant {}", (Object)channelModel.getKey(), (Object)tenantId);
        } else if (channelModel instanceof JmsOutboundChannelModel) {
            this.logger.info("Starting to register outbound channel {} in tenant {}", (Object)channelModel.getKey(), (Object)tenantId);
            this.processOutboundDefinition((JmsOutboundChannelModel)channelModel);
            this.logger.info("Finished registering outbound channel {} in tenant {}", (Object)channelModel.getKey(), (Object)tenantId);
        }
    }

    protected JmsListenerEndpoint createJmsListenerEndpoint(JmsInboundChannelModel jmsChannelModel, String tenantId, EventRegistry eventRegistry) {
        String concurrency;
        String subscription;
        String endpointId = this.getEndpointId((ChannelModel)jmsChannelModel, tenantId);
        SimpleJmsListenerEndpoint endpoint = new SimpleJmsListenerEndpoint();
        endpoint.setId(endpointId);
        endpoint.setDestination(this.resolve(jmsChannelModel.getDestination()));
        String selector = jmsChannelModel.getSelector();
        if (StringUtils.hasText((String)selector)) {
            endpoint.setSelector(this.resolve(selector));
        }
        if (StringUtils.hasText((String)(subscription = jmsChannelModel.getSubscription()))) {
            endpoint.setSubscription(this.resolve(subscription));
        }
        if (StringUtils.hasText((String)(concurrency = jmsChannelModel.getConcurrency()))) {
            endpoint.setConcurrency(this.resolve(concurrency));
        }
        endpoint.setMessageListener(this.createMessageListener(eventRegistry, (InboundChannelModel)jmsChannelModel));
        return endpoint;
    }

    protected MessageListener createMessageListener(EventRegistry eventRegistry, InboundChannelModel inboundChannelModel) {
        return new JmsChannelMessageListenerAdapter(eventRegistry, inboundChannelModel);
    }

    protected void processOutboundDefinition(JmsOutboundChannelModel channelModel) {
        String destination = channelModel.getDestination();
        if (channelModel.getOutboundEventChannelAdapter() == null && StringUtils.hasText((String)destination)) {
            channelModel.setOutboundEventChannelAdapter((Object)this.createOutboundEventChannelAdapter(channelModel));
        }
    }

    protected OutboundEventChannelAdapter createOutboundEventChannelAdapter(JmsOutboundChannelModel channelModel) {
        String destination = this.resolve(channelModel.getDestination());
        return new JmsOperationsOutboundEventChannelAdapter(this.jmsOperations, destination);
    }

    public void unregisterChannelModel(ChannelModel channelModel, String tenantId, EventRepositoryService eventRepositoryService) {
        Field listenerContainersField;
        this.logger.info("Starting to unregister channel {} in tenant {}", (Object)channelModel.getKey(), (Object)tenantId);
        String endpointId = this.getEndpointId(channelModel, tenantId);
        MessageListenerContainer listenerContainer = this.endpointRegistry.getListenerContainer(endpointId);
        if (listenerContainer != null) {
            this.logger.debug("Stopping message listener {} for channel {} in tenant {}", new Object[]{listenerContainer, channelModel.getKey(), tenantId});
            listenerContainer.stop();
        }
        if (listenerContainer instanceof DisposableBean) {
            try {
                this.logger.debug("Destroying message listener {} for channel {} in tenant {}", new Object[]{listenerContainer, channelModel.getKey(), tenantId});
                ((DisposableBean)listenerContainer).destroy();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to destroy listener container", e);
            }
        }
        if ((listenerContainersField = ReflectionUtils.findField(this.endpointRegistry.getClass(), (String)"listenerContainers")) != null) {
            listenerContainersField.setAccessible(true);
            Map listenerContainers = (Map)ReflectionUtils.getField((Field)listenerContainersField, (Object)this.endpointRegistry);
            if (listenerContainers != null) {
                listenerContainers.remove(endpointId);
            }
        } else {
            throw new IllegalStateException("Endpoint registry " + this.endpointRegistry + " does not have listenerContainers field");
        }
        this.logger.info("Finished unregistering channel {} in tenant {}", (Object)channelModel.getKey(), (Object)tenantId);
    }

    protected void registerEndpoint(JmsListenerEndpoint endpoint, JmsListenerContainerFactory<?> factory) {
        Assert.notNull((Object)endpoint, (String)"Endpoint must not be null");
        Assert.hasText((String)endpoint.getId(), (String)"Endpoint id must be set");
        Assert.state((this.endpointRegistry != null ? 1 : 0) != 0, (String)"No JmsListenerEndpointRegistry set");
        boolean startImmediately = this.contextRefreshed || this.endpointRegistry.isRunning();
        this.logger.info("Registering endpoint {} with start immediately {}", (Object)endpoint, (Object)startImmediately);
        this.endpointRegistry.registerListenerContainer(endpoint, this.resolveContainerFactory(endpoint, factory), startImmediately);
        this.logger.info("Finished registering endpoint {}", (Object)endpoint);
    }

    protected JmsListenerContainerFactory<?> resolveContainerFactory(JmsListenerEndpoint endpoint, JmsListenerContainerFactory<?> containerFactory) {
        if (containerFactory != null) {
            return containerFactory;
        }
        if (this.containerFactory != null) {
            return this.containerFactory;
        }
        if (this.containerFactoryBeanName != null) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to obtain container factory by bean name");
            this.containerFactory = (JmsListenerContainerFactory)this.beanFactory.getBean(this.containerFactoryBeanName, JmsListenerContainerFactory.class);
            return this.containerFactory;
        }
        throw new IllegalStateException("Could not resolve the " + JmsListenerContainerFactory.class.getSimpleName() + " to use for [" + endpoint + "] no factory was given and no default is set.");
    }

    protected String getEndpointId(ChannelModel channelModel, String tenantId) {
        String channelDefinitionKey = channelModel.getKey();
        if (!StringUtils.hasText((String)tenantId)) {
            return CHANNEL_ID_PREFIX + channelDefinitionKey;
        }
        return CHANNEL_ID_PREFIX + tenantId + "#" + channelDefinitionKey;
    }

    protected String resolve(String value) {
        if (this.embeddedValueResolver != null) {
            return this.embeddedValueResolver.resolveStringValue(value);
        }
        return value;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableBeanFactory) {
            this.embeddedValueResolver = new EmbeddedValueResolver((ConfigurableBeanFactory)beanFactory);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext() == this.applicationContext) {
            this.contextRefreshed = true;
        }
    }

    public JmsOperations getJmsOperations() {
        return this.jmsOperations;
    }

    public void setJmsOperations(JmsOperations jmsOperations) {
        this.jmsOperations = jmsOperations;
    }

    public JmsListenerEndpointRegistry getEndpointRegistry() {
        return this.endpointRegistry;
    }

    public void setEndpointRegistry(JmsListenerEndpointRegistry endpointRegistry) {
        this.endpointRegistry = endpointRegistry;
    }

    public String getContainerFactoryBeanName() {
        return this.containerFactoryBeanName;
    }

    public void setContainerFactoryBeanName(String containerFactoryBeanName) {
        this.containerFactoryBeanName = containerFactoryBeanName;
    }

    public JmsListenerContainerFactory<?> getContainerFactory() {
        return this.containerFactory;
    }

    public void setContainerFactory(JmsListenerContainerFactory<?> containerFactory) {
        this.containerFactory = containerFactory;
    }
}

