/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGenerator;
import org.apereo.cas.util.EncodingUtils;
import org.springframework.data.annotation.Id;

@MappedSuperclass
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class SamlIdPMetadataDocument
implements Serializable {
    private static final long serialVersionUID = -705737727407407083L;
    @Id
    @Column(name="id", columnDefinition="BIGINT")
    @JsonProperty
    @Transient
    private long id;
    @Column(name="appliesTo", unique=true, length=512)
    @JsonProperty
    private String appliesTo;
    @Lob
    @Column(name="metadata", length=10000)
    @JsonProperty
    private String metadata;
    @Lob
    @Column(name="signingCertificate", length=3000)
    @JsonProperty
    private String signingCertificate;
    @Lob
    @Column(name="signingKey", length=3000)
    @JsonProperty
    private String signingKey;
    @Lob
    @Column(name="encryptionCertificate", length=3000)
    @JsonProperty
    private String encryptionCertificate;
    @Lob
    @Column(name="encryptionKey", length=3000)
    @JsonProperty
    private String encryptionKey;

    public SamlIdPMetadataDocument() {
        this.setId(System.nanoTime());
    }

    @JsonIgnore
    public boolean isValid() {
        return StringUtils.isNotBlank((CharSequence)this.getMetadata()) && StringUtils.isNotBlank((CharSequence)this.getSigningCertificate()) && StringUtils.isNotBlank((CharSequence)this.getSigningKey()) && StringUtils.isNotBlank((CharSequence)this.getEncryptionCertificate()) && StringUtils.isNotBlank((CharSequence)this.getEncryptionKey());
    }

    @JsonIgnore
    public String getSigningCertificateDecoded() {
        if (EncodingUtils.isBase64((String)this.signingCertificate)) {
            String cert = SamlIdPMetadataGenerator.cleanCertificate(this.signingCertificate);
            return EncodingUtils.decodeBase64ToString((String)cert);
        }
        return this.signingCertificate;
    }

    @JsonIgnore
    public String getEncryptionCertificateDecoded() {
        if (EncodingUtils.isBase64((String)this.encryptionCertificate)) {
            String cert = SamlIdPMetadataGenerator.cleanCertificate(this.encryptionCertificate);
            return EncodingUtils.decodeBase64ToString((String)cert);
        }
        return this.encryptionCertificate;
    }

    @JsonIgnore
    public String getMetadataDecoded() {
        if (EncodingUtils.isBase64((String)this.metadata)) {
            return EncodingUtils.decodeBase64ToString((String)this.metadata);
        }
        return this.metadata;
    }

    @Generated
    private static long $default$id() {
        return -1L;
    }

    @Generated
    private static String $default$appliesTo() {
        return "CAS";
    }

    @Generated
    protected SamlIdPMetadataDocument(SamlIdPMetadataDocumentBuilder<?, ?> b) {
        this.id = b.id$set ? b.id$value : SamlIdPMetadataDocument.$default$id();
        this.appliesTo = b.appliesTo$set ? b.appliesTo$value : SamlIdPMetadataDocument.$default$appliesTo();
        this.metadata = b.metadata;
        this.signingCertificate = b.signingCertificate;
        this.signingKey = b.signingKey;
        this.encryptionCertificate = b.encryptionCertificate;
        this.encryptionKey = b.encryptionKey;
    }

    @Generated
    public static SamlIdPMetadataDocumentBuilder<?, ?> builder() {
        return new SamlIdPMetadataDocumentBuilderImpl();
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getAppliesTo() {
        return this.appliesTo;
    }

    @Generated
    public String getMetadata() {
        return this.metadata;
    }

    @Generated
    public String getSigningCertificate() {
        return this.signingCertificate;
    }

    @Generated
    public String getSigningKey() {
        return this.signingKey;
    }

    @Generated
    public String getEncryptionCertificate() {
        return this.encryptionCertificate;
    }

    @Generated
    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    @JsonProperty
    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @JsonProperty
    @Generated
    public void setAppliesTo(String appliesTo) {
        this.appliesTo = appliesTo;
    }

    @JsonProperty
    @Generated
    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    @JsonProperty
    @Generated
    public void setSigningCertificate(String signingCertificate) {
        this.signingCertificate = signingCertificate;
    }

    @JsonProperty
    @Generated
    public void setSigningKey(String signingKey) {
        this.signingKey = signingKey;
    }

    @JsonProperty
    @Generated
    public void setEncryptionCertificate(String encryptionCertificate) {
        this.encryptionCertificate = encryptionCertificate;
    }

    @JsonProperty
    @Generated
    public void setEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    @Generated
    public SamlIdPMetadataDocument(long id, String appliesTo, String metadata, String signingCertificate, String signingKey, String encryptionCertificate, String encryptionKey) {
        this.id = id;
        this.appliesTo = appliesTo;
        this.metadata = metadata;
        this.signingCertificate = signingCertificate;
        this.signingKey = signingKey;
        this.encryptionCertificate = encryptionCertificate;
        this.encryptionKey = encryptionKey;
    }

    @Generated
    private static final class SamlIdPMetadataDocumentBuilderImpl
    extends SamlIdPMetadataDocumentBuilder<SamlIdPMetadataDocument, SamlIdPMetadataDocumentBuilderImpl> {
        @Generated
        private SamlIdPMetadataDocumentBuilderImpl() {
        }

        @Override
        @Generated
        protected SamlIdPMetadataDocumentBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SamlIdPMetadataDocument build() {
            return new SamlIdPMetadataDocument(this);
        }
    }

    @Generated
    public static abstract class SamlIdPMetadataDocumentBuilder<C extends SamlIdPMetadataDocument, B extends SamlIdPMetadataDocumentBuilder<C, B>> {
        @Generated
        private boolean id$set;
        @Generated
        private long id$value;
        @Generated
        private boolean appliesTo$set;
        @Generated
        private String appliesTo$value;
        @Generated
        private String metadata;
        @Generated
        private String signingCertificate;
        @Generated
        private String signingKey;
        @Generated
        private String encryptionCertificate;
        @Generated
        private String encryptionKey;

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @JsonProperty
        @Generated
        public B id(long id) {
            this.id$value = id;
            this.id$set = true;
            return this.self();
        }

        @JsonProperty
        @Generated
        public B appliesTo(String appliesTo) {
            this.appliesTo$value = appliesTo;
            this.appliesTo$set = true;
            return this.self();
        }

        @JsonProperty
        @Generated
        public B metadata(String metadata) {
            this.metadata = metadata;
            return this.self();
        }

        @JsonProperty
        @Generated
        public B signingCertificate(String signingCertificate) {
            this.signingCertificate = signingCertificate;
            return this.self();
        }

        @JsonProperty
        @Generated
        public B signingKey(String signingKey) {
            this.signingKey = signingKey;
            return this.self();
        }

        @JsonProperty
        @Generated
        public B encryptionCertificate(String encryptionCertificate) {
            this.encryptionCertificate = encryptionCertificate;
            return this.self();
        }

        @JsonProperty
        @Generated
        public B encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this.self();
        }

        @Generated
        public String toString() {
            return "SamlIdPMetadataDocument.SamlIdPMetadataDocumentBuilder(id$value=" + this.id$value + ", appliesTo$value=" + this.appliesTo$value + ", metadata=" + this.metadata + ", signingCertificate=" + this.signingCertificate + ", signingKey=" + this.signingKey + ", encryptionCertificate=" + this.encryptionCertificate + ", encryptionKey=" + this.encryptionKey + ")";
        }
    }
}

