/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.to.AttrRepoTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.AttrRepoDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.am.AttrRepo;
import org.apache.syncope.core.provisioning.api.data.AttrRepoDataBinder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class AttrRepoLogic
extends AbstractTransactionalLogic<AttrRepoTO> {
    protected final AttrRepoDataBinder binder;
    protected final AttrRepoDAO attrRepoDAO;

    public AttrRepoLogic(AttrRepoDataBinder binder, AttrRepoDAO attrRepoDAO) {
        this.binder = binder;
        this.attrRepoDAO = attrRepoDAO;
    }

    @PreAuthorize(value="hasRole('ATTR_REPO_CREATE')")
    public AttrRepoTO create(AttrRepoTO attrRepoTO) {
        return this.binder.getAttrRepoTO(this.attrRepoDAO.save(this.binder.create(attrRepoTO)));
    }

    @PreAuthorize(value="hasRole('ATTR_REPO_UPDATE')")
    public AttrRepoTO update(AttrRepoTO attrRepoTO) {
        AttrRepo attrRepo = this.attrRepoDAO.find(attrRepoTO.getKey());
        if (attrRepo == null) {
            throw new NotFoundException("AttrRepo " + attrRepoTO.getKey() + " not found");
        }
        return this.binder.getAttrRepoTO(this.attrRepoDAO.save(this.binder.update(attrRepo, attrRepoTO)));
    }

    @PreAuthorize(value="hasRole('ATTR_REPO_LIST') or hasRole('ANONYMOUS')")
    @Transactional(readOnly=true)
    public List<AttrRepoTO> list() {
        return this.attrRepoDAO.findAll().stream().map(arg_0 -> ((AttrRepoDataBinder)this.binder).getAttrRepoTO(arg_0)).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasRole('ATTR_REPO_READ')")
    @Transactional(readOnly=true)
    public AttrRepoTO read(String key) {
        AttrRepo attrRepo = this.attrRepoDAO.find(key);
        if (attrRepo == null) {
            throw new NotFoundException("AttrRepo " + key + " not found");
        }
        return this.binder.getAttrRepoTO(attrRepo);
    }

    @PreAuthorize(value="hasRole('ATTR_REPO_DELETE')")
    public AttrRepoTO delete(String key) {
        AttrRepo attrRepo = this.attrRepoDAO.find(key);
        if (attrRepo == null) {
            throw new NotFoundException("AttrRepo " + key + " not found");
        }
        AttrRepoTO deleted = this.binder.getAttrRepoTO(attrRepo);
        this.attrRepoDAO.delete(attrRepo);
        return deleted;
    }

    protected AttrRepoTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key;
        if (ArrayUtils.isEmpty((Object[])args)) {
            throw new UnresolvedReferenceException();
        }
        if (args[0] instanceof String) {
            key = (String)args[0];
        } else if (args[0] instanceof AttrRepoTO) {
            key = ((AttrRepoTO)args[0]).getKey();
        } else {
            throw new UnresolvedReferenceException();
        }
        try {
            return this.binder.getAttrRepoTO(this.attrRepoDAO.find(key));
        }
        catch (Throwable ignore) {
            LOG.debug("Unresolved reference", ignore);
            throw new UnresolvedReferenceException(ignore);
        }
    }
}

