/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.oauth2.useragent;

import com.microsoft.alm.oauth2.useragent.AuthorizationException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.regex.Pattern;

public class AuthorizationResponse {
    static final String RESPONSE_CODE = "code";
    static final String RESPONSE_STATE = "state";
    private static final String UTF_8 = "UTF-8";
    private static final Pattern PAIR_SEPARATOR = Pattern.compile("&");
    private static final Pattern NAME_VALUE_SEPARATOR = Pattern.compile("=");
    private final String code;
    private final String state;

    public AuthorizationResponse(String code, String state) {
        this.code = code;
        this.state = state;
    }

    public String getCode() {
        return this.code;
    }

    public String getState() {
        return this.state;
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(RESPONSE_CODE).append('=').append(URLEncoder.encode(this.code, UTF_8));
            if (this.state != null) {
                sb.append('&');
                sb.append(RESPONSE_STATE).append('=').append(URLEncoder.encode(this.state, UTF_8));
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public static AuthorizationResponse fromString(String s) throws AuthorizationException {
        return AuthorizationResponse.fromString(s, null);
    }

    public static AuthorizationResponse fromString(String s, String potentialDescription) throws AuthorizationException {
        String code = null;
        String state = null;
        String error = "unknown_error";
        String errorDescription = potentialDescription;
        String errorUriString = null;
        if (s != null && s.length() > 0) {
            String[] pairs;
            String trimmed = s.trim();
            for (String pair : pairs = PAIR_SEPARATOR.split(trimmed)) {
                String[] nameAndValue = NAME_VALUE_SEPARATOR.split(pair, 2);
                try {
                    if (nameAndValue.length != 2) {
                        StringBuilder sb = new StringBuilder("Failed to parse response: ");
                        sb.append("'").append(trimmed).append("'.");
                        if (errorDescription != null) {
                            sb.append("\n").append("Additional information: ").append(errorDescription);
                        }
                        throw new AuthorizationException("parsing_error", sb.toString(), null, null);
                    }
                    String name = URLDecoder.decode(nameAndValue[0], UTF_8);
                    String value = URLDecoder.decode(nameAndValue[1], UTF_8);
                    if (RESPONSE_CODE.equals(name)) {
                        code = value;
                        continue;
                    }
                    if (RESPONSE_STATE.equals(name)) {
                        state = value;
                        continue;
                    }
                    if ("error".equals(name)) {
                        error = value;
                        continue;
                    }
                    if ("error_description".equals(name)) {
                        errorDescription = value;
                        continue;
                    }
                    if (!"error_uri".equals(name)) continue;
                    errorUriString = value;
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error(e);
                }
            }
        }
        if (code != null) {
            return new AuthorizationResponse(code, state);
        }
        URI errorUri = null;
        if (errorUriString != null) {
            try {
                errorUri = new URI(errorUriString);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        throw new AuthorizationException(error, errorDescription, errorUri, null);
    }
}

