/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.text.ParseException;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.Mapping;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.OrgUnit;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ApplicationDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.RelationshipTypeDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Application;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.GroupableRelatable;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.Account;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.AccountGetter;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.PlainAttrGetter;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCache;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCacheKey;
import org.apache.syncope.core.provisioning.api.data.ItemTransformer;
import org.apache.syncope.core.provisioning.api.jexl.JexlUtils;
import org.apache.syncope.core.provisioning.api.utils.FormatUtils;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.security.Encryptor;
import org.identityconnectors.framework.common.FrameworkUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Uid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class DefaultMappingManager
implements MappingManager {
    protected static final Logger LOG = LoggerFactory.getLogger(MappingManager.class);
    protected final AnyTypeDAO anyTypeDAO;
    protected final UserDAO userDAO;
    protected final AnyObjectDAO anyObjectDAO;
    protected final GroupDAO groupDAO;
    protected final RelationshipTypeDAO relationshipTypeDAO;
    protected final RealmDAO realmDAO;
    protected final ApplicationDAO applicationDAO;
    protected final ImplementationDAO implementationDAO;
    protected final DerAttrHandler derAttrHandler;
    protected final VirAttrHandler virAttrHandler;
    protected final VirAttrCache virAttrCache;
    protected final AnyUtilsFactory anyUtilsFactory;
    protected final IntAttrNameParser intAttrNameParser;

    public DefaultMappingManager(AnyTypeDAO anyTypeDAO, UserDAO userDAO, AnyObjectDAO anyObjectDAO, GroupDAO groupDAO, RelationshipTypeDAO relationshipTypeDAO, RealmDAO realmDAO, ApplicationDAO applicationDAO, ImplementationDAO implementationDAO, DerAttrHandler derAttrHandler, VirAttrHandler virAttrHandler, VirAttrCache virAttrCache, AnyUtilsFactory anyUtilsFactory, IntAttrNameParser intAttrNameParser) {
        this.anyTypeDAO = anyTypeDAO;
        this.userDAO = userDAO;
        this.anyObjectDAO = anyObjectDAO;
        this.groupDAO = groupDAO;
        this.relationshipTypeDAO = relationshipTypeDAO;
        this.realmDAO = realmDAO;
        this.applicationDAO = applicationDAO;
        this.implementationDAO = implementationDAO;
        this.derAttrHandler = derAttrHandler;
        this.virAttrHandler = virAttrHandler;
        this.virAttrCache = virAttrCache;
        this.anyUtilsFactory = anyUtilsFactory;
        this.intAttrNameParser = intAttrNameParser;
    }

    protected List<Implementation> getTransformers(Item item) {
        return item.getTransformers().stream().map(arg_0 -> ((ImplementationDAO)this.implementationDAO).find(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected String processPreparedAttr(Pair<String, Attribute> preparedAttr, Set<Attribute> attributes) {
        String connObjectKey = null;
        if (preparedAttr != null) {
            if (preparedAttr.getLeft() != null) {
                connObjectKey = (String)preparedAttr.getLeft();
            }
            if (preparedAttr.getRight() != null) {
                Attribute alreadyAdded = AttributeUtil.find((String)((Attribute)preparedAttr.getRight()).getName(), attributes);
                if (alreadyAdded == null) {
                    attributes.add((Attribute)preparedAttr.getRight());
                } else {
                    attributes.remove(alreadyAdded);
                    HashSet values = new HashSet();
                    if (alreadyAdded.getValue() != null && !alreadyAdded.getValue().isEmpty()) {
                        values.addAll(alreadyAdded.getValue());
                    }
                    if (((Attribute)preparedAttr.getRight()).getValue() != null) {
                        values.addAll(((Attribute)preparedAttr.getRight()).getValue());
                    }
                    attributes.add(AttributeBuilder.build((String)((Attribute)preparedAttr.getRight()).getName(), values));
                }
            }
        }
        return connObjectKey;
    }

    protected static Name getName(String evalConnObjectLink, String connObjectKey) {
        Name name;
        if (StringUtils.isBlank((CharSequence)evalConnObjectLink)) {
            LOG.debug("Add connObjectKey [{}] as {}", (Object)connObjectKey, (Object)Name.NAME);
            name = new Name(connObjectKey);
        } else {
            LOG.debug("Add connObjectLink [{}] as {}", (Object)evalConnObjectLink, (Object)Name.NAME);
            name = new Name(evalConnObjectLink);
            LOG.debug("connObjectKey will be used just as {} attribute", (Object)Uid.NAME);
        }
        return name;
    }

    protected Name evaluateNAME(Any<?> any, Provision provision, String connObjectKey) {
        if (StringUtils.isBlank((CharSequence)connObjectKey)) {
            LOG.warn("Missing ConnObjectKey value for {}: ", (Object)any.getType().getKey());
        }
        String connObjectLink = provision.getMapping() == null ? null : provision.getMapping().getConnObjectLink();
        String evalConnObjectLink = null;
        if (StringUtils.isNotBlank((CharSequence)connObjectLink)) {
            MapContext jexlContext = new MapContext();
            JexlUtils.addFieldsToContext(any, (JexlContext)jexlContext);
            JexlUtils.addPlainAttrsToContext((Collection)any.getPlainAttrs(), (JexlContext)jexlContext);
            JexlUtils.addDerAttrsToContext(any, (DerAttrHandler)this.derAttrHandler, (JexlContext)jexlContext);
            evalConnObjectLink = JexlUtils.evaluateExpr((String)connObjectLink, (JexlContext)jexlContext).toString();
        }
        return DefaultMappingManager.getName(evalConnObjectLink, connObjectKey);
    }

    protected Name evaluateNAME(Realm realm, OrgUnit orgUnit, String connObjectKey) {
        if (StringUtils.isBlank((CharSequence)connObjectKey)) {
            LOG.warn("Missing ConnObjectKey value for Realms");
        }
        String connObjectLink = orgUnit.getConnObjectLink();
        String evalConnObjectLink = null;
        if (StringUtils.isNotBlank((CharSequence)connObjectLink)) {
            MapContext jexlContext = new MapContext();
            JexlUtils.addFieldsToContext((Object)realm, (JexlContext)jexlContext);
            evalConnObjectLink = JexlUtils.evaluateExpr((String)connObjectLink, (JexlContext)jexlContext).toString();
        }
        return DefaultMappingManager.getName(evalConnObjectLink, connObjectKey);
    }

    @Transactional(readOnly=true)
    public Pair<String, Set<Attribute>> prepareAttrsFromAny(Any<?> any, String password, boolean changePwd, Boolean enable, ExternalResource resource, Provision provision) {
        Attribute pwdAttr;
        LOG.debug("Preparing resource attributes for {} with provision {} for attributes {}", new Object[]{any, provision, any.getPlainAttrs()});
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        String[] connObjectKeyValue = new String[1];
        MappingUtils.getPropagationItems(provision.getMapping().getItems().stream()).forEach(mapItem -> {
            LOG.debug("Processing expression '{}'", (Object)mapItem.getIntAttrName());
            try {
                String processedConnObjectKeyValue = this.processPreparedAttr(this.prepareAttr(resource, provision, (Item)mapItem, any, password, AccountGetter.DEFAULT, AccountGetter.DEFAULT, PlainAttrGetter.DEFAULT), attributes);
                if (processedConnObjectKeyValue != null) {
                    connObjectKeyValue[0] = processedConnObjectKeyValue;
                }
            }
            catch (Exception e) {
                LOG.error("Expression '{}' processing failed", (Object)mapItem.getIntAttrName(), (Object)e);
            }
        });
        MappingUtils.getConnObjectKeyItem(provision).ifPresent(connObjectKeyItem -> {
            Attribute connObjectKeyAttr = AttributeUtil.find((String)connObjectKeyItem.getExtAttrName(), (Set)attributes);
            if (connObjectKeyAttr != null) {
                attributes.remove(connObjectKeyAttr);
                attributes.add(AttributeBuilder.build((String)connObjectKeyItem.getExtAttrName(), (Object[])new Object[]{connObjectKeyValue[0]}));
            }
            Name name = this.evaluateNAME(any, provision, connObjectKeyValue[0]);
            attributes.add((Attribute)name);
            if (connObjectKeyAttr == null && connObjectKeyValue[0] != null && !connObjectKeyValue[0].equals(name.getNameValue())) {
                attributes.add(AttributeBuilder.build((String)connObjectKeyItem.getExtAttrName(), (Object[])new Object[]{connObjectKeyValue[0]}));
            }
        });
        if (enable != null) {
            attributes.add(AttributeBuilder.buildEnabled((boolean)enable));
        }
        if (!changePwd && (pwdAttr = AttributeUtil.find((String)OperationalAttributes.PASSWORD_NAME, attributes)) != null) {
            attributes.remove(pwdAttr);
        }
        return Pair.of((Object)connObjectKeyValue[0], attributes);
    }

    @Transactional(readOnly=true)
    public Set<Attribute> prepareAttrsFromLinkedAccount(User user, LinkedAccount account, String password, boolean changePwd, Provision provision) {
        Attribute pwdAttr;
        LOG.debug("Preparing resource attributes for linked account {} of user {} with provision {} for user attributes {} with override {}", new Object[]{account, user, provision, user.getPlainAttrs(), account.getPlainAttrs()});
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        MappingUtils.getPropagationItems(provision.getMapping().getItems().stream()).forEach(mapItem -> {
            LOG.debug("Processing expression '{}'", (Object)mapItem.getIntAttrName());
            try {
                this.processPreparedAttr(this.prepareAttr(account.getResource(), provision, (Item)mapItem, (Any<?>)user, password, acct -> account.getUsername() == null ? (Account)AccountGetter.DEFAULT.apply(acct) : account, acct -> account.getPassword() == null ? (Account)AccountGetter.DEFAULT.apply(acct) : account, (attributable, schema) -> {
                    Optional accountAttr;
                    PlainAttr result = null;
                    if (attributable instanceof User && (accountAttr = account.getPlainAttr(schema)).isPresent()) {
                        result = (PlainAttr)accountAttr.get();
                    }
                    if (result == null) {
                        result = (PlainAttr)PlainAttrGetter.DEFAULT.apply(attributable, schema);
                    }
                    return result;
                }), attributes);
            }
            catch (Exception e) {
                LOG.error("Expression '{}' processing failed", (Object)mapItem.getIntAttrName(), (Object)e);
            }
        });
        String connObjectKey = account.getConnObjectKeyValue();
        MappingUtils.getConnObjectKeyItem(provision).ifPresent(connObjectKeyItem -> {
            Attribute connObjectKeyExtAttr = AttributeUtil.find((String)connObjectKeyItem.getExtAttrName(), (Set)attributes);
            if (connObjectKeyExtAttr != null) {
                attributes.remove(connObjectKeyExtAttr);
                attributes.add(AttributeBuilder.build((String)connObjectKeyItem.getExtAttrName(), (Object[])new Object[]{connObjectKey}));
            }
            Name name = this.evaluateNAME((Any<?>)user, provision, connObjectKey);
            attributes.add((Attribute)name);
            if (!connObjectKey.equals(name.getNameValue()) && connObjectKeyExtAttr == null) {
                attributes.add(AttributeBuilder.build((String)connObjectKeyItem.getExtAttrName(), (Object[])new Object[]{connObjectKey}));
            }
        });
        if (account.isSuspended() != null) {
            attributes.add(AttributeBuilder.buildEnabled((boolean)BooleanUtils.negate((Boolean)account.isSuspended())));
        }
        if (!changePwd && (pwdAttr = AttributeUtil.find((String)OperationalAttributes.PASSWORD_NAME, attributes)) != null) {
            attributes.remove(pwdAttr);
        }
        return attributes;
    }

    protected String getIntValue(Realm realm, Item orgUnitItem) {
        String value = null;
        switch (orgUnitItem.getIntAttrName()) {
            case "key": {
                value = realm.getKey();
                break;
            }
            case "name": {
                value = realm.getName();
                break;
            }
            case "fullpath": {
                value = realm.getFullPath();
                break;
            }
        }
        return value;
    }

    public Pair<String, Set<Attribute>> prepareAttrsFromRealm(Realm realm, OrgUnit orgUnit) {
        LOG.debug("Preparing resource attributes for {} with orgUnit {}", (Object)realm, (Object)orgUnit);
        HashSet<Object> attributes = new HashSet<Object>();
        String[] connObjectKeyValue = new String[1];
        MappingUtils.getPropagationItems(orgUnit.getItems().stream()).forEach(orgUnitItem -> {
            Attribute alreadyAdded;
            LOG.debug("Processing expression '{}'", (Object)orgUnitItem.getIntAttrName());
            String value = this.getIntValue(realm, (Item)orgUnitItem);
            if (orgUnitItem.isConnObjectKey()) {
                connObjectKeyValue[0] = value;
            }
            if ((alreadyAdded = AttributeUtil.find((String)orgUnitItem.getExtAttrName(), (Set)attributes)) == null) {
                if (value == null) {
                    attributes.add(AttributeBuilder.build((String)orgUnitItem.getExtAttrName()));
                } else {
                    attributes.add(AttributeBuilder.build((String)orgUnitItem.getExtAttrName(), (Object[])new Object[]{value}));
                }
            } else if (value != null) {
                attributes.remove(alreadyAdded);
                HashSet<String> values = new HashSet<String>();
                if (alreadyAdded.getValue() != null && !alreadyAdded.getValue().isEmpty()) {
                    values.addAll(alreadyAdded.getValue());
                }
                values.add(value);
                attributes.add(AttributeBuilder.build((String)orgUnitItem.getExtAttrName(), values));
            }
        });
        Optional connObjectKeyItem = orgUnit.getConnObjectKeyItem();
        if (connObjectKeyItem.isPresent()) {
            Attribute connObjectKeyAttr = AttributeUtil.find((String)((Item)connObjectKeyItem.get()).getExtAttrName(), attributes);
            if (connObjectKeyAttr != null) {
                attributes.remove(connObjectKeyAttr);
                attributes.add(AttributeBuilder.build((String)((Item)connObjectKeyItem.get()).getExtAttrName(), (Object[])new Object[]{connObjectKeyValue[0]}));
            }
            attributes.add(this.evaluateNAME(realm, orgUnit, connObjectKeyValue[0]));
        }
        return Pair.of((Object)connObjectKeyValue[0], attributes);
    }

    protected String decodePassword(Account account) {
        try {
            return Encryptor.getInstance().decode(account.getPassword(), account.getCipherAlgorithm());
        }
        catch (Exception e) {
            LOG.error("Could not decode password for {}", (Object)account, (Object)e);
            return null;
        }
    }

    protected String getPasswordAttrValue(Account account, String defaultValue) {
        String passwordAttrValue = account instanceof LinkedAccount ? (account.getPassword() != null ? this.decodePassword(account) : defaultValue) : (StringUtils.isNotBlank((CharSequence)defaultValue) ? defaultValue : (account.canDecodeSecrets() ? this.decodePassword(account) : null));
        return passwordAttrValue;
    }

    public Pair<String, Attribute> prepareAttr(ExternalResource resource, Provision provision, Item item, Any<?> any, String password, AccountGetter usernameAccountGetter, AccountGetter passwordAccountGetter, PlainAttrGetter plainAttrGetter) {
        Object result;
        IntAttrName intAttrName;
        try {
            intAttrName = this.intAttrNameParser.parse(item.getIntAttrName(), any.getType().getKind());
        }
        catch (ParseException e) {
            LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)item.getIntAttrName(), (Object)e);
            return null;
        }
        AttrSchemaType schemaType = intAttrName.getSchema() instanceof PlainSchema ? intAttrName.getSchema().getType() : AttrSchemaType.String;
        boolean readOnlyVirSchema = intAttrName.getSchema() instanceof VirSchema ? intAttrName.getSchema().isReadonly() : false;
        Pair<AttrSchemaType, List<PlainAttrValue>> intValues = this.getIntValues(resource, provision, item, intAttrName, schemaType, any, usernameAccountGetter, plainAttrGetter);
        schemaType = (AttrSchemaType)intValues.getLeft();
        List values = (List)intValues.getRight();
        LOG.debug("Define mapping for: \n* ExtAttrName " + item.getExtAttrName() + "\n* is connObjectKey " + item.isConnObjectKey() + "\n* is password " + item.isPassword() + "\n* mandatory condition " + item.getMandatoryCondition() + "\n* Schema " + String.valueOf(intAttrName.getSchema()) + "\n* ClassType " + schemaType.getType().getName() + "\n* AttrSchemaType " + String.valueOf(schemaType) + "\n* Values " + String.valueOf(values));
        if (readOnlyVirSchema) {
            result = null;
        } else {
            String passwordAttrValue;
            ArrayList<Object> objValues = new ArrayList<Object>();
            for (PlainAttrValue value : values) {
                PlainSchema schema;
                if (intAttrName.getSchema() instanceof PlainSchema && schemaType == AttrSchemaType.Encrypted) {
                    schema = (PlainSchema)intAttrName.getSchema();
                    String decoded = null;
                    try {
                        decoded = Encryptor.getInstance((String)schema.getSecretKey()).decode(value.getStringValue(), schema.getCipherAlgorithm());
                    }
                    catch (Exception e) {
                        LOG.warn("Could not decode value for {} with algorithm", new Object[]{intAttrName.getSchema(), schema.getCipherAlgorithm(), e});
                    }
                    objValues.add(Optional.ofNullable(decoded).orElse(value.getStringValue()));
                    continue;
                }
                if (FrameworkUtil.isSupportedAttributeType((Class)schemaType.getType())) {
                    objValues.add(value.getValue());
                    continue;
                }
                PlainSchema plainSchema = schema = intAttrName.getSchema() instanceof PlainSchema ? (PlainSchema)intAttrName.getSchema() : null;
                if (schema == null || schema.getType() != schemaType) {
                    objValues.add(value.getValueAsString(schemaType));
                    continue;
                }
                objValues.add(value.getValueAsString(schema));
            }
            result = item.isConnObjectKey() ? Pair.of(objValues.isEmpty() ? null : objValues.iterator().next().toString(), null) : (item.isPassword() && any instanceof User ? ((passwordAttrValue = this.getPasswordAttrValue((Account)passwordAccountGetter.apply((Object)((User)any)), password)) == null ? null : Pair.of(null, (Object)AttributeBuilder.buildPassword((char[])passwordAttrValue.toCharArray()))) : (objValues.isEmpty() ? Pair.of(null, (Object)AttributeBuilder.build((String)item.getExtAttrName())) : (OperationalAttributes.PASSWORD_NAME.equals(item.getExtAttrName()) ? Pair.of(null, (Object)AttributeBuilder.buildPassword((char[])objValues.iterator().next().toString().toCharArray())) : Pair.of(null, (Object)AttributeBuilder.build((String)item.getExtAttrName(), objValues)))));
        }
        return result;
    }

    @Transactional(readOnly=true)
    public Pair<AttrSchemaType, List<PlainAttrValue>> getIntValues(ExternalResource resource, Provision provision, Item mapItem, IntAttrName intAttrName, AttrSchemaType schemaType, Any<?> any, AccountGetter usernameAccountGetter, PlainAttrGetter plainAttrGetter) {
        LOG.debug("Get internal values for {} as '{}' on {}", new Object[]{any, mapItem.getIntAttrName(), resource});
        ArrayList<Object> references = new ArrayList<Object>();
        Membership membership = null;
        if (intAttrName.getEnclosingGroup() == null && intAttrName.getRelatedAnyObject() == null && intAttrName.getRelationshipAnyType() == null && intAttrName.getRelationshipType() == null && intAttrName.getRelatedUser() == null) {
            references.add(any);
        }
        if (any instanceof GroupableRelatable) {
            Group group;
            GroupableRelatable groupableRelatable = (GroupableRelatable)any;
            if (intAttrName.getEnclosingGroup() != null) {
                group = this.groupDAO.findByName(intAttrName.getEnclosingGroup());
                if (group == null || any instanceof User ? !this.userDAO.findAllGroupKeys((User)any).contains(group.getKey()) : any instanceof AnyObject && !this.anyObjectDAO.findAllGroupKeys((AnyObject)any).contains(group.getKey())) {
                    LOG.warn("No (dyn) membership for {} in {}, ignoring", (Object)intAttrName.getEnclosingGroup(), (Object)groupableRelatable);
                } else {
                    references.add(group);
                }
            } else if (intAttrName.getRelatedUser() != null) {
                User user = this.userDAO.findByUsername(intAttrName.getRelatedUser());
                if (user == null || user.getRelationships(groupableRelatable.getKey()).isEmpty()) {
                    LOG.warn("No relationship for {} in {}, ignoring", (Object)intAttrName.getRelatedUser(), (Object)groupableRelatable);
                } else if (groupableRelatable.getType().getKind() == AnyTypeKind.USER) {
                    LOG.warn("Users cannot have relationship with other users, ignoring");
                } else {
                    references.add(user);
                }
            } else if (intAttrName.getRelatedAnyObject() != null) {
                AnyObject anyObject = (AnyObject)this.anyObjectDAO.find(intAttrName.getRelatedAnyObject());
                if (anyObject == null || groupableRelatable.getRelationships(anyObject.getKey()).isEmpty()) {
                    LOG.warn("No relationship for {} in {}, ignoring", (Object)intAttrName.getRelatedAnyObject(), (Object)groupableRelatable);
                } else {
                    references.add(anyObject);
                }
            } else if (intAttrName.getRelationshipAnyType() != null && intAttrName.getRelationshipType() != null) {
                RelationshipType relationshipType = this.relationshipTypeDAO.find(intAttrName.getRelationshipType());
                AnyType anyType = this.anyTypeDAO.find(intAttrName.getRelationshipAnyType());
                if (relationshipType == null || groupableRelatable.getRelationships(relationshipType).isEmpty()) {
                    LOG.warn("No relationship for type {} in {}, ignoring", (Object)intAttrName.getRelationshipType(), (Object)groupableRelatable);
                } else if (anyType == null) {
                    LOG.warn("No anyType {}, ignoring", (Object)intAttrName.getRelationshipAnyType());
                } else {
                    references.addAll(groupableRelatable.getRelationships(relationshipType).stream().filter(relationship -> anyType.equals(relationship.getRightEnd().getType())).map(Relationship::getRightEnd).collect(Collectors.toList()));
                }
            } else if (intAttrName.getMembershipOfGroup() != null) {
                group = this.groupDAO.findByName(intAttrName.getMembershipOfGroup());
                membership = groupableRelatable.getMembership(group.getKey()).orElse(null);
            }
        }
        if (references.isEmpty()) {
            LOG.warn("Could not determine the reference instance for {}", (Object)mapItem.getIntAttrName());
            return Pair.of((Object)schemaType, List.of());
        }
        ArrayList<PlainAttrValue> values = new ArrayList<PlainAttrValue>();
        boolean transform = true;
        block26: for (Any any2 : references) {
            AnyUtils anyUtils = this.anyUtilsFactory.getInstance(any2);
            if (intAttrName.getField() != null) {
                PlainAttrValue attrValue = anyUtils.newPlainAttrValue();
                switch (intAttrName.getField()) {
                    case "key": {
                        attrValue.setStringValue(any2.getKey());
                        values.add(attrValue);
                        break;
                    }
                    case "username": {
                        if (!(any2 instanceof Account)) continue block26;
                        attrValue.setStringValue(((Account)usernameAccountGetter.apply((Object)((Account)any2))).getUsername());
                        values.add(attrValue);
                        break;
                    }
                    case "realm": {
                        attrValue.setStringValue(any2.getRealm().getFullPath());
                        values.add(attrValue);
                        break;
                    }
                    case "password": {
                        break;
                    }
                    case "userOwner": 
                    case "groupOwner": {
                        Mapping gMappingTO;
                        Mapping uMappingTO = provision.getAnyType().equals(AnyTypeKind.USER.name()) ? provision.getMapping() : null;
                        Mapping mapping = gMappingTO = provision.getAnyType().equals(AnyTypeKind.GROUP.name()) ? provision.getMapping() : null;
                        if (!(any2 instanceof Group)) continue block26;
                        Group group = (Group)any2;
                        String groupOwnerValue = null;
                        if (group.getUserOwner() != null && uMappingTO != null) {
                            groupOwnerValue = this.getGroupOwnerValue(resource, provision, (Any<?>)group.getUserOwner());
                        }
                        if (group.getGroupOwner() != null && gMappingTO != null) {
                            groupOwnerValue = this.getGroupOwnerValue(resource, provision, (Any<?>)group.getGroupOwner());
                        }
                        if (!StringUtils.isNotBlank(groupOwnerValue)) continue block26;
                        attrValue.setStringValue(groupOwnerValue);
                        values.add(attrValue);
                        break;
                    }
                    case "suspended": {
                        if (!(any2 instanceof User)) continue block26;
                        attrValue.setBooleanValue(((User)any2).isSuspended());
                        values.add(attrValue);
                        break;
                    }
                    case "mustChangePassword": {
                        if (!(any2 instanceof User)) continue block26;
                        attrValue.setBooleanValue(Boolean.valueOf(((User)any2).isMustChangePassword()));
                        values.add(attrValue);
                        break;
                    }
                    default: {
                        try {
                            Object fieldValue = FieldUtils.readField((Object)any2, (String)intAttrName.getField(), (boolean)true);
                            if (fieldValue instanceof TemporalAccessor) {
                                attrValue.setStringValue(FormatUtils.format((TemporalAccessor)((TemporalAccessor)fieldValue)));
                            } else if (Boolean.TYPE.isInstance(fieldValue)) {
                                attrValue.setBooleanValue((Boolean)fieldValue);
                            } else if (Double.TYPE.isInstance(fieldValue) || Float.TYPE.isInstance(fieldValue)) {
                                attrValue.setDoubleValue((Double)fieldValue);
                            } else if (Long.TYPE.isInstance(fieldValue) || Integer.TYPE.isInstance(fieldValue)) {
                                attrValue.setLongValue((Long)fieldValue);
                            } else {
                                attrValue.setStringValue(fieldValue.toString());
                            }
                            values.add(attrValue);
                            break;
                        }
                        catch (Exception e) {
                            LOG.error("Could not read value of '{}' from {}", new Object[]{intAttrName.getField(), any2, e});
                        }
                    }
                }
                continue;
            }
            if (intAttrName.getSchemaType() != null) {
                switch (intAttrName.getSchemaType()) {
                    case PLAIN: {
                        PlainAttr attr = membership == null ? (PlainAttr)plainAttrGetter.apply((Object)any2, (Object)intAttrName.getSchema().getKey()) : (PlainAttr)((GroupableRelatable)any2).getPlainAttr(intAttrName.getSchema().getKey(), membership).orElse(null);
                        if (attr == null) continue block26;
                        if (attr.getUniqueValue() != null) {
                            values.add(anyUtils.clonePlainAttrValue((PlainAttrValue)attr.getUniqueValue()));
                            continue block26;
                        }
                        if (attr.getValues() == null) continue block26;
                        attr.getValues().forEach(value -> values.add(anyUtils.clonePlainAttrValue(value)));
                        continue block26;
                    }
                    case DERIVED: {
                        DerSchema derSchema = (DerSchema)intAttrName.getSchema();
                        String derValue = membership == null ? this.derAttrHandler.getValue(any2, derSchema) : this.derAttrHandler.getValue(any2, membership, derSchema);
                        if (derValue == null) continue block26;
                        PlainAttrValue attrValue = anyUtils.newPlainAttrValue();
                        attrValue.setStringValue(derValue);
                        values.add(attrValue);
                        continue block26;
                    }
                    case VIRTUAL: {
                        transform = false;
                        VirAttrCacheKey cacheKey = new VirAttrCacheKey(any2.getType().getKey(), any2.getKey(), intAttrName.getSchema().getKey());
                        this.virAttrCache.expire(cacheKey);
                        LOG.debug("Evicted from cache: {}", (Object)cacheKey);
                        VirSchema virSchema = (VirSchema)intAttrName.getSchema();
                        List virValues = membership == null ? this.virAttrHandler.getValues(any2, virSchema) : this.virAttrHandler.getValues(any2, membership, virSchema);
                        virValues.forEach(virValue -> {
                            PlainAttrValue attrValue = anyUtils.newPlainAttrValue();
                            attrValue.setStringValue(virValue);
                            values.add(attrValue);
                        });
                        continue block26;
                    }
                }
                continue;
            }
            if (intAttrName.getPrivilegesOfApplication() == null || !(any2 instanceof User)) continue;
            Application application = this.applicationDAO.find(intAttrName.getPrivilegesOfApplication());
            if (application == null) {
                LOG.warn("Invalid application: {}", (Object)intAttrName.getPrivilegesOfApplication());
                continue;
            }
            this.userDAO.findAllRoles((User)any2).stream().flatMap(role -> role.getPrivileges(application).stream()).forEach(privilege -> {
                PlainAttrValue attrValue = anyUtils.newPlainAttrValue();
                attrValue.setStringValue(privilege.getKey());
                values.add(attrValue);
            });
        }
        LOG.debug("Internal values: {}", values);
        Pair transformed = Pair.of((Object)schemaType, values);
        if (transform) {
            for (ItemTransformer transformer : MappingUtils.getItemTransformers(mapItem, this.getTransformers(mapItem))) {
                transformed = transformer.beforePropagation(mapItem, any, (AttrSchemaType)transformed.getLeft(), (List)transformed.getRight());
            }
            LOG.debug("Transformed values: {}", values);
        } else {
            LOG.debug("No transformation occurred");
        }
        return transformed;
    }

    protected String getGroupOwnerValue(ExternalResource resource, Provision provision, Any<?> any) {
        Optional<Item> connObjectKeyItem = MappingUtils.getConnObjectKeyItem(provision);
        Pair<String, Attribute> preparedAttr = null;
        if (connObjectKeyItem.isPresent()) {
            preparedAttr = this.prepareAttr(resource, provision, connObjectKeyItem.get(), any, null, AccountGetter.DEFAULT, AccountGetter.DEFAULT, PlainAttrGetter.DEFAULT);
        }
        return Optional.ofNullable(preparedAttr).map(attr -> this.evaluateNAME(any, provision, (String)attr.getKey()).getNameValue()).orElse(null);
    }

    @Transactional(readOnly=true)
    public Optional<String> getConnObjectKeyValue(Any<?> any, ExternalResource resource, Provision provision) {
        Pair<AttrSchemaType, List<PlainAttrValue>> intValues;
        Optional connObjectKeyItem = provision.getMapping().getConnObjectKeyItem();
        if (connObjectKeyItem.isEmpty()) {
            LOG.error("Unable to locate conn object key item for {}", (Object)any.getType().getKey());
            return Optional.empty();
        }
        Item mapItem = (Item)connObjectKeyItem.get();
        try {
            intValues = this.getIntValues(resource, provision, mapItem, this.intAttrNameParser.parse(mapItem.getIntAttrName(), any.getType().getKind()), AttrSchemaType.String, any, AccountGetter.DEFAULT, PlainAttrGetter.DEFAULT);
        }
        catch (ParseException e) {
            LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)mapItem.getIntAttrName(), (Object)e);
            intValues = Pair.of((Object)AttrSchemaType.String, List.of());
        }
        return Optional.ofNullable(((List)intValues.getRight()).isEmpty() ? null : ((PlainAttrValue)((List)intValues.getRight()).get(0)).getValueAsString());
    }

    @Transactional(readOnly=true)
    public Optional<String> getConnObjectKeyValue(Realm realm, OrgUnit orgUnit) {
        Optional connObjectKeyItem = orgUnit.getConnObjectKeyItem();
        if (connObjectKeyItem.isEmpty()) {
            LOG.error("Unable to locate conn object key item for Realms");
            return Optional.empty();
        }
        return Optional.ofNullable(this.getIntValue(realm, (Item)connObjectKeyItem.get()));
    }

    @Transactional(readOnly=true)
    public void setIntValues(Item mapItem, Attribute attr, AnyTO anyTO) {
        IntAttrName intAttrName;
        List values = null;
        if (attr != null) {
            values = attr.getValue();
            for (ItemTransformer transformer : MappingUtils.getItemTransformers(mapItem, this.getTransformers(mapItem))) {
                values = transformer.beforePull(mapItem, (EntityTO)anyTO, values);
            }
        }
        values = Optional.ofNullable(values).orElse(List.of());
        try {
            intAttrName = this.intAttrNameParser.parse(mapItem.getIntAttrName(), AnyTypeKind.fromTOClass(anyTO.getClass()));
        }
        catch (ParseException e) {
            LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)mapItem.getIntAttrName(), (Object)e);
            return;
        }
        if (intAttrName.getField() != null) {
            switch (intAttrName.getField()) {
                case "password": {
                    if (!(anyTO instanceof UserTO) || values.isEmpty()) break;
                    ((UserTO)anyTO).setPassword(ConnObjectUtils.getPassword(values.get(0)));
                    break;
                }
                case "username": {
                    if (!(anyTO instanceof UserTO)) break;
                    ((UserTO)anyTO).setUsername(values.isEmpty() || values.get(0) == null ? null : values.get(0).toString());
                    break;
                }
                case "name": {
                    if (anyTO instanceof GroupTO) {
                        ((GroupTO)anyTO).setName(values.isEmpty() || values.get(0) == null ? null : values.get(0).toString());
                        break;
                    }
                    if (!(anyTO instanceof AnyObjectTO)) break;
                    ((AnyObjectTO)anyTO).setName(values.isEmpty() || values.get(0) == null ? null : values.get(0).toString());
                    break;
                }
                case "mustChangePassword": {
                    if (!(anyTO instanceof UserTO) || values.isEmpty() || values.get(0) == null) break;
                    ((UserTO)anyTO).setMustChangePassword(BooleanUtils.toBoolean((String)values.get(0).toString()));
                    break;
                }
                case "userOwner": 
                case "groupOwner": {
                    if (!(anyTO instanceof GroupTO) || attr == null) break;
                    Attr attrTO = new Attr();
                    attrTO.setSchema("");
                    if (values.isEmpty() || values.get(0) == null) {
                        attrTO.getValues().add("");
                    } else {
                        attrTO.getValues().add(values.get(0).toString());
                    }
                    ((GroupTO)anyTO).getPlainAttrs().add(attrTO);
                    break;
                }
            }
        } else if (intAttrName.getSchemaType() != null && attr != null) {
            Group group;
            GroupableRelatableTO groupableTO;
            if (anyTO instanceof GroupableRelatableTO && intAttrName.getMembershipOfGroup() != null) {
                groupableTO = (GroupableRelatableTO)anyTO;
                group = this.groupDAO.findByName(intAttrName.getMembershipOfGroup());
            } else {
                groupableTO = null;
                group = null;
            }
            switch (intAttrName.getSchemaType()) {
                case PLAIN: {
                    Attr attrTO = new Attr();
                    attrTO.setSchema(intAttrName.getSchema().getKey());
                    PlainSchema schema = (PlainSchema)intAttrName.getSchema();
                    for (Object value2 : values) {
                        AttrSchemaType schemaType;
                        AttrSchemaType attrSchemaType = schemaType = schema == null ? AttrSchemaType.String : schema.getType();
                        if (value2 == null) continue;
                        if (schemaType == AttrSchemaType.Binary) {
                            attrTO.getValues().add(Base64.getEncoder().encodeToString((byte[])value2));
                            continue;
                        }
                        attrTO.getValues().add(value2.toString());
                    }
                    if (groupableTO == null || group == null) {
                        anyTO.getPlainAttrs().add(attrTO);
                        break;
                    }
                    MembershipTO membership = groupableTO.getMembership(group.getKey()).orElseGet(() -> {
                        MembershipTO newMemb = new MembershipTO.Builder(group.getKey()).build();
                        groupableTO.getMemberships().add(newMemb);
                        return newMemb;
                    });
                    membership.getPlainAttrs().add(attrTO);
                    break;
                }
                case DERIVED: {
                    Attr attrTO = new Attr();
                    attrTO.setSchema(intAttrName.getSchema().getKey());
                    if (groupableTO == null || group == null) {
                        anyTO.getDerAttrs().add(attrTO);
                        break;
                    }
                    MembershipTO membership = groupableTO.getMembership(group.getKey()).orElseGet(() -> {
                        MembershipTO newMemb = new MembershipTO.Builder(group.getKey()).build();
                        groupableTO.getMemberships().add(newMemb);
                        return newMemb;
                    });
                    membership.getDerAttrs().add(attrTO);
                    break;
                }
                case VIRTUAL: {
                    Attr attrTO = new Attr();
                    attrTO.setSchema(intAttrName.getSchema().getKey());
                    if (attr.getValue() != null && !attr.getValue().isEmpty()) {
                        attr.getValue().stream().filter(Objects::nonNull).forEachOrdered(value -> attrTO.getValues().add(value.toString()));
                    }
                    if (groupableTO == null || group == null) {
                        anyTO.getVirAttrs().add(attrTO);
                        break;
                    }
                    MembershipTO membership = groupableTO.getMembership(group.getKey()).orElseGet(() -> {
                        MembershipTO newMemb = new MembershipTO.Builder(group.getKey()).build();
                        groupableTO.getMemberships().add(newMemb);
                        return newMemb;
                    });
                    membership.getVirAttrs().add(attrTO);
                    break;
                }
            }
        }
    }

    public void setIntValues(Item item, Attribute attr, RealmTO realmTO) {
        List values = null;
        if (attr != null) {
            values = attr.getValue();
            for (ItemTransformer transformer : MappingUtils.getItemTransformers(item, this.getTransformers(item))) {
                values = transformer.beforePull(item, (EntityTO)realmTO, values);
            }
        }
        if (values != null && !values.isEmpty() && values.get(0) != null) {
            switch (item.getIntAttrName()) {
                case "name": {
                    realmTO.setName(values.get(0).toString());
                    break;
                }
                case "fullpath": {
                    String parentFullPath = StringUtils.substringBeforeLast((String)values.get(0).toString(), (String)"/");
                    Realm parent = this.realmDAO.findByFullPath(parentFullPath);
                    if (parent == null) {
                        LOG.warn("Could not find Realm with path {}, ignoring", (Object)parentFullPath);
                        break;
                    }
                    realmTO.setParent(parent.getFullPath());
                    break;
                }
            }
        }
    }

    @Transactional(readOnly=true)
    public boolean hasMustChangePassword(Provision provision) {
        return provision != null && provision.getMapping() != null && provision.getMapping().getItems().stream().anyMatch(mappingItem -> "mustChangePassword".equals(mappingItem.getIntAttrName()));
    }
}

