/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data.wa;

import org.apache.syncope.common.lib.policy.AccessPolicyTO;
import org.apache.syncope.common.lib.policy.AttrReleasePolicyTO;
import org.apache.syncope.common.lib.policy.AuthPolicyConf;
import org.apache.syncope.common.lib.policy.AuthPolicyTO;
import org.apache.syncope.common.lib.policy.DefaultAuthPolicyConf;
import org.apache.syncope.common.lib.policy.TicketExpirationPolicyTO;
import org.apache.syncope.common.lib.wa.WAClientApp;
import org.apache.syncope.core.persistence.api.dao.AuthModuleDAO;
import org.apache.syncope.core.persistence.api.entity.am.AuthModule;
import org.apache.syncope.core.persistence.api.entity.am.ClientApp;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.provisioning.api.data.AuthModuleDataBinder;
import org.apache.syncope.core.provisioning.api.data.ClientAppDataBinder;
import org.apache.syncope.core.provisioning.api.data.PolicyDataBinder;
import org.apache.syncope.core.provisioning.api.data.wa.WAClientAppDataBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WAClientAppDataBinderImpl
implements WAClientAppDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(WAClientAppDataBinder.class);
    protected final ClientAppDataBinder clientAppDataBinder;
    protected final PolicyDataBinder policyDataBinder;
    protected final AuthModuleDataBinder authModuleDataBinder;
    protected final AuthModuleDAO authModuleDAO;

    public WAClientAppDataBinderImpl(ClientAppDataBinder clientAppDataBinder, PolicyDataBinder policyDataBinder, AuthModuleDataBinder authModuleDataBinder, AuthModuleDAO authModuleDAO) {
        this.clientAppDataBinder = clientAppDataBinder;
        this.policyDataBinder = policyDataBinder;
        this.authModuleDataBinder = authModuleDataBinder;
        this.authModuleDAO = authModuleDAO;
    }

    public WAClientApp getWAClientApp(ClientApp clientApp) {
        WAClientApp waClientApp = new WAClientApp();
        waClientApp.setClientAppTO(this.clientAppDataBinder.getClientAppTO(clientApp));
        try {
            AuthPolicyConf authPolicyConf = null;
            if (clientApp.getAuthPolicy() != null) {
                authPolicyConf = clientApp.getAuthPolicy().getConf();
                waClientApp.setAuthPolicy((AuthPolicyTO)this.policyDataBinder.getPolicyTO((Policy)clientApp.getAuthPolicy()));
            } else if (clientApp.getRealm() != null && clientApp.getRealm().getAuthPolicy() != null) {
                authPolicyConf = clientApp.getRealm().getAuthPolicy().getConf();
                waClientApp.setAuthPolicy((AuthPolicyTO)this.policyDataBinder.getPolicyTO((Policy)clientApp.getRealm().getAuthPolicy()));
            }
            if (authPolicyConf instanceof DefaultAuthPolicyConf) {
                ((DefaultAuthPolicyConf)authPolicyConf).getAuthModules().forEach(key -> {
                    AuthModule authModule = this.authModuleDAO.find(key);
                    if (authModule == null) {
                        LOG.warn("AuthModule " + String.valueOf(authModule) + " not found");
                    } else {
                        waClientApp.getAuthModules().add(this.authModuleDataBinder.getAuthModuleTO(authModule));
                    }
                });
            }
            if (clientApp.getAccessPolicy() != null) {
                waClientApp.setAccessPolicy((AccessPolicyTO)this.policyDataBinder.getPolicyTO((Policy)clientApp.getAccessPolicy()));
            } else if (clientApp.getRealm() != null && clientApp.getRealm().getAccessPolicy() != null) {
                waClientApp.setAccessPolicy((AccessPolicyTO)this.policyDataBinder.getPolicyTO((Policy)clientApp.getRealm().getAccessPolicy()));
            }
            if (clientApp.getAttrReleasePolicy() != null) {
                waClientApp.setAttrReleasePolicy((AttrReleasePolicyTO)this.policyDataBinder.getPolicyTO((Policy)clientApp.getAttrReleasePolicy()));
            } else if (clientApp.getRealm() != null && clientApp.getRealm().getAttrReleasePolicy() != null) {
                waClientApp.setAttrReleasePolicy((AttrReleasePolicyTO)this.policyDataBinder.getPolicyTO((Policy)clientApp.getRealm().getAttrReleasePolicy()));
            }
            if (clientApp.getTicketExpirationPolicy() != null) {
                waClientApp.setTicketExpirationPolicy((TicketExpirationPolicyTO)this.policyDataBinder.getPolicyTO((Policy)clientApp.getTicketExpirationPolicy()));
            } else if (clientApp.getRealm() != null && clientApp.getRealm().getTicketExpirationPolicy() != null) {
                waClientApp.setTicketExpirationPolicy((TicketExpirationPolicyTO)this.policyDataBinder.getPolicyTO((Policy)clientApp.getRealm().getTicketExpirationPolicy()));
            }
        }
        catch (Exception e) {
            LOG.error("While building the configuration from an application's policy ", (Throwable)e);
        }
        return waClientApp;
    }
}

