/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestWrapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

class ApplicationRequest
extends ServletRequestWrapper {
    private static final Set<String> specialsSet = new HashSet<String>(Arrays.asList("jakarta.servlet.include.request_uri", "jakarta.servlet.include.context_path", "jakarta.servlet.include.servlet_path", "jakarta.servlet.include.path_info", "jakarta.servlet.include.query_string", "jakarta.servlet.include.mapping", "jakarta.servlet.forward.request_uri", "jakarta.servlet.forward.context_path", "jakarta.servlet.forward.servlet_path", "jakarta.servlet.forward.path_info", "jakarta.servlet.forward.query_string", "jakarta.servlet.forward.mapping"));
    private static final int shortestSpecialNameLength = specialsSet.stream().mapToInt(String::length).min().getAsInt();
    protected final HashMap<String, Object> attributes = new HashMap();

    ApplicationRequest(ServletRequest request) {
        super(request);
        this.setRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        HashMap<String, Object> hashMap = this.attributes;
        synchronized (hashMap) {
            return this.attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<String> getAttributeNames() {
        HashMap<String, Object> hashMap = this.attributes;
        synchronized (hashMap) {
            return Collections.enumeration(this.attributes.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        HashMap<String, Object> hashMap = this.attributes;
        synchronized (hashMap) {
            this.attributes.remove(name);
            if (!this.isSpecial(name)) {
                this.getRequest().removeAttribute(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        HashMap<String, Object> hashMap = this.attributes;
        synchronized (hashMap) {
            this.attributes.put(name, value);
            if (!this.isSpecial(name)) {
                this.getRequest().setAttribute(name, value);
            }
        }
    }

    private boolean isSpecial(String name) {
        if (name.length() < shortestSpecialNameLength) {
            return false;
        }
        return specialsSet.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequest(ServletRequest request) {
        super.setRequest(request);
        HashMap<String, Object> hashMap = this.attributes;
        synchronized (hashMap) {
            this.attributes.clear();
            Enumeration names = request.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                Object value = request.getAttribute(name);
                this.attributes.put(name, value);
            }
        }
    }
}

