/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationOverlayImpl;
import org.jboss.jandex.AnnotationTransformation;
import org.jboss.jandex.Declaration;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public interface AnnotationOverlay {
    public static Builder builder(IndexView index, Collection<AnnotationTransformation> annotationTransformations) {
        Objects.requireNonNull(index);
        if (annotationTransformations == null) {
            annotationTransformations = Collections.emptyList();
        }
        return new Builder(index, annotationTransformations);
    }

    public IndexView index();

    public boolean hasAnnotation(Declaration var1, DotName var2);

    default public boolean hasAnnotation(Declaration declaration, Class<? extends Annotation> clazz) {
        return this.hasAnnotation(declaration, DotName.createSimple(clazz.getName()));
    }

    public boolean hasAnyAnnotation(Declaration var1, Set<DotName> var2);

    default public boolean hasAnyAnnotation(Declaration declaration, Class<? extends Annotation> ... classes) {
        HashSet<DotName> names = new HashSet<DotName>(classes.length);
        for (Class<? extends Annotation> clazz : classes) {
            names.add(DotName.createSimple(clazz.getName()));
        }
        return this.hasAnyAnnotation(declaration, names);
    }

    public AnnotationInstance annotation(Declaration var1, DotName var2);

    default public AnnotationInstance annotation(Declaration declaration, Class<? extends Annotation> clazz) {
        return this.annotation(declaration, DotName.createSimple(clazz.getName()));
    }

    public Collection<AnnotationInstance> annotationsWithRepeatable(Declaration var1, DotName var2);

    default public Collection<AnnotationInstance> annotationsWithRepeatable(Declaration declaration, Class<? extends Annotation> clazz) {
        return this.annotationsWithRepeatable(declaration, DotName.createSimple(clazz.getName()));
    }

    public Collection<AnnotationInstance> annotations(Declaration var1);

    public static final class Builder {
        private final IndexView index;
        private final Collection<AnnotationTransformation> annotationTransformations;
        private boolean compatibleMode;
        private boolean runtimeAnnotationsOnly;
        private boolean inheritedAnnotations;

        Builder(IndexView index, Collection<AnnotationTransformation> annotationTransformations) {
            this.index = index;
            this.annotationTransformations = annotationTransformations;
        }

        public Builder compatibleMode() {
            this.compatibleMode = true;
            return this;
        }

        public Builder runtimeAnnotationsOnly() {
            this.runtimeAnnotationsOnly = true;
            return this;
        }

        public Builder inheritedAnnotations() {
            this.inheritedAnnotations = true;
            return this;
        }

        public AnnotationOverlay build() {
            return new AnnotationOverlayImpl(this.index, this.compatibleMode, this.runtimeAnnotationsOnly, this.inheritedAnnotations, this.annotationTransformations);
        }
    }
}

