/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.executor;

import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.batchee.container.services.executor.AbstractThreadPoolService;
import org.apache.batchee.container.services.executor.BatcheeThreadFactory;

public class BoundedThreadPoolService
extends AbstractThreadPoolService {
    public static final String BOUNDED_THREADPOOL_MAX_POOL_SIZE = "BOUNDED_THREADPOOL_MAX_POOL_SIZE";
    public static final String BOUNDED_THREADPOOL_MIN_POOL_SIZE = "BOUNDED_THREADPOOL_MIN_POOL_SIZE";
    public static final String BOUNDED_THREADPOOL_KEEP_ALIVE_TIME = "BOUNDED_THREADPOOL_KEEP_ALIVE_TIME";
    public static final String BOUNDED_THREADPOOL_QUEUE_SIZE = "BOUNDED_THREADPOOL_QUEUE_SIZE";

    @Override
    protected ExecutorService newExecutorService(Properties batchConfig) {
        return new ThreadPoolExecutor(BoundedThreadPoolService.getInt(batchConfig, BOUNDED_THREADPOOL_MIN_POOL_SIZE, "3"), BoundedThreadPoolService.getInt(batchConfig, BOUNDED_THREADPOOL_MAX_POOL_SIZE, "10"), (long)BoundedThreadPoolService.getInt(batchConfig, BOUNDED_THREADPOOL_KEEP_ALIVE_TIME, "900"), TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(BoundedThreadPoolService.getInt(batchConfig, BOUNDED_THREADPOOL_QUEUE_SIZE, "4096")), BatcheeThreadFactory.INSTANCE);
    }

    private static int getInt(Properties batchConfig, String key, String defaultValue) {
        return Integer.parseInt(batchConfig.getProperty(key, defaultValue));
    }
}

