/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import jakarta.enterprise.inject.spi.AnnotatedMember;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.Producer;
import java.util.HashSet;
import java.util.Set;
import org.apache.webbeans.component.creation.BaseProducerFactory;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.portable.ProducerMethodProducer;
import org.apache.webbeans.util.Asserts;

public class MethodProducerFactory<P>
extends BaseProducerFactory<P> {
    private AnnotatedMethod<? super P> producerMethod;

    public MethodProducerFactory(AnnotatedMethod<? super P> producerMethod, Bean<P> parent, WebBeansContext webBeansContext) {
        super(parent, webBeansContext);
        Asserts.assertNotNull(producerMethod, "producer method");
        this.producerMethod = producerMethod;
        this.defineDisposalMethod();
    }

    @Override
    protected AnnotatedMember<? super P> producerType() {
        return this.producerMethod;
    }

    public Class<?> getReturnType() {
        return this.producerMethod.getJavaMember().getReturnType();
    }

    public <T> Producer<T> createProducer(Bean<T> bean) {
        Set<InjectionPoint> disposalIPs = this.getInjectionPoints(bean);
        ProducerMethodProducer producer = new ProducerMethodProducer(this.parent, this.producerMethod, this.disposalMethod, this.createInjectionPoints(bean), disposalIPs, this.webBeansContext);
        return this.webBeansContext.getWebBeansUtil().fireProcessProducerEvent(producer, (AnnotatedMember<?>)this.producerMethod);
    }

    protected Set<InjectionPoint> createInjectionPoints(Bean<?> bean) {
        return new HashSet<InjectionPoint>(this.webBeansContext.getInjectionPointFactory().buildInjectionPoints(bean, this.producerMethod));
    }
}

