/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.util.internal;

import org.python.netty.util.internal.PlatformDependent;

public final class ClassInitializerUtil {
    private ClassInitializerUtil() {
    }

    public static void tryLoadClasses(Class<?> loadingClass, Class<?> ... classes) {
        ClassLoader loader2 = PlatformDependent.getClassLoader(loadingClass);
        for (Class<?> clazz : classes) {
            ClassInitializerUtil.tryLoadClass(loader2, clazz.getName());
        }
    }

    private static void tryLoadClass(ClassLoader classLoader, String className) {
        try {
            Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

