/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security;

import org.apache.fulcrum.security.acl.AccessControlList;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.GroupSet;
import org.apache.fulcrum.security.util.PasswordMismatchException;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.turbine.om.security.DefaultUserImpl;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.Service;
import org.apache.turbine.services.security.UserManager;
import org.apache.turbine.services.security.passive.PassiveUserManager;

public interface SecurityService
extends Service {
    public static final String SERVICE_NAME = "SecurityService";
    public static final String USER_MANAGER_KEY = "user.manager";
    public static final String USER_MANAGER_DEFAULT = PassiveUserManager.class.getName();
    public static final String USER_WRAPPER_KEY = "wrapper.class";
    public static final String USER_WRAPPER_DEFAULT = DefaultUserImpl.class.getName();

    public <U extends User> U getUserInstance() throws UnknownEntityException;

    public <U extends User> U getUserInstance(String var1) throws UnknownEntityException;

    public <G extends Group> G getGroupInstance() throws UnknownEntityException;

    public <G extends Group> G getGroupInstance(String var1) throws UnknownEntityException;

    public <P extends Permission> P getPermissionInstance() throws UnknownEntityException;

    public <P extends Permission> P getPermissionInstance(String var1) throws UnknownEntityException;

    public <R extends Role> R getRoleInstance() throws UnknownEntityException;

    public <R extends Role> R getRoleInstance(String var1) throws UnknownEntityException;

    public UserManager getUserManager();

    public boolean accountExists(String var1) throws DataBackendException;

    public boolean accountExists(User var1) throws DataBackendException;

    public <U extends User> U getAuthenticatedUser(String var1, String var2) throws DataBackendException, UnknownEntityException, PasswordMismatchException;

    public <U extends User> U getUser(String var1) throws DataBackendException, UnknownEntityException;

    public <U extends User> U getAnonymousUser() throws UnknownEntityException;

    public boolean isAnonymousUser(User var1);

    public void saveUser(User var1) throws UnknownEntityException, DataBackendException;

    public void saveOnSessionUnbind(User var1) throws UnknownEntityException, DataBackendException;

    public void addUser(User var1, String var2) throws DataBackendException, EntityExistsException, UnknownEntityException;

    public void removeUser(User var1) throws DataBackendException, UnknownEntityException;

    public void changePassword(User var1, String var2, String var3) throws PasswordMismatchException, UnknownEntityException, DataBackendException;

    public void forcePassword(User var1, String var2) throws UnknownEntityException, DataBackendException;

    public <A extends AccessControlList> A getACL(User var1) throws DataBackendException, UnknownEntityException;

    public PermissionSet getPermissions(Role var1) throws DataBackendException, UnknownEntityException;

    public void grant(User var1, Group var2, Role var3) throws DataBackendException, UnknownEntityException;

    public void revoke(User var1, Group var2, Role var3) throws DataBackendException, UnknownEntityException;

    public void revokeAll(User var1) throws DataBackendException, UnknownEntityException;

    public void grant(Role var1, Permission var2) throws DataBackendException, UnknownEntityException;

    public void revoke(Role var1, Permission var2) throws DataBackendException, UnknownEntityException;

    public void revokeAll(Role var1) throws DataBackendException, UnknownEntityException;

    public void revokeAll(Role var1, boolean var2) throws DataBackendException, UnknownEntityException;

    public <G extends Group> G getGlobalGroup();

    public <G extends Group> G getGroupByName(String var1) throws DataBackendException, UnknownEntityException;

    public <G extends Group> G getGroupById(int var1) throws DataBackendException, UnknownEntityException;

    public <R extends Role> R getRoleByName(String var1) throws DataBackendException, UnknownEntityException;

    public <R extends Role> R getRoleById(int var1) throws DataBackendException, UnknownEntityException;

    public <P extends Permission> P getPermissionByName(String var1) throws DataBackendException, UnknownEntityException;

    public <P extends Permission> P getPermissionById(int var1) throws DataBackendException, UnknownEntityException;

    public GroupSet getAllGroups() throws DataBackendException;

    public RoleSet getAllRoles() throws DataBackendException;

    public PermissionSet getAllPermissions() throws DataBackendException;

    public <G extends Group> G addGroup(G var1) throws DataBackendException, EntityExistsException;

    public <R extends Role> R addRole(R var1) throws DataBackendException, EntityExistsException;

    public <P extends Permission> P addPermission(P var1) throws DataBackendException, EntityExistsException;

    public void removeGroup(Group var1) throws DataBackendException, UnknownEntityException;

    public void removeRole(Role var1) throws DataBackendException, UnknownEntityException;

    public void removePermission(Permission var1) throws DataBackendException, UnknownEntityException;

    public void renameGroup(Group var1, String var2) throws DataBackendException, UnknownEntityException;

    public void renameRole(Role var1, String var2) throws DataBackendException, UnknownEntityException;

    public void renamePermission(Permission var1, String var2) throws DataBackendException, UnknownEntityException;

    public void replaceRole(User var1, Role var2, Role var3) throws DataBackendException, UnknownEntityException;
}

