/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.transport;

import java.util.ArrayList;
import org.apache.vinci.transport.Frame;
import org.apache.vinci.transport.FrameComponent;
import org.apache.vinci.transport.FrameLeaf;
import org.apache.vinci.transport.KeyValuePair;
import org.apache.vinci.transport.QueryableFrame;
import org.apache.vinci.transport.Transportable;
import org.apache.vinci.transport.TransportableFactory;
import org.apache.vinci.transport.util.TransportableConverter;

public class VinciFrame
extends QueryableFrame {
    private int capacity;
    private int size;
    private KeyValuePair[] elements;
    private static TransportableFactory vinciFrameFactory = new TransportableFactory(){

        @Override
        public Transportable makeTransportable() {
            return new VinciFrame();
        }
    };

    public static TransportableFactory getVinciFrameFactory() {
        return vinciFrameFactory;
    }

    public VinciFrame() {
        this(10);
    }

    public static VinciFrame toVinciFrame(Transportable t) {
        return (VinciFrame)TransportableConverter.convert(t, VinciFrame.getVinciFrameFactory());
    }

    public VinciFrame(int initialCapacity) {
        this.capacity = initialCapacity;
        this.size = 0;
        this.elements = new KeyValuePair[this.capacity];
    }

    public ArrayList fkeys() {
        ArrayList<String> rval = new ArrayList<String>();
        for (int i = 0; i < this.size; ++i) {
            String key = this.elements[i].key;
            if (rval.contains(key)) continue;
            rval.add(key);
        }
        return rval;
    }

    @Override
    public ArrayList fget(String key) {
        ArrayList<FrameComponent> return_me = new ArrayList<FrameComponent>();
        for (int i = 0; i < this.size; ++i) {
            KeyValuePair pair = this.elements[i];
            if (!pair.key.equals(key)) continue;
            return_me.add(pair.value);
        }
        return return_me;
    }

    @Override
    public FrameComponent fgetFirst(String key) {
        for (int i = 0; i < this.size; ++i) {
            KeyValuePair pair = this.elements[i];
            if (!pair.key.equals(key)) continue;
            return pair.value;
        }
        return null;
    }

    @Override
    public Frame createSubFrame(String tag_name, int initialCapacity) {
        return new VinciFrame(initialCapacity);
    }

    public VinciFrame fgetVinciFrame(String key) {
        return (VinciFrame)this.fgetFirst(key);
    }

    public VinciFrame fset(String key, String val) {
        this.set(key, new FrameLeaf(val));
        return this;
    }

    public VinciFrame fset(String key, long val) {
        this.set(key, new FrameLeaf(val));
        return this;
    }

    public VinciFrame fset(String key, boolean val) {
        this.set(key, new FrameLeaf(val));
        return this;
    }

    public VinciFrame fset(String key, int val) {
        this.set(key, new FrameLeaf(val));
        return this;
    }

    public VinciFrame fset(String key, int[] val) {
        this.set(key, new FrameLeaf(val));
        return this;
    }

    public VinciFrame fset(String key, Frame val) {
        this.set(key, val);
        return this;
    }

    public VinciFrame fset(String key, double val) {
        this.set(key, new FrameLeaf(val));
        return this;
    }

    public VinciFrame fset(String key, byte[] bin) {
        this.set(key, new FrameLeaf(bin, true));
        return this;
    }

    public VinciFrame fsetTrueBinary(String key, byte[] bin) {
        this.set(key, new FrameLeaf(bin, false));
        return this;
    }

    protected void set(String key, FrameComponent val) {
        if (val != null) {
            for (int i = 0; i < this.size; ++i) {
                KeyValuePair pair = this.elements[i];
                if (!pair.key.equals(key)) continue;
                pair.value = val;
                return;
            }
        } else {
            throw new NullPointerException();
        }
        this.add(key, val);
    }

    public VinciFrame fdropFirst(String key) {
        for (int i = 0; i < this.size; ++i) {
            KeyValuePair pair = this.elements[i];
            if (!pair.key.equals(key)) continue;
            System.arraycopy(this.elements, i + 1, this.elements, i, this.size - i - 1);
            --this.size;
            this.elements[this.size] = null;
            break;
        }
        return this;
    }

    public VinciFrame fdrop(String key) {
        int i;
        int shift = 0;
        for (i = 0; i < this.size; ++i) {
            if (shift != 0) {
                this.elements[i] = this.elements[i + shift];
            }
            KeyValuePair pair = this.elements[i];
            if (!pair.key.equals(key)) continue;
            ++shift;
            --this.size;
            --i;
        }
        for (i = 0; i < shift; ++i) {
            this.elements[this.size + i] = null;
        }
        return this;
    }

    public void freset() {
        if (this.capacity > 10) {
            this.capacity = 10;
        }
        this.elements = new KeyValuePair[this.capacity];
        this.size = 0;
    }

    @Override
    public void add(String key, FrameComponent val) {
        if (val != null) {
            this.ensureCapacity();
            this.elements[this.size++] = new KeyValuePair(key, val);
        }
    }

    protected void ensureCapacity() {
        if (this.size == this.capacity) {
            KeyValuePair[] old = this.elements;
            int newCapacity = this.capacity * 3 / 2 + 1;
            this.elements = new KeyValuePair[newCapacity];
            System.arraycopy(old, 0, this.elements, 0, this.size);
            this.capacity = newCapacity;
        }
    }

    @Override
    public KeyValuePair getKeyValuePair(int which) {
        return this.elements[which];
    }

    @Override
    public int getKeyValuePairCount() {
        return this.size;
    }

    public boolean stripWhitespace() {
        int i;
        boolean returnMe = false;
        int shift = 0;
        for (i = 0; i < this.size; ++i) {
            KeyValuePair pair;
            if (shift != 0) {
                this.elements[i] = this.elements[i + shift];
            }
            if ((pair = this.elements[i]).isValueALeaf()) {
                if (!pair.key.equals("")) continue;
                String checkForWhitespace = pair.getValueAsString();
                boolean isAllWhitespace = true;
                for (int j = 0; j < checkForWhitespace.length(); ++j) {
                    if (Character.isWhitespace(checkForWhitespace.charAt(j))) continue;
                    isAllWhitespace = false;
                    break;
                }
                if (!isAllWhitespace) continue;
                returnMe = true;
                ++shift;
                --this.size;
                --i;
                continue;
            }
            if (!((VinciFrame)pair.getValueAsFrame()).stripWhitespace()) continue;
            returnMe = true;
        }
        for (i = 0; i < shift; ++i) {
            this.elements[this.size + i] = null;
        }
        return returnMe;
    }
}

