/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup;

import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.core.util.resource.locator.IResourceStreamLocator;
import org.apache.wicket.markup.ContainerInfo;
import org.apache.wicket.markup.IMarkupResourceStreamProvider;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.MarkupType;
import org.apache.wicket.util.resource.IResourceStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMarkupResourceStreamProvider
implements IMarkupResourceStreamProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultMarkupResourceStreamProvider.class);

    @Override
    public IResourceStream getMarkupResourceStream(MarkupContainer container, Class<?> containerClass) {
        String ext;
        IResourceStreamLocator locator = Application.get().getResourceSettings().getResourceStreamLocator();
        String style = container.getStyle();
        String variation = container.getVariation();
        Locale locale = container.getLocale();
        MarkupType markupType = container.getMarkupType();
        String string = ext = markupType != null ? markupType.getExtension() : null;
        while (containerClass != MarkupContainer.class) {
            String path = containerClass.getName().replace('.', '/');
            IResourceStream resourceStream = locator.locate(containerClass, path, style, variation, locale, ext, false);
            if (resourceStream != null) {
                return new MarkupResourceStream(resourceStream, new ContainerInfo(containerClass, container), containerClass);
            }
            containerClass = containerClass.getSuperclass();
        }
        return null;
    }
}

