/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.mock;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.wicket.MetaDataEntry;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.pageStore.IPageContext;

public class MockPageContext
implements IPageContext {
    final String sessionId;
    MetaDataEntry<?>[] requestData;
    MetaDataEntry<?>[] sessionData;
    Map<String, Object> sessionAttributes = new HashMap<String, Object>();

    public MockPageContext() {
        this("dummy_id");
    }

    public MockPageContext(String sessionId) {
        this.sessionId = sessionId;
    }

    @Override
    public <T> T getRequestData(MetaDataKey<T> key, Supplier<T> defaultValue) {
        T value = key.get(this.requestData);
        if (value == null && (value = defaultValue.get()) != null) {
            this.requestData = key.set(this.requestData, value);
        }
        return value;
    }

    @Override
    public <T extends Serializable> T getSessionAttribute(String key, Supplier<T> defaultValue) {
        Serializable value = (Serializable)this.sessionAttributes.get(key);
        if (value == null && defaultValue != null) {
            value = (Serializable)defaultValue.get();
            this.sessionAttributes.put(key, value);
        }
        return (T)value;
    }

    @Override
    public <T extends Serializable> T getSessionData(MetaDataKey<T> key, Supplier<T> defaultValue) {
        Serializable value = (Serializable)key.get(this.sessionData);
        if (value == null && defaultValue != null) {
            value = (Serializable)defaultValue.get();
            this.sessionData = key.set(this.sessionData, value);
        }
        return (T)value;
    }

    @Override
    public String getSessionId(boolean bind) {
        return this.sessionId;
    }

    public void clearRequest() {
        this.requestData = null;
    }

    public void clearSession() {
        this.sessionAttributes.clear();
        this.sessionData = null;
    }
}

